<?php $__env->startSection('title', $event->title); ?>
<?php $__env->startSection('subtitle', 'Event Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <!-- Header -->
    <div class="flex flex-col lg:flex-row justify-between items-start lg:items-center gap-4">
        <div>
            <div class="flex items-center space-x-3 mb-2">
                <a href="<?php echo e(route('events.index')); ?>" class="text-gray-500 hover:text-gray-700">
                    <i class="fas fa-arrow-left"></i>
                </a>
                <h1 class="text-2xl font-bold text-gray-900"><?php echo e($event->title); ?></h1>
                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium 
                    <?php echo e($event->status === 'published' ? 'bg-green-100 text-green-800' : 
                       ($event->status === 'draft' ? 'bg-yellow-100 text-yellow-800' : 
                        ($event->status === 'cancelled' ? 'bg-red-100 text-red-800' : 'bg-blue-100 text-blue-800'))); ?>">
                    <?php echo e(ucfirst($event->status)); ?>

                </span>
            </div>
            <div class="flex items-center space-x-4 text-sm text-gray-600">
                <span>
                    <i class="fas fa-calendar mr-1"></i>
                    <?php echo e($event->start_datetime->format('M j, Y')); ?>

                </span>
                <span>
                    <i class="fas fa-clock mr-1"></i>
                    <?php echo e($event->start_datetime->format('g:i A')); ?> - <?php echo e($event->end_datetime->format('g:i A')); ?>

                </span>
                <?php if($event->location): ?>
                    <span>
                        <i class="fas fa-map-marker-alt mr-1"></i>
                        <?php echo e($event->location); ?>

                    </span>
                <?php endif; ?>
            </div>
        </div>
        
        <div class="flex items-center space-x-3">
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $event)): ?>
                <a href="<?php echo e(route('events.edit', $event)); ?>" 
                   class="inline-flex items-center px-4 py-2 bg-blue-600 text-white font-medium rounded-xl hover:bg-blue-700 transition-colors">
                    <i class="fas fa-edit mr-2"></i>
                    Edit Event
                </a>
            <?php endif; ?>
            
            <a href="<?php echo e(route('attendance.show', $event)); ?>" 
               class="inline-flex items-center px-4 py-2 bg-green-600 text-white font-medium rounded-xl hover:bg-green-700 transition-colors">
                <i class="fas fa-users mr-2"></i>
                View Attendance
            </a>
            
            <a href="<?php echo e(route('attendance.qr.show', $event)); ?>" 
               class="inline-flex items-center px-4 py-2 bg-purple-600 text-white font-medium rounded-xl hover:bg-purple-700 transition-colors">
                <i class="fas fa-qrcode mr-2"></i>
                QR Code
            </a>
        </div>
    </div>

    <!-- Event Stats -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
        <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-1">Total Attendance</p>
                    <p class="text-2xl font-bold text-blue-600"><?php echo e($event->attendances->count()); ?></p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-blue-500 to-cyan-600 rounded-xl flex items-center justify-center">
                    <i class="fas fa-users text-white"></i>
                </div>
            </div>
        </div>
        
        <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-1">Checked In</p>
                    <p class="text-2xl font-bold text-green-600"><?php echo e($event->attendances->whereNotNull('checked_in_at')->count()); ?></p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-green-500 to-emerald-600 rounded-xl flex items-center justify-center">
                    <i class="fas fa-check text-white"></i>
                </div>
            </div>
        </div>
        
        <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-1">QR Scans</p>
                    <p class="text-2xl font-bold text-purple-600"><?php echo e($event->attendances->where('attendance_method', 'qr_code')->count()); ?></p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-purple-500 to-pink-600 rounded-xl flex items-center justify-center">
                    <i class="fas fa-qrcode text-white"></i>
                </div>
            </div>
        </div>
        
        <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-1">Available Spots</p>
                    <p class="text-2xl font-bold text-orange-600">
                        <?php if($event->max_attendees): ?>
                            <?php echo e($event->max_attendees - $event->attendances->count()); ?>

                        <?php else: ?>
                            ∞
                        <?php endif; ?>
                    </p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-orange-500 to-red-600 rounded-xl flex items-center justify-center">
                    <i class="fas fa-chair text-white"></i>
                </div>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Event Details -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Description -->
            <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Event Description</h3>
                <?php if($event->description): ?>
                    <div class="prose prose-gray max-w-none">
                        <?php echo nl2br(e($event->description)); ?>

                    </div>
                <?php else: ?>
                    <p class="text-gray-500 italic">No description provided.</p>
                <?php endif; ?>
            </div>

            <!-- Special Instructions -->
            <?php if($event->special_instructions): ?>
                <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Special Instructions</h3>
                    <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-4">
                        <div class="prose prose-gray max-w-none">
                            <?php echo nl2br(e($event->special_instructions)); ?>

                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Required Items -->
            <?php if($event->required_items && count($event->required_items) > 0): ?>
                <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Required Items</h3>
                    <ul class="space-y-2">
                        <?php $__currentLoopData = $event->required_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="flex items-center">
                                <i class="fas fa-check-circle text-green-500 mr-2"></i>
                                <?php echo e($item); ?>

                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            <!-- Recent Attendees -->
            <?php if($event->attendances->count() > 0): ?>
                <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-6">
                    <div class="flex items-center justify-between mb-4">
                        <h3 class="text-lg font-semibold text-gray-900">Recent Attendees</h3>
                        <a href="<?php echo e(route('attendance.show', $event)); ?>" class="text-blue-600 hover:text-blue-700 text-sm font-medium">
                            View All →
                        </a>
                    </div>
                    <div class="space-y-3">
                        <?php $__currentLoopData = $event->attendances->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attendance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="flex items-center justify-between py-2 border-b border-gray-100 last:border-0">
                                <div class="flex items-center space-x-3">
                                    <?php if($attendance->member->photo): ?>
                                        <img class="h-8 w-8 rounded-full object-cover" src="<?php echo e(asset('storage/' . $attendance->member->photo)); ?>" alt="<?php echo e($attendance->member->full_name); ?>">
                                    <?php else: ?>
                                        <div class="h-8 w-8 rounded-full bg-gradient-to-br from-blue-500 to-purple-600 flex items-center justify-center">
                                            <span class="text-white font-medium text-xs"><?php echo e(substr($attendance->member->first_name, 0, 1)); ?><?php echo e(substr($attendance->member->last_name, 0, 1)); ?></span>
                                        </div>
                                    <?php endif; ?>
                                    <div>
                                        <p class="text-sm font-medium text-gray-900"><?php echo e($attendance->member->full_name); ?></p>
                                        <p class="text-xs text-gray-500">
                                            <?php if($attendance->checked_in_at): ?>
                                                Checked in <?php echo e($attendance->checked_in_at->format('g:i A')); ?>

                                            <?php else: ?>
                                                Registered
                                            <?php endif; ?>
                                        </p>
                                    </div>
                                </div>
                                <div class="flex items-center space-x-2">
                                    <?php if($attendance->attendance_method === 'qr_code'): ?>
                                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-purple-100 text-purple-800">
                                            <i class="fas fa-qrcode mr-1"></i>
                                            QR
                                        </span>
                                    <?php else: ?>
                                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-gray-100 text-gray-800">
                                            Manual
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>

        <!-- Event Info Sidebar -->
        <div class="space-y-6">
            <!-- Event Details Card -->
            <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Event Information</h3>
                <div class="space-y-4">
                    <div>
                        <label class="text-sm font-medium text-gray-600">Event Type</label>
                        <p class="text-gray-900 capitalize"><?php echo e(str_replace('_', ' ', $event->event_type)); ?></p>
                    </div>
                    
                    <?php if($event->ministry): ?>
                        <div>
                            <label class="text-sm font-medium text-gray-600">Ministry</label>
                            <p class="text-gray-900"><?php echo e($event->ministry->name); ?></p>
                        </div>
                    <?php endif; ?>
                    
                    <?php if($event->organizer): ?>
                        <div>
                            <label class="text-sm font-medium text-gray-600">Organizer</label>
                            <p class="text-gray-900"><?php echo e($event->organizer->full_name); ?></p>
                        </div>
                    <?php endif; ?>
                    
                    <?php if($event->max_attendees): ?>
                        <div>
                            <label class="text-sm font-medium text-gray-600">Max Attendees</label>
                            <p class="text-gray-900"><?php echo e($event->max_attendees); ?></p>
                        </div>
                    <?php endif; ?>
                    
                    <?php if($event->registration_fee): ?>
                        <div>
                            <label class="text-sm font-medium text-gray-600">Registration Fee</label>
                            <p class="text-gray-900">₵<?php echo e(number_format($event->registration_fee, 2)); ?></p>
                        </div>
                    <?php endif; ?>
                    
                    <?php if($event->registration_deadline): ?>
                        <div>
                            <label class="text-sm font-medium text-gray-600">Registration Deadline</label>
                            <p class="text-gray-900"><?php echo e($event->registration_deadline->format('M j, Y g:i A')); ?></p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- QR Code Quick Actions -->
            <div class="bg-gradient-to-br from-purple-50 to-pink-50 rounded-2xl border border-purple-100 p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">QR Attendance</h3>
                <div class="space-y-3">
                    <a href="<?php echo e(route('attendance.qr.show', $event)); ?>" 
                       class="w-full inline-flex items-center justify-center px-4 py-3 bg-purple-600 text-white font-medium rounded-xl hover:bg-purple-700 transition-colors">
                        <i class="fas fa-qrcode mr-2"></i>
                        Display QR Code
                    </a>
                    
                    <button onclick="generateQrCode()" 
                            class="w-full inline-flex items-center justify-center px-4 py-2 bg-white border border-purple-300 text-purple-700 font-medium rounded-xl hover:bg-purple-50 transition-colors">
                        <i class="fas fa-sync-alt mr-2"></i>
                        Generate New QR
                    </button>
                    
                    <a href="<?php echo e(route('attendance.show', $event)); ?>" 
                       class="w-full inline-flex items-center justify-center px-4 py-2 bg-white border border-purple-300 text-purple-700 font-medium rounded-xl hover:bg-purple-50 transition-colors">
                        <i class="fas fa-list mr-2"></i>
                        Manage Attendance
                    </a>
                </div>
            </div>

            <!-- Event Actions -->
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $event)): ?>
                <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Actions</h3>
                    <div class="space-y-3">
                        <a href="<?php echo e(route('events.edit', $event)); ?>" 
                           class="w-full inline-flex items-center justify-center px-4 py-2 bg-blue-600 text-white font-medium rounded-xl hover:bg-blue-700 transition-colors">
                            <i class="fas fa-edit mr-2"></i>
                            Edit Event
                        </a>
                        
                        <?php if($event->status === 'draft'): ?>
                            <button onclick="publishEvent()" 
                                    class="w-full inline-flex items-center justify-center px-4 py-2 bg-green-600 text-white font-medium rounded-xl hover:bg-green-700 transition-colors">
                                <i class="fas fa-check mr-2"></i>
                                Publish Event
                            </button>
                        <?php endif; ?>
                        
                        <button onclick="deleteEvent()" 
                                class="w-full inline-flex items-center justify-center px-4 py-2 bg-red-600 text-white font-medium rounded-xl hover:bg-red-700 transition-colors">
                            <i class="fas fa-trash mr-2"></i>
                            Delete Event
                        </button>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
function generateQrCode() {
    fetch(`<?php echo e(route('attendance.qr.generate', $event)); ?>`, {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({
            expiration_hours: 24
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            window.location.href = `<?php echo e(route('attendance.qr.show', $event)); ?>`;
        } else {
            alert(data.message);
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('An error occurred while generating QR code');
    });
}

function publishEvent() {
    if (confirm('Are you sure you want to publish this event?')) {
        // Implementation for publishing event
        alert('Event publishing functionality will be implemented');
    }
}

function deleteEvent() {
    if (confirm('Are you sure you want to delete this event? This action cannot be undone.')) {
        // Implementation for deleting event
        alert('Event deletion functionality will be implemented');
    }
}
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('components.app-layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/presby_app/resources/views/events/show.blade.php ENDPATH**/ ?>