<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Members Export</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 10px;
            margin: 0;
            padding: 20px;
        }
        
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 15px;
        }
        
        .header h1 {
            margin: 0;
            font-size: 24px;
            color: #333;
        }
        
        .header p {
            margin: 5px 0 0 0;
            color: #666;
            font-size: 12px;
        }
        
        .stats {
            display: flex;
            justify-content: space-around;
            margin-bottom: 20px;
            background-color: #f8f9fa;
            padding: 10px;
            border-radius: 5px;
        }
        
        .stat-item {
            text-align: center;
        }
        
        .stat-number {
            font-size: 18px;
            font-weight: bold;
            color: #2563eb;
        }
        
        .stat-label {
            font-size: 10px;
            color: #666;
            margin-top: 2px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
            font-size: 8px;
        }
        
        th {
            background-color: #e2e8f0;
            color: #1e293b;
            font-weight: bold;
            padding: 8px 4px;
            text-align: left;
            border: 1px solid #cbd5e1;
        }
        
        td {
            padding: 6px 4px;
            border: 1px solid #e2e8f0;
            vertical-align: top;
        }
        
        tr:nth-child(even) {
            background-color: #f8fafc;
        }
        
        .status-active {
            color: #059669;
            font-weight: bold;
        }
        
        .status-inactive {
            color: #dc2626;
            font-weight: bold;
        }
        
        .type-member {
            background-color: #dbeafe;
            color: #1e40af;
            padding: 2px 4px;
            border-radius: 3px;
            font-size: 7px;
        }
        
        .type-visitor {
            background-color: #fef3c7;
            color: #92400e;
            padding: 2px 4px;
            border-radius: 3px;
            font-size: 7px;
        }
        
        .type-friend {
            background-color: #d1fae5;
            color: #065f46;
            padding: 2px 4px;
            border-radius: 3px;
            font-size: 7px;
        }
        
        .type-associate {
            background-color: #e0e7ff;
            color: #3730a3;
            padding: 2px 4px;
            border-radius: 3px;
            font-size: 7px;
        }
        
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 8px;
            color: #666;
            border-top: 1px solid #e2e8f0;
            padding-top: 10px;
        }
        
        .page-break {
            page-break-after: always;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Church Members Directory</h1>
        <p>Generated on <?php echo e(now()->format('F j, Y \a\t g:i A')); ?></p>
        <p>Total Members: <?php echo e($members->count()); ?></p>
    </div>

    <div class="stats">
        <div class="stat-item">
            <div class="stat-number"><?php echo e($members->where('membership_status', 'active')->count()); ?></div>
            <div class="stat-label">Active Members</div>
        </div>
        <div class="stat-item">
            <div class="stat-number"><?php echo e($members->where('membership_type', 'member')->count()); ?></div>
            <div class="stat-label">Full Members</div>
        </div>
        <div class="stat-item">
            <div class="stat-number"><?php echo e($members->where('gender', 'male')->count()); ?></div>
            <div class="stat-label">Male</div>
        </div>
        <div class="stat-item">
            <div class="stat-number"><?php echo e($members->where('gender', 'female')->count()); ?></div>
            <div class="stat-label">Female</div>
        </div>
        <div class="stat-item">
            <div class="stat-number"><?php echo e($members->groupBy('family_id')->count()); ?></div>
            <div class="stat-label">Families</div>
        </div>
    </div>

    <table>
        <thead>
            <tr>
                <th style="width: 8%;">ID</th>
                <th style="width: 15%;">Name</th>
                <th style="width: 12%;">Contact</th>
                <th style="width: 6%;">Gender</th>
                <th style="width: 8%;">Age</th>
                <th style="width: 15%;">Address</th>
                <th style="width: 12%;">Family</th>
                <th style="width: 8%;">Status</th>
                <th style="width: 8%;">Type</th>
                <th style="width: 8%;">Joined</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $members; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($member->member_id); ?></td>
                    <td>
                        <strong><?php echo e($member->full_name); ?></strong>
                        <?php if($member->ministries->count() > 0): ?>
                            <br><small style="color: #666;"><?php echo e($member->ministries->pluck('name')->join(', ')); ?></small>
                        <?php endif; ?>
                    </td>
                    <td>
                        <?php if($member->email): ?>
                            <?php echo e($member->email); ?><br>
                        <?php endif; ?>
                        <?php if($member->phone): ?>
                            <?php echo e($member->phone); ?>

                        <?php endif; ?>
                    </td>
                    <td><?php echo e(ucfirst($member->gender ?? '')); ?></td>
                    <td>
                        <?php if($member->date_of_birth): ?>
                            <?php echo e(\Carbon\Carbon::parse($member->date_of_birth)->age); ?>

                        <?php endif; ?>
                    </td>
                    <td>
                        <?php if($member->address): ?>
                            <?php echo e($member->address); ?>

                            <?php if($member->city): ?>, <?php echo e($member->city); ?><?php endif; ?>
                            <?php if($member->state): ?>, <?php echo e($member->state); ?><?php endif; ?>
                        <?php endif; ?>
                    </td>
                    <td><?php echo e($member->family ? $member->family->family_name : ''); ?></td>
                    <td>
                        <span class="status-<?php echo e($member->membership_status); ?>">
                            <?php echo e(ucfirst($member->membership_status)); ?>

                        </span>
                    </td>
                    <td>
                        <span class="type-<?php echo e($member->membership_type); ?>">
                            <?php echo e(ucfirst($member->membership_type)); ?>

                        </span>
                    </td>
                    <td>
                        <?php if($member->membership_date): ?>
                            <?php echo e(\Carbon\Carbon::parse($member->membership_date)->format('M Y')); ?>

                        <?php endif; ?>
                    </td>
                </tr>
                
                <?php if(($index + 1) % 25 == 0 && $index + 1 < $members->count()): ?>
                    </tbody>
                    </table>
                    <div class="page-break"></div>
                    <table>
                        <thead>
                            <tr>
                                <th style="width: 8%;">ID</th>
                                <th style="width: 15%;">Name</th>
                                <th style="width: 12%;">Contact</th>
                                <th style="width: 6%;">Gender</th>
                                <th style="width: 8%;">Age</th>
                                <th style="width: 15%;">Address</th>
                                <th style="width: 12%;">Family</th>
                                <th style="width: 8%;">Status</th>
                                <th style="width: 8%;">Type</th>
                                <th style="width: 8%;">Joined</th>
                            </tr>
                        </thead>
                        <tbody>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <div class="footer">
        <p>This report contains <?php echo e($members->count()); ?> members across <?php echo e($members->groupBy('family_id')->count()); ?> families.</p>
        <p>Generated by Church Management System | <?php echo e(config('app.name')); ?></p>
    </div>
</body>
</html>
<?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/presby_app/resources/views/exports/members-pdf.blade.php ENDPATH**/ ?>