<?php $__env->startSection('title', 'Church Settings'); ?>
<?php $__env->startSection('subtitle', 'Configure church information, branding, and system preferences'); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-white rounded-lg shadow-sm p-6">
    <div class="mb-6 bg-gradient-to-r from-blue-600 to-red-600 rounded-xl p-6 text-white">
        <h2 class="text-2xl font-bold mb-2 flex items-center">
            <i class="fas fa-cog mr-3"></i>
            Church Management Settings
        </h2>
        <p class="text-blue-100">Configure your church's information, branding, contact details, and system preferences all in one place.</p>
    </div>

    <?php if(session('success')): ?>
        <div class="mb-4 p-4 bg-green-50 border-l-4 border-green-500 text-green-700">
            <div class="flex">
                <div class="flex-shrink-0">
                    <i class="fas fa-check-circle"></i>
                </div>
                <div class="ml-3">
                    <p class="text-sm"><?php echo e(session('success')); ?></p>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php if(session('error')): ?>
        <div class="mb-4 p-4 bg-red-50 border-l-4 border-red-500 text-red-700">
            <div class="flex">
                <div class="flex-shrink-0">
                    <i class="fas fa-exclamation-circle"></i>
                </div>
                <div class="ml-3">
                    <p class="text-sm"><?php echo e(session('error')); ?></p>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <form action="<?php echo e(route('settings.general.update')); ?>" method="POST" enctype="multipart/form-data" class="space-y-6">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- Organization Information -->
            <div class="space-y-4 col-span-1 md:col-span-2">
                <h3 class="text-lg font-medium text-gray-900 flex items-center">
                    <i class="fas fa-building mr-2 text-blue-600"></i>
                    Organization Information
                </h3>
                
                <div>
                    <label for="organization_name" class="block text-sm font-medium text-gray-700 mb-1">Organization Name*</label>
                    <input type="text" name="organization_name" id="organization_name" 
                           value="<?php echo e($settings->where('key', 'organization_name')->first()->value ?? old('organization_name', 'Presbyterian Church of Ghana')); ?>" 
                           class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-500 focus:ring-opacity-50" 
                           required>
                    <?php $__errorArgs = ['organization_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                
                <div>
                    <label for="organization_slogan" class="block text-sm font-medium text-gray-700 mb-1">Slogan/Motto</label>
                    <input type="text" name="organization_slogan" id="organization_slogan" 
                           value="<?php echo e($settings->where('key', 'organization_slogan')->first()->value ?? old('organization_slogan')); ?>" 
                           class="w-full rounded-md border-gray-300 shadow-sm focus:border-primary-500 focus:ring focus:ring-primary-500 focus:ring-opacity-50"
                           placeholder="Enter your organization's slogan or motto">
                    <?php $__errorArgs = ['organization_slogan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div>
                    <label for="organization_description" class="block text-sm font-medium text-gray-700 mb-1">Description</label>
                    <textarea name="organization_description" id="organization_description" rows="3" 
                              class="w-full rounded-md border-gray-300 shadow-sm focus:border-primary-500 focus:ring focus:ring-primary-500 focus:ring-opacity-50"
                              placeholder="Brief description of your organization"><?php echo e($settings->where('key', 'organization_description')->first()->value ?? old('organization_description')); ?></textarea>
                    <?php $__errorArgs = ['organization_description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            
            <!-- Logo & Images Section -->
            <div class="space-y-6 col-span-1 md:col-span-2">
                <h3 class="text-lg font-medium text-gray-900 flex items-center">
                    <i class="fas fa-image mr-2 text-red-600"></i>
                    Organization Logo & Images
                </h3>
                
                <!-- Organization Logo -->
                <div class="bg-gray-50 p-4 rounded-lg">
                    <h4 class="font-medium text-gray-800 mb-3">Organization Logo</h4>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label for="organization_logo" class="block text-sm font-medium text-gray-700 mb-1">Upload Logo</label>
                            <input type="file" name="organization_logo" id="organization_logo" 
                                   class="w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-red-50 file:text-red-700 hover:file:bg-red-100">
                            <p class="mt-1 text-xs text-gray-500">Recommended size: 200x200px. Max 2MB. Formats: JPG, PNG, GIF.</p>
                            <?php $__errorArgs = ['organization_logo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <div>
                            <?php
                                $logoSetting = $settings->where('key', 'organization_logo')->first();
                            ?>
                            <?php if($logoSetting && $logoSetting->value): ?>
                                <div class="flex flex-col items-center">
                                    <p class="text-sm font-medium text-gray-700 mb-2">Current Logo</p>
                                    <img src="<?php echo e(asset('storage/' . $logoSetting->value)); ?>" alt="Organization Logo" class="max-h-24 max-w-24 object-contain border border-gray-200 rounded">
                                </div>
                            <?php else: ?>
                                <div class="flex flex-col items-center">
                                    <p class="text-sm font-medium text-gray-700 mb-2">No Logo Uploaded</p>
                                    <div class="w-24 h-24 bg-gray-100 rounded flex items-center justify-center">
                                        <i class="fas fa-church text-gray-400 text-3xl"></i>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                
                <!-- Login Background Image -->
                <div class="bg-gray-50 p-4 rounded-lg">
                    <h4 class="font-medium text-gray-800 mb-3">Login Background Image</h4>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label for="login_background_image" class="block text-sm font-medium text-gray-700 mb-1">Upload Background</label>
                            <input type="file" name="login_background_image" id="login_background_image" 
                                   class="w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100">
                            <p class="mt-1 text-xs text-gray-500">Recommended size: 1920x1080px. Max 5MB. Formats: JPG, PNG.</p>
                            <?php $__errorArgs = ['login_background_image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <div>
                            <?php
                                $backgroundSetting = $settings->where('key', 'login_background_image')->first();
                            ?>
                            <?php if($backgroundSetting && $backgroundSetting->value): ?>
                                <div class="flex flex-col items-center">
                                    <p class="text-sm font-medium text-gray-700 mb-2">Current Background</p>
                                    <img src="<?php echo e(asset('storage/' . $backgroundSetting->value)); ?>" alt="Login Background" class="max-h-24 max-w-32 object-cover border border-gray-200 rounded">
                                </div>
                            <?php else: ?>
                                <div class="flex flex-col items-center">
                                    <p class="text-sm font-medium text-gray-700 mb-2">No Background Uploaded</p>
                                    <div class="w-32 h-24 bg-gray-100 rounded flex items-center justify-center">
                                        <i class="fas fa-image text-gray-400 text-2xl"></i>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Contact Information -->
            <div class="space-y-4 col-span-1 md:col-span-2">
                <h3 class="text-lg font-medium text-gray-900 flex items-center">
                    <i class="fas fa-phone mr-2 text-blue-600"></i>
                    Contact Information
                </h3>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label for="organization_phone" class="block text-sm font-medium text-gray-700 mb-1">Phone Number</label>
                        <input type="tel" name="organization_phone" id="organization_phone" 
                               value="<?php echo e($settings->where('key', 'organization_phone')->first()->value ?? old('organization_phone')); ?>" 
                               class="w-full rounded-md border-gray-300 shadow-sm focus:border-primary-500 focus:ring focus:ring-primary-500 focus:ring-opacity-50"
                               placeholder="Enter phone number">
                        <?php $__errorArgs = ['organization_phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div>
                        <label for="organization_email" class="block text-sm font-medium text-gray-700 mb-1">Email Address</label>
                        <input type="email" name="organization_email" id="organization_email" 
                               value="<?php echo e($settings->where('key', 'organization_email')->first()->value ?? old('organization_email')); ?>" 
                               class="w-full rounded-md border-gray-300 shadow-sm focus:border-primary-500 focus:ring focus:ring-primary-500 focus:ring-opacity-50"
                               placeholder="Enter email address">
                        <?php $__errorArgs = ['organization_email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="col-span-1 md:col-span-2">
                        <label for="organization_website" class="block text-sm font-medium text-gray-700 mb-1">Website URL</label>
                        <input type="url" name="organization_website" id="organization_website" 
                               value="<?php echo e($settings->where('key', 'organization_website')->first()->value ?? old('organization_website')); ?>" 
                               class="w-full rounded-md border-gray-300 shadow-sm focus:border-primary-500 focus:ring focus:ring-primary-500 focus:ring-opacity-50"
                               placeholder="https://example.com">
                        <?php $__errorArgs = ['organization_website'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>

            <!-- Location Information -->
            <div class="space-y-4 col-span-1 md:col-span-2">
                <h3 class="text-lg font-medium text-gray-900 flex items-center">
                    <i class="fas fa-map-marker-alt mr-2 text-red-600"></i>
                    Location Information
                </h3>
                
                <div>
                    <label for="organization_address" class="block text-sm font-medium text-gray-700 mb-1">Street Address</label>
                    <textarea name="organization_address" id="organization_address" rows="3" 
                              class="w-full rounded-md border-gray-300 shadow-sm focus:border-primary-500 focus:ring focus:ring-primary-500 focus:ring-opacity-50"
                              placeholder="Enter street address"><?php echo e($settings->where('key', 'organization_address')->first()->value ?? old('organization_address')); ?></textarea>
                    <?php $__errorArgs = ['organization_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                    <div>
                        <label for="organization_city" class="block text-sm font-medium text-gray-700 mb-1">City</label>
                        <input type="text" name="organization_city" id="organization_city" 
                               value="<?php echo e($settings->where('key', 'organization_city')->first()->value ?? old('organization_city')); ?>" 
                               class="w-full rounded-md border-gray-300 shadow-sm focus:border-primary-500 focus:ring focus:ring-primary-500 focus:ring-opacity-50"
                               placeholder="Enter city">
                        <?php $__errorArgs = ['organization_city'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div>
                        <label for="organization_state" class="block text-sm font-medium text-gray-700 mb-1">State/Province</label>
                        <input type="text" name="organization_state" id="organization_state" 
                               value="<?php echo e($settings->where('key', 'organization_state')->first()->value ?? old('organization_state')); ?>" 
                               class="w-full rounded-md border-gray-300 shadow-sm focus:border-primary-500 focus:ring focus:ring-primary-500 focus:ring-opacity-50"
                               placeholder="Enter state/province">
                        <?php $__errorArgs = ['organization_state'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div>
                        <label for="organization_postal_code" class="block text-sm font-medium text-gray-700 mb-1">Postal Code</label>
                        <input type="text" name="organization_postal_code" id="organization_postal_code" 
                               value="<?php echo e($settings->where('key', 'organization_postal_code')->first()->value ?? old('organization_postal_code')); ?>" 
                               class="w-full rounded-md border-gray-300 shadow-sm focus:border-primary-500 focus:ring focus:ring-primary-500 focus:ring-opacity-50"
                               placeholder="Enter postal code">
                        <?php $__errorArgs = ['organization_postal_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div>
                        <label for="organization_country" class="block text-sm font-medium text-gray-700 mb-1">Country</label>
                        <input type="text" name="organization_country" id="organization_country" 
                               value="<?php echo e($settings->where('key', 'organization_country')->first()->value ?? old('organization_country')); ?>" 
                               class="w-full rounded-md border-gray-300 shadow-sm focus:border-primary-500 focus:ring focus:ring-primary-500 focus:ring-opacity-50"
                               placeholder="Enter country">
                        <?php $__errorArgs = ['organization_country'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>

            <!-- Branding Colors -->
            <div class="space-y-4 col-span-1 md:col-span-2">
                <h3 class="text-lg font-medium text-gray-900 flex items-center">
                    <i class="fas fa-palette mr-2 text-blue-600"></i>
                    Branding Colors
                </h3>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label for="primary_color" class="block text-sm font-medium text-gray-700 mb-1">Primary Color</label>
                        <div class="flex items-center space-x-2">
                            <input type="color" name="primary_color" id="primary_color" 
                                   value="<?php echo e($settings->where('key', 'primary_color')->first()->value ?? old('primary_color', '#3b82f6')); ?>" 
                                   class="h-10 w-16 rounded border border-gray-300 cursor-pointer">
                            <input type="text" 
                                   value="<?php echo e($settings->where('key', 'primary_color')->first()->value ?? old('primary_color', '#3b82f6')); ?>" 
                                   class="flex-1 rounded-md border-gray-300 shadow-sm focus:border-primary-500 focus:ring focus:ring-primary-500 focus:ring-opacity-50"
                                   readonly>
                        </div>
                        <?php $__errorArgs = ['primary_color'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div>
                        <label for="secondary_color" class="block text-sm font-medium text-gray-700 mb-1">Secondary Color</label>
                        <div class="flex items-center space-x-2">
                            <input type="color" name="secondary_color" id="secondary_color" 
                                   value="<?php echo e($settings->where('key', 'secondary_color')->first()->value ?? old('secondary_color', '#64748b')); ?>" 
                                   class="h-10 w-16 rounded border border-gray-300 cursor-pointer">
                            <input type="text" 
                                   value="<?php echo e($settings->where('key', 'secondary_color')->first()->value ?? old('secondary_color', '#64748b')); ?>" 
                                   class="flex-1 rounded-md border-gray-300 shadow-sm focus:border-primary-500 focus:ring focus:ring-primary-500 focus:ring-opacity-50"
                                   readonly>
                        </div>
                        <?php $__errorArgs = ['secondary_color'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                <p class="text-xs text-gray-500">These colors will be used throughout the system for branding consistency.</p>
            </div>

            <!-- Church Administration -->
            <div class="space-y-4 col-span-1 md:col-span-2">
                <h3 class="text-lg font-medium text-gray-900 flex items-center">
                    <i class="fas fa-church mr-2 text-red-600"></i>
                    Church Administration
                </h3>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label for="church_code" class="block text-sm font-medium text-gray-700 mb-1">Church Code</label>
                        <input type="text" name="church_code" id="church_code" 
                               value="<?php echo e($settings->where('key', 'church_code')->first()->value ?? old('church_code')); ?>" 
                               class="w-full rounded-md border-gray-300 shadow-sm focus:border-primary-500 focus:ring focus:ring-primary-500 focus:ring-opacity-50"
                               placeholder="e.g., BFC, SLCOE">
                        <p class="mt-1 text-xs text-gray-500">Unique identifier for your church</p>
                        <?php $__errorArgs = ['church_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div>
                        <label for="pastor_signature" class="block text-sm font-medium text-gray-700 mb-1">Pastor's Title</label>
                        <input type="text" name="pastor_signature" id="pastor_signature" 
                               value="<?php echo e($settings->where('key', 'pastor_signature')->first()->value ?? old('pastor_signature')); ?>" 
                               class="w-full rounded-md border-gray-300 shadow-sm focus:border-primary-500 focus:ring focus:ring-primary-500 focus:ring-opacity-50"
                               placeholder="e.g., Senior Pastor, Lead Pastor">
                        <p class="mt-1 text-xs text-gray-500">Title for official documents</p>
                        <?php $__errorArgs = ['pastor_signature'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>

            <!-- Bulletin & Document Settings -->
            <div class="space-y-4 col-span-1 md:col-span-2">
                <h3 class="text-lg font-medium text-gray-900 flex items-center">
                    <i class="fas fa-file-alt mr-2 text-blue-600"></i>
                    Bulletin & Document Settings
                </h3>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label for="bulletin_prefix" class="block text-sm font-medium text-gray-700 mb-1">Bulletin Number Prefix</label>
                        <input type="text" name="bulletin_prefix" id="bulletin_prefix" 
                               value="<?php echo e($settings->where('key', 'bulletin_prefix')->first()->value ?? old('bulletin_prefix')); ?>" 
                               class="w-full rounded-md border-gray-300 shadow-sm focus:border-primary-500 focus:ring focus:ring-primary-500 focus:ring-opacity-50"
                               placeholder="e.g., BUL-, DOC-">
                        <p class="mt-1 text-xs text-gray-500">Prefix for bulletin and document numbers</p>
                        <?php $__errorArgs = ['bulletin_prefix'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div>
                        <label for="bulletin_watermark" class="block text-sm font-medium text-gray-700 mb-1">Document Watermark</label>
                        <input type="text" name="bulletin_watermark" id="bulletin_watermark" 
                               value="<?php echo e($settings->where('key', 'bulletin_watermark')->first()->value ?? old('bulletin_watermark')); ?>" 
                               class="w-full rounded-md border-gray-300 shadow-sm focus:border-primary-500 focus:ring focus:ring-primary-500 focus:ring-opacity-50"
                               placeholder="e.g., CONFIDENTIAL, DRAFT">
                        <p class="mt-1 text-xs text-gray-500">Watermark text for documents</p>
                        <?php $__errorArgs = ['bulletin_watermark'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="col-span-1 md:col-span-2">
                        <label for="bulletin_footer" class="block text-sm font-medium text-gray-700 mb-1">Document Footer Text</label>
                        <textarea name="bulletin_footer" id="bulletin_footer" rows="2" 
                                  class="w-full rounded-md border-gray-300 shadow-sm focus:border-primary-500 focus:ring focus:ring-primary-500 focus:ring-opacity-50"
                                  placeholder="Footer text that appears on bulletins and documents"><?php echo e($settings->where('key', 'bulletin_footer')->first()->value ?? old('bulletin_footer')); ?></textarea>
                        <?php $__errorArgs = ['bulletin_footer'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>

            <!-- Member Management Settings -->
            <div class="space-y-4 col-span-1 md:col-span-2">
                <h3 class="text-lg font-medium text-gray-900 flex items-center">
                    <i class="fas fa-users mr-2 text-red-600"></i>
                    Member Management
                </h3>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label for="member_id_prefix" class="block text-sm font-medium text-gray-700 mb-1">Member ID Prefix</label>
                        <input type="text" name="member_id_prefix" id="member_id_prefix" 
                               value="<?php echo e($settings->where('key', 'member_id_prefix')->first()->value ?? old('member_id_prefix', 'PCG')); ?>" 
                               class="w-full rounded-md border-gray-300 shadow-sm focus:border-primary-500 focus:ring focus:ring-primary-500 focus:ring-opacity-50"
                               placeholder="PCG" maxlength="10">
                        <p class="mt-1 text-xs text-gray-500">Prefix for member IDs (e.g., PCG250001, PRESBY250001)</p>
                        <?php $__errorArgs = ['member_id_prefix'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Member ID Format</label>
                        <div class="w-full p-3 bg-gray-50 rounded-md border border-gray-300">
                            <span class="text-sm text-gray-600">
                                <strong>Format:</strong> PREFIX + YY + 0001<br>
                                <strong>Example:</strong> <span class="font-mono text-blue-600"><?php echo e($settings->where('key', 'member_id_prefix')->first()->value ?? 'PCG'); ?><?php echo e(substr(date('Y'), -2)); ?>0001</span>
                            </span>
                        </div>
                        <p class="mt-1 text-xs text-gray-500">Auto-generated format using prefix + year + sequence</p>
                    </div>
                </div>
            </div>

            <!-- Email Settings -->
            <div class="space-y-4 col-span-1 md:col-span-2">
                <h3 class="text-lg font-medium text-gray-900 flex items-center">
                    <i class="fas fa-envelope mr-2 text-blue-600"></i>
                    Email Configuration
                </h3>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label for="email_from_address" class="block text-sm font-medium text-gray-700 mb-1">System Email Address</label>
                        <input type="email" name="email_from_address" id="email_from_address" 
                               value="<?php echo e($settings->where('key', 'email_from_address')->first()->value ?? old('email_from_address')); ?>" 
                               class="w-full rounded-md border-gray-300 shadow-sm focus:border-primary-500 focus:ring focus:ring-primary-500 focus:ring-opacity-50"
                               placeholder="noreply@yourchurch.org">
                        <p class="mt-1 text-xs text-gray-500">Email address used for system notifications</p>
                        <?php $__errorArgs = ['email_from_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div>
                        <label for="email_from_name" class="block text-sm font-medium text-gray-700 mb-1">System Email Name</label>
                        <input type="text" name="email_from_name" id="email_from_name" 
                               value="<?php echo e($settings->where('key', 'email_from_name')->first()->value ?? old('email_from_name')); ?>" 
                               class="w-full rounded-md border-gray-300 shadow-sm focus:border-primary-500 focus:ring focus:ring-primary-500 focus:ring-opacity-50"
                               placeholder="Church Management System">
                        <p class="mt-1 text-xs text-gray-500">Display name for system emails</p>
                        <?php $__errorArgs = ['email_from_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>

            <!-- Automated Birthday Messages (Cron Job) -->
            <div class="space-y-4 col-span-1 md:col-span-2">
                <h3 class="text-lg font-medium text-gray-900 flex items-center">
                    <i class="fas fa-calendar-check mr-2 text-red-600"></i>
                    Automated Birthday Messages (Cron Job)
                </h3>
                
                <div class="bg-gradient-to-r from-blue-50 to-red-50 p-5 rounded-lg border border-blue-200">
                    <div class="flex items-start space-x-3 mb-4">
                        <div class="flex-shrink-0">
                            <i class="fas fa-info-circle text-blue-600 text-xl"></i>
                        </div>
                        <div class="flex-1">
                            <h4 class="font-semibold text-gray-800 mb-1">Enable Automatic Birthday Messages</h4>
                            <p class="text-sm text-gray-600">
                                Configure automatic birthday messages to be sent to members every day. 
                                This feature requires setting up a cron job in your cPanel to run the command at your specified time.
                            </p>
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                        <div>
                            <label class="flex items-center space-x-3 cursor-pointer">
                                <input type="checkbox" name="birthday_cron_enabled" id="birthday_cron_enabled" 
                                       value="1"
                                       <?php echo e(($settings->where('key', 'birthday_cron_enabled')->first()->value ?? '0') == '1' ? 'checked' : ''); ?>

                                       class="w-5 h-5 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                                <span class="text-sm font-medium text-gray-700">Enable Automated Birthday Messages</span>
                            </label>
                            <p class="mt-1 ml-8 text-xs text-gray-500">Turn on/off automatic birthday message sending</p>
                        </div>

                        <div>
                            <label for="birthday_cron_time" class="block text-sm font-medium text-gray-700 mb-1">
                                <i class="fas fa-clock mr-1 text-blue-600"></i>
                                Send Time (24-hour format)
                            </label>
                            <input type="time" name="birthday_cron_time" id="birthday_cron_time" 
                                   value="<?php echo e($settings->where('key', 'birthday_cron_time')->first()->value ?? '08:00'); ?>" 
                                   class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-500 focus:ring-opacity-50">
                            <p class="mt-1 text-xs text-gray-500">Time to send birthday messages daily (e.g., 08:00 for 8 AM)</p>
                        </div>
                    </div>

                    <div class="mb-4">
                        <label for="birthday_message_method" class="block text-sm font-medium text-gray-700 mb-2">
                            <i class="fas fa-paper-plane mr-1 text-red-600"></i>
                            Sending Method
                        </label>
                        <select name="birthday_message_method" id="birthday_message_method" 
                                class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-500 focus:ring-opacity-50">
                            <option value="sms" <?php echo e(($settings->where('key', 'birthday_message_method')->first()->value ?? 'sms') == 'sms' ? 'selected' : ''); ?>>SMS Only</option>
                            <option value="email" <?php echo e(($settings->where('key', 'birthday_message_method')->first()->value ?? 'sms') == 'email' ? 'selected' : ''); ?>>Email Only</option>
                            <option value="both" <?php echo e(($settings->where('key', 'birthday_message_method')->first()->value ?? 'sms') == 'both' ? 'selected' : ''); ?>>Both SMS & Email</option>
                        </select>
                        <p class="mt-1 text-xs text-gray-500">Choose how to send birthday messages to members</p>
                    </div>

                    <!-- cPanel Cron Job Instructions -->
                    <div class="bg-white p-4 rounded-lg border-2 border-blue-300">
                        <h4 class="font-bold text-gray-800 mb-2 flex items-center">
                            <i class="fas fa-terminal mr-2 text-green-600"></i>
                            cPanel Cron Job Setup Instructions
                        </h4>
                        <p class="text-sm text-gray-700 mb-3">
                            To enable automatic birthday messages, add this cron job in your cPanel:
                        </p>
                        
                        <div class="space-y-3">
                            <div>
                                <label class="block text-xs font-semibold text-gray-600 mb-1">CRON EXPRESSION:</label>
                                <div class="bg-gray-900 text-green-400 p-3 rounded font-mono text-sm flex items-center justify-between">
                                    <span id="cronExpression">0 8 * * * /usr/local/bin/php /path/to/artisan birthday:send-emails</span>
                                    <button type="button" onclick="copyCronCommand()" 
                                            class="ml-2 px-3 py-1 bg-blue-600 text-white text-xs rounded hover:bg-blue-700 transition">
                                        <i class="fas fa-copy mr-1"></i>Copy
                                    </button>
                                </div>
                                <p class="mt-1 text-xs text-gray-500">
                                    <strong>Note:</strong> Update the time (0 8) and path according to your server configuration
                                </p>
                            </div>

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-3 text-xs">
                                <div class="bg-blue-50 p-3 rounded">
                                    <strong class="text-blue-800">Available Commands:</strong>
                                    <ul class="mt-1 space-y-1 text-gray-700">
                                        <li><code class="bg-white px-1 rounded">birthday:send</code> - SMS messages</li>
                                        <li><code class="bg-white px-1 rounded">birthday:send-emails</code> - Email & SMS</li>
                                        <li><code class="bg-white px-1 rounded">sms:send-birthday</code> - SMS with templates</li>
                                    </ul>
                                </div>

                                <div class="bg-green-50 p-3 rounded">
                                    <strong class="text-green-800">Time Format Examples:</strong>
                                    <ul class="mt-1 space-y-1 text-gray-700">
                                        <li><code class="bg-white px-1 rounded">0 8 * * *</code> - Daily at 8:00 AM</li>
                                        <li><code class="bg-white px-1 rounded">0 12 * * *</code> - Daily at 12:00 PM</li>
                                        <li><code class="bg-white px-1 rounded">30 9 * * *</code> - Daily at 9:30 AM</li>
                                    </ul>
                                </div>
                            </div>

                            <div class="bg-yellow-50 border-l-4 border-yellow-400 p-3">
                                <div class="flex">
                                    <div class="flex-shrink-0">
                                        <i class="fas fa-exclamation-triangle text-yellow-600"></i>
                                    </div>
                                    <div class="ml-3">
                                        <h5 class="text-sm font-semibold text-yellow-800">Important Steps:</h5>
                                        <ol class="mt-1 text-xs text-yellow-700 list-decimal list-inside space-y-1">
                                            <li>Log in to your cPanel account</li>
                                            <li>Find and click on "Cron Jobs" icon</li>
                                            <li>Scroll to "Add New Cron Job" section</li>
                                            <li>Set the time using the dropdowns or enter custom expression</li>
                                            <li>Enter the command path (replace /path/to/artisan with your actual path)</li>
                                            <li>Click "Add New Cron Job" button</li>
                                            <li>Verify the cron job appears in your cron jobs list</li>
                                        </ol>
                                    </div>
                                </div>
                            </div>

                            <div class="bg-gray-50 p-3 rounded">
                                <p class="text-xs text-gray-600">
                                    <strong>Your Server Path:</strong> Typically located at 
                                    <code class="bg-white px-1 rounded text-blue-600">/home/username/public_html/artisan</code> 
                                    or <code class="bg-white px-1 rounded text-blue-600">/home/username/htdocs/presby_app/artisan</code>
                                </p>
                                <p class="text-xs text-gray-600 mt-1">
                                    <strong>PHP Path:</strong> Usually 
                                    <code class="bg-white px-1 rounded text-blue-600">/usr/local/bin/php</code> 
                                    or <code class="bg-white px-1 rounded text-blue-600">/usr/bin/php</code>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="flex justify-end pt-4 border-t border-gray-200">
            <button type="submit" class="px-8 py-3 bg-gradient-to-r from-blue-600 to-red-600 text-white rounded-lg hover:from-blue-700 hover:to-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition-all duration-300 transform hover:scale-105 shadow-lg">
                <i class="fas fa-save mr-2"></i>
                Save Changes
            </button>
        </div>
    </form>
</div>

<script>
    // Update color input text when color picker changes
    document.getElementById('primary_color').addEventListener('input', function(e) {
        e.target.nextElementSibling.value = e.target.value;
    });
    
    document.getElementById('secondary_color').addEventListener('input', function(e) {
        e.target.nextElementSibling.value = e.target.value;
    });

    // Copy cron command to clipboard
    function copyCronCommand() {
        const cronExpression = document.getElementById('cronExpression').textContent;
        
        // Create temporary textarea to copy text
        const textarea = document.createElement('textarea');
        textarea.value = cronExpression;
        textarea.style.position = 'fixed';
        textarea.style.opacity = '0';
        document.body.appendChild(textarea);
        textarea.select();
        
        try {
            document.execCommand('copy');
            // Show success notification
            const btn = event.target.closest('button');
            const originalHtml = btn.innerHTML;
            btn.innerHTML = '<i class="fas fa-check mr-1"></i>Copied!';
            btn.classList.remove('bg-blue-600', 'hover:bg-blue-700');
            btn.classList.add('bg-green-600');
            
            setTimeout(() => {
                btn.innerHTML = originalHtml;
                btn.classList.remove('bg-green-600');
                btn.classList.add('bg-blue-600', 'hover:bg-blue-700');
            }, 2000);
        } catch (err) {
            alert('Failed to copy. Please copy manually.');
        }
        
        document.body.removeChild(textarea);
    }

    // Update cron expression when time changes
    document.getElementById('birthday_cron_time').addEventListener('change', function(e) {
        const time = e.target.value;
        if (time) {
            const [hours, minutes] = time.split(':');
            const cronExpression = `${minutes} ${hours} * * * /usr/local/bin/php /path/to/artisan birthday:send-emails`;
            document.getElementById('cronExpression').textContent = cronExpression;
        }
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('components.app-layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/presby_app/resources/views/settings/general.blade.php ENDPATH**/ ?>