<?php $__env->startSection('title', 'Item Details'); ?>
<?php $__env->startSection('subtitle', $item->name); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gradient-to-br from-slate-50 via-teal-50 to-cyan-50 py-8">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 space-y-8">
        
        <!-- Header Section -->
        <div class="relative overflow-hidden bg-gradient-to-r from-teal-600 via-cyan-600 to-blue-600 rounded-3xl shadow-2xl">
            <div class="absolute inset-0 bg-black opacity-5"></div>
            <div class="absolute top-0 right-0 w-64 h-64 bg-white opacity-5 rounded-full transform translate-x-32 -translate-y-32"></div>
            <div class="absolute bottom-0 left-0 w-48 h-48 bg-white opacity-5 rounded-full transform -translate-x-24 translate-y-24"></div>
            
            <div class="relative px-8 py-12">
                <div class="max-w-4xl mx-auto">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center space-x-6">
                            <div class="w-20 h-20 bg-white bg-opacity-20 backdrop-blur-sm rounded-2xl flex items-center justify-center shadow-xl">
                                <i class="<?php echo e($item->category->icon ?? 'fas fa-box'); ?> text-3xl text-white"></i>
                            </div>
                            <div>
                                <div class="flex items-center space-x-3 mb-2">
                                    <h1 class="text-4xl font-bold text-white"><?php echo e($item->name); ?></h1>
                                    <?php if($item->is_active): ?>
                                        <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-green-100 text-green-800">
                                            <i class="fas fa-check-circle mr-1"></i>
                                            Active
                                        </span>
                                    <?php else: ?>
                                        <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-red-100 text-red-800">
                                            <i class="fas fa-times-circle mr-1"></i>
                                            Inactive
                                        </span>
                                    <?php endif; ?>
                                </div>
                                <p class="text-xl text-white opacity-90 mb-2"><?php echo e($item->item_code); ?></p>
                                <div class="flex items-center space-x-4 text-white/80">
                                    <span class="flex items-center">
                                        <i class="fas fa-tag mr-2"></i>
                                        <?php echo e($item->category->name ?? 'No Category'); ?>

                                    </span>
                                    <?php if($item->location): ?>
                                        <span class="flex items-center">
                                            <i class="fas fa-map-marker-alt mr-2"></i>
                                            <?php echo e($item->location); ?>

                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="text-right">
                            <div class="bg-white bg-opacity-20 backdrop-blur-sm rounded-2xl p-6 shadow-xl">
                                <p class="text-white/80 text-sm font-medium uppercase tracking-wider mb-1">Current Stock</p>
                                <p class="text-4xl font-bold text-white"><?php echo e($item->current_stock); ?></p>
                                <p class="text-white/80 text-sm"><?php echo e($item->unit_of_measure); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Stock Status Alert -->
        <?php
            $stockStatus = $item->stock_status;
        ?>
        
        <?php if($stockStatus === 'out_of_stock'): ?>
            <div class="bg-red-50 border-l-4 border-red-500 rounded-xl p-6">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <i class="fas fa-exclamation-triangle text-red-500 text-2xl"></i>
                    </div>
                    <div class="ml-4">
                        <h3 class="text-lg font-semibold text-red-800">Out of Stock</h3>
                        <p class="text-red-700">This item is currently out of stock and needs immediate restocking.</p>
                    </div>
                </div>
            </div>
        <?php elseif($stockStatus === 'low_stock'): ?>
            <div class="bg-orange-50 border-l-4 border-orange-500 rounded-xl p-6">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <i class="fas fa-exclamation-triangle text-orange-500 text-2xl"></i>
                    </div>
                    <div class="ml-4">
                        <h3 class="text-lg font-semibold text-orange-800">Low Stock Alert</h3>
                        <p class="text-orange-700">Stock level is below the minimum threshold of <?php echo e($item->minimum_stock); ?> <?php echo e($item->unit_of_measure); ?>.</p>
                    </div>
                </div>
            </div>
        <?php elseif($stockStatus === 'overstock'): ?>
            <div class="bg-blue-50 border-l-4 border-blue-500 rounded-xl p-6">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <i class="fas fa-info-circle text-blue-500 text-2xl"></i>
                    </div>
                    <div class="ml-4">
                        <h3 class="text-lg font-semibold text-blue-800">Overstock Notice</h3>
                        <p class="text-blue-700">Stock level exceeds the maximum threshold of <?php echo e($item->maximum_stock); ?> <?php echo e($item->unit_of_measure); ?>.</p>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <!-- Expiry Alert -->
        <?php if($item->track_expiry && $item->expiry_date): ?>
            <?php
                $daysToExpiry = $item->days_to_expiry;
            ?>
            <?php if($daysToExpiry <= 30 && $daysToExpiry > 0): ?>
                <div class="bg-purple-50 border-l-4 border-purple-500 rounded-xl p-6">
                    <div class="flex items-center">
                        <div class="flex-shrink-0">
                            <i class="fas fa-clock text-purple-500 text-2xl"></i>
                        </div>
                        <div class="ml-4">
                            <h3 class="text-lg font-semibold text-purple-800">Expiring Soon</h3>
                            <p class="text-purple-700">This item will expire in <?php echo e($daysToExpiry); ?> days on <?php echo e($item->expiry_date->format('M d, Y')); ?>.</p>
                        </div>
                    </div>
                </div>
            <?php elseif($daysToExpiry <= 0): ?>
                <div class="bg-red-50 border-l-4 border-red-500 rounded-xl p-6">
                    <div class="flex items-center">
                        <div class="flex-shrink-0">
                            <i class="fas fa-times-circle text-red-500 text-2xl"></i>
                        </div>
                        <div class="ml-4">
                            <h3 class="text-lg font-semibold text-red-800">Expired</h3>
                            <p class="text-red-700">This item expired on <?php echo e($item->expiry_date->format('M d, Y')); ?>.</p>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        <?php endif; ?>

        <!-- Main Content Grid -->
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
            
            <!-- Item Details -->
            <div class="lg:col-span-2 space-y-8">
                
                <!-- Basic Information -->
                <div class="bg-white/90 backdrop-blur-sm rounded-2xl shadow-xl border border-gray-100/50 p-8">
                    <div class="flex items-center justify-between mb-6">
                        <h2 class="text-2xl font-bold text-gray-900">Item Information</h2>
                        <div class="flex space-x-2">
                            <a href="<?php echo e(route('inventory.items.edit', $item)); ?>" class="inline-flex items-center px-4 py-2 bg-blue-600 text-white font-medium rounded-xl hover:bg-blue-700 transition-colors">
                                <i class="fas fa-edit mr-2"></i>
                                Edit Item
                            </a>
                            <button onclick="showStockModal()" class="inline-flex items-center px-4 py-2 bg-emerald-600 text-white font-medium rounded-xl hover:bg-emerald-700 transition-colors">
                                <i class="fas fa-plus mr-2"></i>
                                Update Stock
                            </button>
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-sm font-medium text-gray-500 mb-1">Item Code</label>
                            <p class="text-gray-900 font-medium"><?php echo e($item->item_code); ?></p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-500 mb-1">Category</label>
                            <div class="flex items-center space-x-2">
                                <div class="w-4 h-4 rounded-full" style="background-color: <?php echo e($item->category->color ?? '#6B7280'); ?>"></div>
                                <span class="text-gray-900"><?php echo e($item->category->name ?? 'No Category'); ?></span>
                            </div>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-500 mb-1">Unit of Measure</label>
                            <p class="text-gray-900"><?php echo e(ucfirst($item->unit_of_measure)); ?></p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-500 mb-1">Unit Cost</label>
                            <p class="text-gray-900 font-medium">₵<?php echo e(number_format($item->unit_cost, 2)); ?></p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-500 mb-1">Stock Value</label>
                            <p class="text-gray-900 font-bold text-lg">₵<?php echo e(number_format($item->stock_value, 2)); ?></p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-500 mb-1">Location</label>
                            <p class="text-gray-900"><?php echo e($item->location ?? 'Not specified'); ?></p>
                        </div>
                        <?php if($item->barcode): ?>
                            <div>
                                <label class="block text-sm font-medium text-gray-500 mb-1">Barcode</label>
                                <p class="text-gray-900 font-mono"><?php echo e($item->barcode); ?></p>
                            </div>
                        <?php endif; ?>
                        <?php if($item->track_expiry && $item->expiry_date): ?>
                            <div>
                                <label class="block text-sm font-medium text-gray-500 mb-1">Expiry Date</label>
                                <p class="text-gray-900"><?php echo e($item->expiry_date->format('M d, Y')); ?></p>
                            </div>
                        <?php endif; ?>
                    </div>

                    <?php if($item->description): ?>
                        <div class="mt-6">
                            <label class="block text-sm font-medium text-gray-500 mb-2">Description</label>
                            <p class="text-gray-900"><?php echo e($item->description); ?></p>
                        </div>
                    <?php endif; ?>

                    <?php if($item->notes): ?>
                        <div class="mt-6">
                            <label class="block text-sm font-medium text-gray-500 mb-2">Notes</label>
                            <p class="text-gray-900"><?php echo e($item->notes); ?></p>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Stock Levels -->
                <div class="bg-white/90 backdrop-blur-sm rounded-2xl shadow-xl border border-gray-100/50 p-8">
                    <h2 class="text-2xl font-bold text-gray-900 mb-6">Stock Levels</h2>
                    
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                        <div class="text-center p-6 bg-gradient-to-br from-emerald-50 to-green-50 rounded-xl border border-emerald-200">
                            <div class="w-16 h-16 bg-emerald-500 rounded-full flex items-center justify-center mx-auto mb-4">
                                <i class="fas fa-boxes text-white text-2xl"></i>
                            </div>
                            <p class="text-sm font-medium text-emerald-600 uppercase tracking-wider mb-1">Current Stock</p>
                            <p class="text-3xl font-bold text-emerald-700"><?php echo e($item->current_stock); ?></p>
                            <p class="text-sm text-emerald-600"><?php echo e($item->unit_of_measure); ?></p>
                        </div>

                        <div class="text-center p-6 bg-gradient-to-br from-orange-50 to-red-50 rounded-xl border border-orange-200">
                            <div class="w-16 h-16 bg-orange-500 rounded-full flex items-center justify-center mx-auto mb-4">
                                <i class="fas fa-arrow-down text-white text-2xl"></i>
                            </div>
                            <p class="text-sm font-medium text-orange-600 uppercase tracking-wider mb-1">Minimum Stock</p>
                            <p class="text-3xl font-bold text-orange-700"><?php echo e($item->minimum_stock); ?></p>
                            <p class="text-sm text-orange-600"><?php echo e($item->unit_of_measure); ?></p>
                        </div>

                        <?php if($item->maximum_stock): ?>
                            <div class="text-center p-6 bg-gradient-to-br from-blue-50 to-indigo-50 rounded-xl border border-blue-200">
                                <div class="w-16 h-16 bg-blue-500 rounded-full flex items-center justify-center mx-auto mb-4">
                                    <i class="fas fa-arrow-up text-white text-2xl"></i>
                                </div>
                                <p class="text-sm font-medium text-blue-600 uppercase tracking-wider mb-1">Maximum Stock</p>
                                <p class="text-3xl font-bold text-blue-700"><?php echo e($item->maximum_stock); ?></p>
                                <p class="text-sm text-blue-600"><?php echo e($item->unit_of_measure); ?></p>
                            </div>
                        <?php endif; ?>
                    </div>

                    <!-- Stock Level Progress Bar -->
                    <div class="mt-8">
                        <div class="flex items-center justify-between mb-2">
                            <span class="text-sm font-medium text-gray-700">Stock Level</span>
                            <span class="text-sm text-gray-500">
                                <?php echo e($item->current_stock); ?> / <?php echo e($item->maximum_stock ?? ($item->minimum_stock * 3)); ?>

                            </span>
                        </div>
                        <?php
                            $maxForProgress = $item->maximum_stock ?? ($item->minimum_stock * 3);
                            $percentage = $maxForProgress > 0 ? min(($item->current_stock / $maxForProgress) * 100, 100) : 0;
                            $minPercentage = $maxForProgress > 0 ? ($item->minimum_stock / $maxForProgress) * 100 : 0;
                        ?>
                        <div class="w-full bg-gray-200 rounded-full h-4 relative">
                            <!-- Minimum stock indicator -->
                            <div class="absolute h-full bg-orange-300 rounded-full" style="width: <?php echo e($minPercentage); ?>%"></div>
                            <!-- Current stock level -->
                            <div class="h-full rounded-full transition-all duration-500 <?php echo e($stockStatus === 'out_of_stock' ? 'bg-red-500' : ($stockStatus === 'low_stock' ? 'bg-orange-500' : 'bg-emerald-500')); ?>" style="width: <?php echo e($percentage); ?>%"></div>
                            <!-- Minimum stock line -->
                            <div class="absolute top-0 h-full w-0.5 bg-orange-600" style="left: <?php echo e($minPercentage); ?>%"></div>
                        </div>
                        <div class="flex justify-between text-xs text-gray-500 mt-1">
                            <span>0</span>
                            <span style="margin-left: <?php echo e($minPercentage); ?>%">Min: <?php echo e($item->minimum_stock); ?></span>
                            <span><?php echo e($maxForProgress); ?></span>
                        </div>
                    </div>
                </div>

                <!-- Supplier Information -->
                <?php if($item->supplier): ?>
                <div class="bg-white/90 backdrop-blur-sm rounded-2xl shadow-xl border border-gray-100/50 p-8">
                    <h2 class="text-2xl font-bold text-gray-900 mb-6">Supplier Information</h2>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-sm font-medium text-gray-500 mb-1">Supplier Name</label>
                            <p class="text-gray-900 font-medium"><?php echo e($item->supplier); ?></p>
                        </div>
                        <?php if($item->supplier_contact): ?>
                            <div>
                                <label class="block text-sm font-medium text-gray-500 mb-1">Contact Information</label>
                                <p class="text-gray-900"><?php echo e($item->supplier_contact); ?></p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endif; ?>
            </div>

            <!-- Sidebar -->
            <div class="space-y-8">
                
                <!-- Quick Actions -->
                <div class="bg-white/90 backdrop-blur-sm rounded-2xl shadow-xl border border-gray-100/50 p-6">
                    <h3 class="text-lg font-bold text-gray-900 mb-4">Quick Actions</h3>
                    <div class="space-y-3">
                        <button onclick="showStockModal()" class="w-full flex items-center justify-center px-4 py-3 bg-emerald-600 text-white font-medium rounded-xl hover:bg-emerald-700 transition-colors">
                            <i class="fas fa-plus mr-2"></i>
                            Update Stock
                        </button>
                        <a href="<?php echo e(route('inventory.items.edit', $item)); ?>" class="w-full flex items-center justify-center px-4 py-3 bg-blue-600 text-white font-medium rounded-xl hover:bg-blue-700 transition-colors">
                            <i class="fas fa-edit mr-2"></i>
                            Edit Item
                        </a>
                        <a href="<?php echo e(route('inventory.items.index')); ?>" class="w-full flex items-center justify-center px-4 py-3 bg-gray-100 text-gray-700 font-medium rounded-xl hover:bg-gray-200 transition-colors">
                            <i class="fas fa-list mr-2"></i>
                            All Items
                        </a>
                    </div>
                </div>

                <!-- Recent Transactions -->
                <div class="bg-white/90 backdrop-blur-sm rounded-2xl shadow-xl border border-gray-100/50 p-6">
                    <div class="flex items-center justify-between mb-4">
                        <h3 class="text-lg font-bold text-gray-900">Recent Activity</h3>
                        <span class="text-sm text-gray-500">Last 10</span>
                    </div>
                    
                    <?php if($item->transactions->count() > 0): ?>
                        <div class="space-y-3 max-h-96 overflow-y-auto">
                            <?php $__currentLoopData = $item->transactions->take(10); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                                    <div class="flex items-center space-x-3">
                                        <div class="w-8 h-8 bg-<?php echo e($transaction->type_color); ?>-500 rounded-full flex items-center justify-center">
                                            <i class="fas fa-<?php echo e($transaction->type === 'in' ? 'arrow-up' : ($transaction->type === 'out' ? 'arrow-down' : 'edit')); ?> text-white text-xs"></i>
                                        </div>
                                        <div>
                                            <p class="text-sm font-medium text-gray-900"><?php echo e($transaction->type_display); ?></p>
                                            <p class="text-xs text-gray-500"><?php echo e($transaction->created_at->diffForHumans()); ?></p>
                                        </div>
                                    </div>
                                    <div class="text-right">
                                        <p class="text-sm font-medium <?php echo e($transaction->type === 'out' ? 'text-red-600' : 'text-green-600'); ?>">
                                            <?php echo e($transaction->type === 'out' ? '-' : '+'); ?><?php echo e(abs($transaction->quantity)); ?>

                                        </p>
                                        <p class="text-xs text-gray-500"><?php echo e($transaction->new_stock); ?> total</p>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php else: ?>
                        <div class="text-center py-8">
                            <i class="fas fa-history text-gray-400 text-3xl mb-3"></i>
                            <p class="text-gray-500">No transactions yet</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Stock Update Modal -->
<div id="stockModal" class="fixed inset-0 bg-black bg-opacity-50 hidden z-50 flex items-center justify-center">
    <div class="bg-white rounded-2xl shadow-2xl max-w-md w-full mx-4">
        <div class="p-6">
            <div class="flex items-center justify-between mb-6">
                <h3 class="text-xl font-bold text-gray-900">Update Stock</h3>
                <button onclick="closeStockModal()" class="text-gray-400 hover:text-gray-600">
                    <i class="fas fa-times text-xl"></i>
                </button>
            </div>
            
            <form action="<?php echo e(route('inventory.items.update-stock', $item)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Item</label>
                        <p class="text-gray-900 font-medium"><?php echo e($item->name); ?></p>
                        <p class="text-sm text-gray-500">Current stock: <?php echo e($item->current_stock); ?> <?php echo e($item->unit_of_measure); ?></p>
                    </div>
                    
                    <div>
                        <label for="type" class="block text-sm font-medium text-gray-700 mb-2">Transaction Type</label>
                        <select name="type" id="type" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            <option value="in">Stock In</option>
                            <option value="out">Stock Out</option>
                            <option value="adjustment">Adjustment</option>
                        </select>
                    </div>
                    
                    <div>
                        <label for="quantity" class="block text-sm font-medium text-gray-700 mb-2">Quantity</label>
                        <input type="number" name="quantity" id="quantity" min="1" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" required>
                    </div>
                    
                    <div>
                        <label for="reason" class="block text-sm font-medium text-gray-700 mb-2">Reason</label>
                        <input type="text" name="reason" id="reason" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" required>
                    </div>
                    
                    <div>
                        <label for="notes" class="block text-sm font-medium text-gray-700 mb-2">Notes (Optional)</label>
                        <textarea name="notes" id="notes" rows="3" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"></textarea>
                    </div>
                </div>
                
                <div class="flex space-x-3 mt-6">
                    <button type="button" onclick="closeStockModal()" class="flex-1 px-4 py-2 border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 transition-colors">
                        Cancel
                    </button>
                    <button type="submit" class="flex-1 px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors">
                        Update Stock
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function showStockModal() {
    document.getElementById('stockModal').classList.remove('hidden');
}

function closeStockModal() {
    document.getElementById('stockModal').classList.add('hidden');
}

// Close modal when clicking outside
document.getElementById('stockModal').addEventListener('click', function(e) {
    if (e.target === this) {
        closeStockModal();
    }
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('components.app-layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/presby_app/resources/views/inventory/items/show.blade.php ENDPATH**/ ?>