<?php $__env->startSection('title', 'QR Code - ' . $event->title); ?>
<?php $__env->startSection('subtitle', 'Attendance QR Code'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-4xl mx-auto space-y-6">
    <!-- Header -->
    <div class="text-center">
        <div class="flex items-center justify-center space-x-3 mb-4">
            <a href="<?php echo e(route('attendance.show', $event)); ?>" class="text-gray-500 hover:text-gray-700">
                <i class="fas fa-arrow-left text-xl"></i>
            </a>
            <h1 class="text-3xl font-bold text-gray-900"><?php echo e($event->title); ?></h1>
        </div>
        <p class="text-lg text-gray-600"><?php echo e($event->start_datetime->format('l, F j, Y \a\t g:i A')); ?></p>
        <?php if($event->location): ?>
            <p class="text-gray-500 mt-2">
                <i class="fas fa-map-marker-alt mr-1"></i>
                <?php echo e($event->location); ?>

            </p>
        <?php endif; ?>
    </div>

    <!-- QR Code Display -->
    <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-8">
        <div class="text-center">
            <h2 class="text-2xl font-semibold text-gray-900 mb-6">Scan to Mark Attendance</h2>
            
            <?php if($eventQr): ?>
                <!-- Print-optimized QR section -->
                <div class="print-area">
                    <div class="print-title"><?php echo e($event->title); ?></div>
                    <div class="print-details">
                        <?php echo e($event->start_datetime->format('l, F j, Y \a\t g:i A')); ?>

                        <?php if($event->location): ?>
                            <br><?php echo e($event->location); ?>

                        <?php endif; ?>
                    </div>
                    <div class="print-qr-container">
                        <img src="<?php echo e(asset('storage/' . $eventQr->qr_code_path)); ?>" 
                             alt="QR Code for <?php echo e($event->title); ?>" 
                             class="w-64 h-64 mx-auto">
                    </div>
                    <div class="print-instruction">Scan this QR code to mark your attendance</div>
                </div>
                
                <!-- Screen display version -->
                <div class="bg-gradient-to-br from-blue-50 to-indigo-100 rounded-2xl p-8 mb-6 screen-only">
                    <div class="bg-white rounded-xl p-6 inline-block shadow-lg">
                        <img src="<?php echo e(asset('storage/' . $eventQr->qr_code_path)); ?>" 
                             alt="QR Code for <?php echo e($event->title); ?>" 
                             class="w-64 h-64 mx-auto">
                    </div>
                </div>
                
                <!-- QR Code Info -->
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
                    <div class="bg-gray-50 rounded-xl p-4">
                        <div class="text-2xl font-bold text-blue-600"><?php echo e($eventQr->scan_count); ?></div>
                        <div class="text-sm text-gray-600">Total Scans</div>
                    </div>
                    <div class="bg-gray-50 rounded-xl p-4">
                        <div class="text-lg font-semibold text-green-600">
                            <?php if($eventQr->expires_at): ?>
                                <?php echo e($eventQr->expires_at->diffForHumans()); ?>

                            <?php else: ?>
                                Never
                            <?php endif; ?>
                        </div>
                        <div class="text-sm text-gray-600">Expires</div>
                    </div>
                    <div class="bg-gray-50 rounded-xl p-4">
                        <div class="text-lg font-semibold <?php echo e($eventQr->is_active ? 'text-green-600' : 'text-red-600'); ?>">
                            <?php echo e($eventQr->is_active ? 'Active' : 'Inactive'); ?>

                        </div>
                        <div class="text-sm text-gray-600">Status</div>
                    </div>
                </div>
                
                <!-- Actions -->
                <div class="flex justify-center space-x-4">
                    <button onclick="generateNewQr()" class="inline-flex items-center px-6 py-3 bg-blue-600 text-white font-medium rounded-xl hover:bg-blue-700 transition-colors">
                        <i class="fas fa-sync-alt mr-2"></i>
                        Generate New QR
                    </button>
                    <?php if($eventQr->is_active): ?>
                        <button onclick="deactivateQr(<?php echo e($eventQr->id); ?>)" class="inline-flex items-center px-6 py-3 bg-red-600 text-white font-medium rounded-xl hover:bg-red-700 transition-colors">
                            <i class="fas fa-stop mr-2"></i>
                            Deactivate QR
                        </button>
                    <?php endif; ?>
                    <button onclick="printQr()" class="inline-flex items-center px-6 py-3 bg-green-600 text-white font-medium rounded-xl hover:bg-green-700 transition-colors">
                        <i class="fas fa-print mr-2"></i>
                        Print QR Only
                    </button>
                    <a href="<?php echo e(route('attendance.qr.show', $event)); ?>?print=1&autoprint=1" target="_blank" class="inline-flex items-center px-6 py-3 bg-purple-600 text-white font-medium rounded-xl hover:bg-purple-700 transition-colors">
                        <i class="fas fa-external-link-alt mr-2"></i>
                        Print-Only View
                    </a>
                </div>
            <?php else: ?>
                <div class="text-center py-12">
                    <div class="w-16 h-16 bg-gradient-to-br from-gray-100 to-gray-200 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-qrcode text-2xl text-gray-400"></i>
                    </div>
                    <p class="text-gray-500 font-medium mb-4">No QR code generated yet</p>
                    <button onclick="generateNewQr()" class="inline-flex items-center px-6 py-3 bg-blue-600 text-white font-medium rounded-xl hover:bg-blue-700 transition-colors">
                        <i class="fas fa-plus mr-2"></i>
                        Generate QR Code
                    </button>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Instructions -->
    <div class="bg-gradient-to-r from-blue-50 to-indigo-50 rounded-2xl p-6">
        <h3 class="text-lg font-semibold text-gray-900 mb-4">How to Use</h3>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <div class="text-center">
                <div class="w-12 h-12 bg-blue-600 rounded-full flex items-center justify-center mx-auto mb-3">
                    <span class="text-white font-bold">1</span>
                </div>
                <h4 class="font-semibold text-gray-900 mb-2">Display QR Code</h4>
                <p class="text-sm text-gray-600">Show this QR code on a screen or print it for members to scan</p>
            </div>
            <div class="text-center">
                <div class="w-12 h-12 bg-blue-600 rounded-full flex items-center justify-center mx-auto mb-3">
                    <span class="text-white font-bold">2</span>
                </div>
                <h4 class="font-semibold text-gray-900 mb-2">Members Scan</h4>
                <p class="text-sm text-gray-600">Members use their phone camera or QR scanner app to scan the code</p>
            </div>
            <div class="text-center">
                <div class="w-12 h-12 bg-blue-600 rounded-full flex items-center justify-center mx-auto mb-3">
                    <span class="text-white font-bold">3</span>
                </div>
                <h4 class="font-semibold text-gray-900 mb-2">Automatic Check-in</h4>
                <p class="text-sm text-gray-600">Attendance is automatically recorded when members complete the scan</p>
            </div>
        </div>
    </div>

    <!-- Recent Scans -->
    <?php if($eventQr && $eventQr->scan_logs): ?>
        <div class="bg-white rounded-2xl shadow-lg border border-gray-100">
            <div class="px-6 py-5 border-b border-gray-100">
                <h3 class="text-lg font-semibold text-gray-900">Recent Scans</h3>
            </div>
            <div class="p-6">
                <div class="space-y-3">
                    <?php $__currentLoopData = array_slice(array_reverse($eventQr->scan_logs), 0, 10); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="flex items-center justify-between py-2 border-b border-gray-100 last:border-0">
                            <div class="flex items-center space-x-3">
                                <div class="w-2 h-2 rounded-full <?php echo e($log['success'] ? 'bg-green-500' : 'bg-red-500'); ?>"></div>
                                <div>
                                    <p class="text-sm font-medium text-gray-900">
                                        <?php echo e($log['member_info']['name'] ?? 'Unknown Member'); ?>

                                    </p>
                                    <p class="text-xs text-gray-500"><?php echo e(\Carbon\Carbon::parse($log['timestamp'])->format('M j, Y g:i A')); ?></p>
                                </div>
                            </div>
                            <span class="text-xs px-2 py-1 rounded-full <?php echo e($log['success'] ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'); ?>">
                                <?php echo e($log['success'] ? 'Success' : 'Failed'); ?>

                            </span>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>

<!-- QR Generation Modal -->
<div id="qrGenerationModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 hidden overflow-y-auto h-full w-full z-50">
    <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-2xl bg-white">
        <div class="mt-3">
            <div class="flex items-center justify-between mb-4">
                <h3 class="text-lg font-semibold text-gray-900">Generate New QR Code</h3>
                <button onclick="closeQrModal()" class="text-gray-400 hover:text-gray-600">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            
            <form id="qrGenerationForm" class="space-y-4">
                <?php echo csrf_field(); ?>
                <div>
                    <label for="expiration_hours" class="block text-sm font-medium text-gray-700 mb-2">Expiration (Hours)</label>
                    <select id="expiration_hours" name="expiration_hours" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                        <option value="24">24 Hours</option>
                        <option value="12">12 Hours</option>
                        <option value="6">6 Hours</option>
                        <option value="3">3 Hours</option>
                        <option value="">Never Expires</option>
                    </select>
                </div>
                
                <div class="flex justify-end space-x-3 pt-4">
                    <button type="button" onclick="closeQrModal()" 
                            class="px-4 py-2 bg-gray-300 text-gray-700 rounded-lg hover:bg-gray-400 transition-colors">
                        Cancel
                    </button>
                    <button type="submit" 
                            class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors">
                        Generate QR Code
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
function generateNewQr() {
    document.getElementById('qrGenerationModal').classList.remove('hidden');
}

function closeQrModal() {
    document.getElementById('qrGenerationModal').classList.add('hidden');
}

document.getElementById('qrGenerationForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    
    fetch(`<?php echo e(route('attendance.qr.generate', $event)); ?>`, {
        method: 'POST',
        body: formData,
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        } else {
            alert(data.message);
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('An error occurred while generating QR code');
    });
});

function deactivateQr(qrId) {
    if (confirm('Are you sure you want to deactivate this QR code?')) {
        fetch(`/attendance/qr/${qrId}/deactivate`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert(data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('An error occurred while deactivating QR code');
        });
    }
}

function printQr() {
    window.print();
}

// Enhanced Print styles - Only QR Code and Event Info
const printStyles = `
    @media print {
        /* Hide everything by default */
        body * {
            visibility: hidden;
        }
        
        /* Hide navigation, sidebar, and other layout elements */
        nav, .sidebar, .header, .footer, .bg-gradient-to-br {
            display: none !important;
        }
        
        /* Show only the print area */
        .print-area,
        .print-area * {
            visibility: visible;
        }
        
        /* Position the print area */
        .print-area {
            position: absolute;
            left: 0;
            top: 0;
            width: 100%;
            background: white !important;
            box-shadow: none !important;
            border: none !important;
            border-radius: 0 !important;
            padding: 20px !important;
            margin: 0 !important;
        }
        
        /* Center and size the QR code */
        .print-qr-container {
            text-align: center;
            page-break-inside: avoid;
        }
        
        .print-qr-container img {
            width: 300px !important;
            height: 300px !important;
            margin: 20px auto !important;
            display: block !important;
        }
        
        /* Style the event title */
        .print-title {
            font-size: 24px !important;
            font-weight: bold !important;
            margin-bottom: 10px !important;
            text-align: center !important;
            color: black !important;
        }
        
        /* Style the event details */
        .print-details {
            font-size: 16px !important;
            margin-bottom: 20px !important;
            text-align: center !important;
            color: black !important;
        }
        
        /* Style the scan instruction */
        .print-instruction {
            font-size: 18px !important;
            font-weight: bold !important;
            margin-top: 20px !important;
            text-align: center !important;
            color: black !important;
        }
        
        /* Hide all buttons, stats, and screen-only elements */
        button, .grid, .space-x-4, .bg-gray-50, .screen-only {
            display: none !important;
        }
        
        /* Hide instructions and other sections */
        .bg-gradient-to-r, .bg-gradient-to-br:not(.print-area) {
            display: none !important;
        }
        
        /* Remove all backgrounds and shadows for print */
        * {
            background: transparent !important;
            box-shadow: none !important;
            border-radius: 0 !important;
        }
        
        /* Ensure page margins */
        @page {
            margin: 1cm;
        }
    }
`;

const styleSheet = document.createElement("style");
styleSheet.type = "text/css";
styleSheet.innerText = printStyles;
document.head.appendChild(styleSheet);
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('components.app-layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/presby_app/resources/views/attendance/qr-display.blade.php ENDPATH**/ ?>