<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Receipt</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
        }
        .container {
            max-width: 600px;
            margin: 20px auto;
            background: #ffffff;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        }
        .header {
            background: linear-gradient(135deg, #2563eb 0%, #dc2626 100%);
            color: white;
            padding: 30px 20px;
            text-align: center;
        }
        .header h1 {
            margin: 0;
            font-size: 28px;
        }
        .content {
            padding: 30px;
        }
        .receipt-box {
            background: #f8f9fa;
            border: 2px solid #e9ecef;
            border-radius: 8px;
            padding: 20px;
            margin: 20px 0;
        }
        .receipt-row {
            display: flex;
            justify-content: space-between;
            padding: 10px 0;
            border-bottom: 1px solid #dee2e6;
        }
        .receipt-row:last-child {
            border-bottom: none;
        }
        .receipt-label {
            font-weight: bold;
            color: #666;
        }
        .receipt-value {
            color: #333;
        }
        .amount {
            font-size: 24px;
            font-weight: bold;
            color: #2563eb;
            text-align: center;
            margin: 20px 0;
        }
        .footer {
            background: #f8f9fa;
            padding: 20px;
            text-align: center;
            color: #666;
            font-size: 14px;
        }
        .thank-you {
            background: linear-gradient(135deg, #2563eb15 0%, #dc262615 100%);
            padding: 20px;
            border-radius: 8px;
            text-align: center;
            margin: 20px 0;
            border-left: 4px solid #2563eb;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>💳 Payment Receipt</h1>
        </div>
        
        <div class="content">
            <h2>Dear <?php echo e($payment->member->first_name); ?>,</h2>
            
            <p>Thank you for your <?php echo e(strtolower($payment->payment_type_display)); ?>. We have received your payment and this email serves as your official receipt.</p>
            
            <div class="receipt-box">
                <div class="receipt-row">
                    <span class="receipt-label">Receipt Number:</span>
                    <span class="receipt-value"><?php echo e($payment->receipt_number); ?></span>
                </div>
                <div class="receipt-row">
                    <span class="receipt-label">Payment Reference:</span>
                    <span class="receipt-value"><?php echo e($payment->payment_reference); ?></span>
                </div>
                <div class="receipt-row">
                    <span class="receipt-label">Payment Type:</span>
                    <span class="receipt-value"><?php echo e($payment->payment_type_display); ?></span>
                </div>
                <div class="receipt-row">
                    <span class="receipt-label">Payment Method:</span>
                    <span class="receipt-value"><?php echo e(ucfirst(str_replace('_', ' ', $payment->payment_method))); ?></span>
                </div>
                <div class="receipt-row">
                    <span class="receipt-label">Payment Date:</span>
                    <span class="receipt-value"><?php echo e($payment->payment_date->format('F d, Y')); ?></span>
                </div>
                <div class="receipt-row">
                    <span class="receipt-label">Member ID:</span>
                    <span class="receipt-value"><?php echo e($payment->member->member_id); ?></span>
                </div>
                <div class="receipt-row">
                    <span class="receipt-label">Member Name:</span>
                    <span class="receipt-value"><?php echo e($payment->member->full_name); ?></span>
                </div>
            </div>
            
            <div class="amount">
                Amount: GHS <?php echo e(number_format($payment->amount, 2)); ?>

            </div>
            
            <?php if($payment->description): ?>
            <div style="margin: 20px 0;">
                <p style="margin: 5px 0;"><strong>Description:</strong></p>
                <p style="margin: 5px 0; color: #666;"><?php echo e($payment->description); ?></p>
            </div>
            <?php endif; ?>
            
            <div class="thank-you">
                <p style="margin: 0; font-size: 18px; color: #2563eb;"><strong>Thank you for your faithful giving!</strong></p>
                <p style="margin: 10px 0 0 0; font-size: 14px; color: #666;">
                    "Each of you should give what you have decided in your heart to give, not reluctantly or under compulsion, for God loves a cheerful giver." - 2 Corinthians 9:7
                </p>
            </div>
            
            <p style="font-size: 14px; color: #666; margin-top: 20px;">
                If you have any questions about this payment, please contact our finance department.
            </p>
        </div>
        
        <div class="footer">
            <p><strong><?php echo e($organizationName); ?></strong></p>
            <p style="font-size: 12px; color: #999;">
                This is an automated receipt. Please keep this for your records.
            </p>
        </div>
    </div>
</body>
</html>
<?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/presby_app/resources/views/emails/payment-receipt.blade.php ENDPATH**/ ?>