<?php $__env->startSection('title', 'Members'); ?>

<?php
    $dynamicSubtitle = 'Manage ' . ($organizationSettings['name'] ?? 'Presbyterian Church of Ghana') . ' members and their information';
?>

<?php $__env->startSection('subtitle', $dynamicSubtitle); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gradient-to-br from-slate-50 via-blue-50 to-indigo-50 py-8">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 space-y-8">
        
        <!-- Analytics Dashboard -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-5 gap-6 mb-8">
            <div class="group bg-gradient-to-br from-green-500 via-green-600 to-green-700 rounded-3xl p-8 text-white shadow-xl hover:shadow-2xl transition-all duration-500 transform hover:scale-105 hover:rotate-1 relative overflow-hidden">
                <div class="absolute inset-0 bg-gradient-to-br from-white/10 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
                <div class="relative z-10">
                    <div class="flex items-center justify-between mb-6">
                        <div class="p-4 bg-white/20 rounded-2xl backdrop-blur-sm group-hover:bg-white/30 group-hover:scale-110 transition-all duration-300 shadow-lg">
                            <i class="fas fa-users text-3xl group-hover:rotate-12 transition-transform duration-300"></i>
                        </div>
                        <div class="text-right">
                            <p class="text-green-100 text-sm font-medium uppercase tracking-wider">Total Members</p>
                            <p class="text-4xl font-bold group-hover:scale-110 transition-transform duration-300"><?php echo e($stats['total_members'] ?? 0); ?></p>
                        </div>
                    </div>
                    <div class="flex items-center justify-between text-green-100">
                        <div class="flex items-center">
                            <i class="fas fa-chart-line mr-2 group-hover:animate-pulse"></i>
                            <span class="text-sm font-medium">Active community</span>
                        </div>
                        <div class="w-3 h-3 bg-green-300 rounded-full animate-pulse"></div>
                    </div>
                </div>
            </div>

            <div class="group bg-gradient-to-br from-orange-500 via-orange-600 to-orange-700 rounded-3xl p-8 text-white shadow-xl hover:shadow-2xl transition-all duration-500 transform hover:scale-105 hover:rotate-1 relative overflow-hidden">
                <div class="absolute inset-0 bg-gradient-to-br from-white/10 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
                <div class="relative z-10">
                    <div class="flex items-center justify-between mb-6">
                        <div class="p-4 bg-white/20 rounded-2xl backdrop-blur-sm group-hover:bg-white/30 group-hover:scale-110 transition-all duration-300 shadow-lg">
                            <i class="fas fa-user-plus text-3xl group-hover:rotate-12 transition-transform duration-300"></i>
                        </div>
                        <div class="text-right">
                            <p class="text-orange-100 text-sm font-medium uppercase tracking-wider">New This Month</p>
                            <p class="text-4xl font-bold group-hover:scale-110 transition-transform duration-300"><?php echo e($stats['new_members'] ?? 0); ?></p>
                        </div>
                    </div>
                    <div class="flex items-center justify-between text-orange-100">
                        <div class="flex items-center">
                            <i class="fas fa-calendar-plus mr-2 group-hover:animate-pulse"></i>
                            <span class="text-sm font-medium">Recent additions</span>
                        </div>
                        <div class="w-3 h-3 bg-orange-300 rounded-full animate-pulse"></div>
                    </div>
                </div>
            </div>

            <div class="group bg-gradient-to-br from-blue-500 via-blue-600 to-blue-700 rounded-3xl p-8 text-white shadow-xl hover:shadow-2xl transition-all duration-500 transform hover:scale-105 hover:rotate-1 relative overflow-hidden">
                <div class="absolute inset-0 bg-gradient-to-br from-white/10 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
                <div class="relative z-10">
                    <div class="flex items-center justify-between mb-6">
                        <div class="p-4 bg-white/20 rounded-2xl backdrop-blur-sm group-hover:bg-white/30 group-hover:scale-110 transition-all duration-300 shadow-lg">
                            <i class="fas fa-home text-3xl group-hover:rotate-12 transition-transform duration-300"></i>
                        </div>
                        <div class="text-right">
                            <p class="text-blue-100 text-sm font-medium uppercase tracking-wider">Total Families</p>
                            <p class="text-4xl font-bold group-hover:scale-110 transition-transform duration-300"><?php echo e($stats['total_families'] ?? 0); ?></p>
                        </div>
                    </div>
                    <div class="flex items-center justify-between text-blue-100">
                        <div class="flex items-center">
                            <i class="fas fa-heart mr-2 group-hover:animate-pulse"></i>
                            <span class="text-sm font-medium">Family units</span>
                        </div>
                        <div class="w-3 h-3 bg-blue-300 rounded-full animate-pulse"></div>
                    </div>
                </div>
            </div>

            <div class="group bg-gradient-to-br from-cyan-500 via-cyan-600 to-teal-600 rounded-3xl p-8 text-white shadow-xl hover:shadow-2xl transition-all duration-500 transform hover:scale-105 hover:rotate-1 relative overflow-hidden">
                <div class="absolute inset-0 bg-gradient-to-br from-white/10 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
                <div class="relative z-10">
                    <div class="flex items-center justify-between mb-6">
                        <div class="p-4 bg-white/20 rounded-2xl backdrop-blur-sm group-hover:bg-white/30 group-hover:scale-110 transition-all duration-300 shadow-lg">
                            <i class="fas fa-hands-helping text-3xl group-hover:rotate-12 transition-transform duration-300"></i>
                        </div>
                        <div class="text-right">
                            <p class="text-cyan-100 text-sm font-medium uppercase tracking-wider">Active Ministries</p>
                            <p class="text-4xl font-bold group-hover:scale-110 transition-transform duration-300"><?php echo e($stats['active_ministries'] ?? 0); ?></p>
                        </div>
                    </div>
                    <div class="flex items-center justify-between text-cyan-100">
                        <div class="flex items-center">
                            <i class="fas fa-pray mr-2 group-hover:animate-pulse"></i>
                            <span class="text-sm font-medium">Service areas</span>
                        </div>
                        <div class="w-3 h-3 bg-cyan-300 rounded-full animate-pulse"></div>
                    </div>
                </div>
            </div>

            <a href="<?php echo e(route('members.pending')); ?>" class="group bg-gradient-to-br from-amber-500 via-yellow-500 to-orange-500 rounded-3xl p-8 text-white shadow-xl hover:shadow-2xl transition-all duration-500 transform hover:scale-105 hover:rotate-1 relative overflow-hidden cursor-pointer">
                <div class="absolute inset-0 bg-gradient-to-br from-white/10 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
                <div class="relative z-10">
                    <div class="flex items-center justify-between mb-6">
                        <div class="p-4 bg-white/20 rounded-2xl backdrop-blur-sm group-hover:bg-white/30 group-hover:scale-110 transition-all duration-300 shadow-lg">
                            <i class="fas fa-user-clock text-3xl group-hover:rotate-12 transition-transform duration-300"></i>
                        </div>
                        <div class="text-right">
                            <p class="text-amber-100 text-sm font-medium uppercase tracking-wider">Pending Approval</p>
                            <p class="text-4xl font-bold group-hover:scale-110 transition-transform duration-300"><?php echo e($stats['pending_members'] ?? 0); ?></p>
                        </div>
                    </div>
                    <div class="flex items-center justify-between text-amber-100">
                        <div class="flex items-center">
                            <i class="fas fa-hourglass-half mr-2 group-hover:animate-pulse"></i>
                            <span class="text-sm font-medium">Awaiting review</span>
                        </div>
                        <?php if(($stats['pending_members'] ?? 0) > 0): ?>
                            <div class="flex items-center">
                                <div class="w-3 h-3 bg-amber-300 rounded-full animate-pulse mr-1"></div>
                                <span class="text-xs font-bold">ACTION NEEDED</span>
                            </div>
                        <?php else: ?>
                            <div class="w-3 h-3 bg-amber-300 rounded-full animate-pulse"></div>
                        <?php endif; ?>
                    </div>
                </div>
            </a>
        </div>

        <!-- Quick Actions Bar -->
        <div class="bg-white/80 backdrop-blur-xl rounded-3xl shadow-xl border border-white/20 p-6">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div class="flex items-center space-x-4">
                    <div class="flex items-center space-x-2">
                        <div class="w-3 h-3 bg-gradient-to-r from-blue-600 to-red-600 rounded-full animate-pulse"></div>
                        <span class="text-sm font-medium text-gray-700">Quick Actions</span>
                    </div>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <!-- Bulk Delete Button (Hidden by default) -->
                    <button id="bulk-delete-btn" onclick="bulkDeleteMembers()" class="hidden inline-flex items-center px-4 py-2 bg-gradient-to-r from-red-600 to-pink-600 text-white text-sm font-medium rounded-xl hover:from-red-700 hover:to-pink-700 transition-all duration-200 shadow-md hover:shadow-lg transform hover:scale-105">
                        <i class="fas fa-trash-alt mr-2"></i>
                        Delete Selected (<span id="selected-count">0</span>)
                    </button>

                    <a href="<?php echo e(route('members.create')); ?>" class="inline-flex items-center px-4 py-2 bg-gradient-to-r from-blue-600 to-red-600 text-white text-sm font-medium rounded-xl hover:from-blue-700 hover:to-red-700 transition-all duration-200 shadow-md hover:shadow-lg transform hover:scale-105">
                        <i class="fas fa-user-plus mr-2"></i>
                        New Member
                    </a>
                    <a href="<?php echo e(route('members.pending')); ?>" class="inline-flex items-center px-4 py-2 bg-gradient-to-r from-blue-600 to-emerald-600 text-white text-sm font-medium rounded-xl hover:from-orange-700 hover:to-red-700 transition-all duration-200 shadow-md hover:shadow-lg transform hover:scale-105 relative">
                        <i class="fas fa-user-clock mr-2"></i>
                        Pending Approvals
                        <?php if(($stats['pending_members'] ?? 0) > 0): ?>
                            <span class="absolute -top-2 -right-2 inline-flex items-center justify-center px-2 py-1 text-xs font-bold leading-none text-white bg-red-600 rounded-full animate-pulse">
                                <?php echo e($stats['pending_members']); ?>

                            </span>
                        <?php endif; ?>
                    </a>
                    <button onclick="bulkImport()" class="inline-flex items-center px-4 py-2 bg-gradient-to-r from-emerald-600 via-green-600 to-teal-600 text-white text-sm font-medium rounded-xl hover:from-emerald-700 hover:via-green-700 hover:to-teal-700 transition-all duration-200 shadow-md hover:shadow-lg transform hover:scale-105">
                        <i class="fas fa-upload mr-2"></i>
                        Bulk Import
                    </button>
                    <button onclick="printDirectory()" class="inline-flex items-center px-4 py-2 bg-white text-gray-700 text-sm font-medium rounded-xl border border-gray-200 hover:bg-gray-50 transition-all duration-200 shadow-md hover:shadow-lg transform hover:scale-105">
                        <i class="fas fa-print mr-2"></i>
                        Print Directory
                    </button>
                    <button onclick="sendBulkSMS()" class="inline-flex items-center px-4 py-2 bg-white text-gray-700 text-sm font-medium rounded-xl border border-gray-200 hover:bg-gray-50 transition-all duration-200 shadow-md hover:shadow-lg transform hover:scale-105">
                        <i class="fas fa-sms mr-2"></i>
                        Bulk SMS
                    </button>
                </div>
            </div>
        </div>

        <!-- Header with Actions -->
        <div class="flex flex-col lg:flex-row justify-between items-start lg:items-center gap-6">
            <div class="space-y-3">
                <div class="flex items-center space-x-4">
                    <div class="w-12 h-12 bg-gradient-to-r from-emerald-600 to-green-600 rounded-2xl flex items-center justify-center shadow-xl">
                        <i class="fas fa-users text-white text-xl"></i>
                    </div>
                    <div>
                        <h1 class="text-4xl font-bold bg-gradient-to-r from-emerald-600 via-green-600 to-teal-600 bg-clip-text text-transparent">Church Members</h1>
                        <p class="text-gray-600 text-lg mt-1">Manage your congregation members and their details</p>
                    </div>
                </div>
            </div>
            <div class="flex flex-col sm:flex-row gap-4">
                <!-- Select All & View Toggle -->
                <div class="flex items-center space-x-4">
                    <label class="flex items-center space-x-2 cursor-pointer group">
                        <input type="checkbox" id="select-all" onchange="toggleSelectAll(this)" class="w-5 h-5 text-blue-600 border-gray-300 rounded focus:ring-blue-500 focus:ring-2 cursor-pointer">
                        <span class="text-sm font-medium text-gray-700 group-hover:text-blue-600">Select All</span>
                    </label>
                    
                    <div class="flex items-center space-x-2 bg-gray-100 rounded-xl p-1">
                        <button onclick="toggleView('grid')" id="grid-btn" class="flex items-center px-4 py-2 rounded-xl transition-all duration-200 bg-white shadow-md text-blue-600">
                            <i class="fas fa-th mr-2"></i>
                            Grid
                        </button>
                        <button onclick="toggleView('list')" id="list-btn" class="flex items-center px-4 py-2 rounded-xl transition-all duration-200 text-gray-600 hover:bg-gray-100">
                            <i class="fas fa-list mr-2"></i>
                            List
                        </button>
                    </div>
                </div>
                
                <!-- Export Dropdown -->
                <div class="relative" id="export-dropdown">
                    <button onclick="toggleExportDropdown()" class="flex items-center px-6 py-3 bg-gradient-to-r from-red-600 to-red-700 text-white rounded-xl hover:from-red-700 hover:to-red-800 transition-all duration-200 shadow-lg hover:shadow-xl transform hover:-translate-y-1">
                        <i class="fas fa-download mr-2"></i>
                        Export
                        <i class="fas fa-chevron-down ml-2 text-sm"></i>
                    </button>
                    
                    <div id="export-menu" class="hidden absolute right-0 mt-2 w-48 bg-white rounded-xl shadow-xl border border-gray-200 z-50">
                        <div class="py-2">
                            <button onclick="exportMembers('csv')" class="w-full text-left px-4 py-3 hover:bg-gray-50 flex items-center transition-colors duration-150">
                                <i class="fas fa-file-csv text-green-600 mr-3"></i>
                                <div>
                                    <div class="font-medium text-gray-900">CSV Export</div>
                                    <div class="text-xs text-gray-500">Comma-separated values</div>
                                </div>
                            </button>
                            
                            <button onclick="exportMembers('excel')" class="w-full text-left px-4 py-3 hover:bg-gray-50 flex items-center transition-colors duration-150">
                                <i class="fas fa-file-excel text-green-600 mr-3"></i>
                                <div>
                                    <div class="font-medium text-gray-900">Excel Export</div>
                                    <div class="text-xs text-gray-500">Microsoft Excel format</div>
                                </div>
                            </button>
                            
                            <button onclick="exportMembers('pdf')" class="w-full text-left px-4 py-3 hover:bg-gray-50 flex items-center transition-colors duration-150">
                                <i class="fas fa-file-pdf text-red-600 mr-3"></i>
                                <div>
                                    <div class="font-medium text-gray-900">PDF Export</div>
                                    <div class="text-xs text-gray-500">Printable directory</div>
                                </div>
                            </button>
                        </div>
                    </div>
                </div>
                
                <a href="<?php echo e(route('members.create')); ?>" class="inline-flex items-center px-8 py-4 bg-gradient-to-r from-emerald-600 via-green-600 to-teal-600 text-white font-bold rounded-2xl hover:from-emerald-700 hover:via-green-700 hover:to-teal-700 transition-all duration-300 shadow-xl hover:shadow-2xl transform hover:scale-105">
                    <i class="fas fa-user-plus mr-3 text-lg"></i>
                    Add Member
                    <div class="ml-2 w-2 h-2 bg-white/30 rounded-full animate-pulse"></div>
                </a>
            </div>
        </div>

        <!-- Filters and Search -->
        <div class="group bg-white/70 backdrop-blur-xl rounded-3xl shadow-xl border border-white/20 p-8 hover:shadow-2xl transition-all duration-500">
            <form method="GET" action="<?php echo e(route('members.index')); ?>" class="space-y-6">
                <div class="grid grid-cols-1 md:grid-cols-5 gap-6">
                    <div class="md:col-span-2 space-y-2">
                        <label class="block text-sm font-bold text-gray-800">Search Members</label>
                        <div class="relative">
                            <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                                <i class="fas fa-search text-gray-400 text-lg"></i>
                            </div>
                            <input type="text" name="search" value="<?php echo e(request('search')); ?>" class="block w-full pl-12 pr-4 py-4 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md placeholder-gray-400 text-lg" placeholder="Search by name, email, phone...">
                        </div>
                    </div>
                    <div class="space-y-2">
                        <label class="block text-sm font-bold text-gray-800">Membership Status</label>
                        <div class="relative">
                            <select name="status" class="block w-full px-4 py-4 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md appearance-none">
                                <option value="">All Status</option>
                                <option value="active" <?php echo e(request('status') == 'active' ? 'selected' : ''); ?>>Active</option>
                                <option value="inactive" <?php echo e(request('status') == 'inactive' ? 'selected' : ''); ?>>Inactive</option>
                                <option value="visitor" <?php echo e(request('status') == 'visitor' ? 'selected' : ''); ?>>Visitor</option>
                            </select>
                            <div class="absolute inset-y-0 right-0 flex items-center pr-4 pointer-events-none">
                                <i class="fas fa-chevron-down text-gray-400"></i>
                            </div>
                        </div>
                    </div>
                    <div class="space-y-2">
                        <label class="block text-sm font-bold text-gray-800">Membership Type</label>
                        <div class="relative">
                            <select name="type" class="block w-full px-4 py-4 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md appearance-none">
                                <option value="">All Types</option>
                                <option value="communicant" <?php echo e(request('type') == 'communicant' ? 'selected' : ''); ?>>Communicant Member (Full Member)</option>
                                <option value="baptized" <?php echo e(request('type') == 'baptized' ? 'selected' : ''); ?>>Baptized Member</option>
                                <option value="confirmed" <?php echo e(request('type') == 'confirmed' ? 'selected' : ''); ?>>Confirmed Member</option>
                                <option value="long_distance" <?php echo e(request('type') == 'long_distance' ? 'selected' : ''); ?>>Long Distance Member</option>
                                <option value="adherent" <?php echo e(request('type') == 'adherent' ? 'selected' : ''); ?>>Adherent</option>
                                <option value="catechumen" <?php echo e(request('type') == 'catechumen' ? 'selected' : ''); ?>>Catechumen (Learner / New Member)</option>
                            </select>
                            <div class="absolute inset-y-0 right-0 flex items-center pr-4 pointer-events-none">
                                <i class="fas fa-chevron-down text-gray-400"></i>
                            </div>
                        </div>
                    </div>
                    <div class="flex items-end">
                        <button type="submit" class="w-full px-6 py-4 bg-gradient-to-r from-emerald-600 via-green-600 to-teal-600 text-white font-bold rounded-2xl hover:from-emerald-700 hover:via-green-700 hover:to-teal-700 transition-all duration-300 shadow-lg hover:shadow-xl transform hover:scale-105">
                            <i class="fas fa-search mr-2"></i>
                            Search
                        </button>
                    </div>
                </div>
                
                <!-- Advanced Filters (Collapsible) -->
                <div x-data="{ showAdvanced: false }" class="border-t border-gray-200/30 pt-6">
                    <button type="button" @click="showAdvanced = !showAdvanced" class="flex items-center px-4 py-2 bg-gradient-to-r from-emerald-50 to-green-50 text-emerald-700 hover:from-emerald-100 hover:to-green-100 font-semibold rounded-xl transition-all duration-300">
                        <i class="fas fa-sliders-h mr-2"></i>
                        Advanced Filters
                        <i class="fas fa-chevron-down ml-2 transition-transform duration-300" :class="{ 'rotate-180': showAdvanced }"></i>
                    </button>
                    
                    <div x-show="showAdvanced" x-transition class="mt-4 grid grid-cols-1 md:grid-cols-3 lg:grid-cols-5 gap-4">
                        <div class="space-y-2">
                            <label class="block text-sm font-bold text-gray-800">Gender</label>
                            <select name="gender" class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-200 bg-white/80 backdrop-blur-sm">
                                <option value="">All Genders</option>
                                <option value="male" <?php echo e(request('gender') == 'male' ? 'selected' : ''); ?>>Male</option>
                                <option value="female" <?php echo e(request('gender') == 'female' ? 'selected' : ''); ?>>Female</option>
                            </select>
                        </div>
                        
                        <div class="space-y-2">
                            <label class="block text-sm font-bold text-gray-800">Day Born</label>
                            <select name="day_born" class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-200 bg-white/80 backdrop-blur-sm">
                                <option value="">All Days</option>
                                <option value="Sunday" <?php echo e(request('day_born') == 'Sunday' ? 'selected' : ''); ?>>Sunday</option>
                                <option value="Monday" <?php echo e(request('day_born') == 'Monday' ? 'selected' : ''); ?>>Monday</option>
                                <option value="Tuesday" <?php echo e(request('day_born') == 'Tuesday' ? 'selected' : ''); ?>>Tuesday</option>
                                <option value="Wednesday" <?php echo e(request('day_born') == 'Wednesday' ? 'selected' : ''); ?>>Wednesday</option>
                                <option value="Thursday" <?php echo e(request('day_born') == 'Thursday' ? 'selected' : ''); ?>>Thursday</option>
                                <option value="Friday" <?php echo e(request('day_born') == 'Friday' ? 'selected' : ''); ?>>Friday</option>
                                <option value="Saturday" <?php echo e(request('day_born') == 'Saturday' ? 'selected' : ''); ?>>Saturday</option>
                            </select>
                        </div>

                        <div class="space-y-2">
                            <label class="block text-sm font-bold text-gray-800">Marital Status</label>
                            <select name="marital_status" class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-200 bg-white/80 backdrop-blur-sm">
                                <option value="">All Statuses</option>
                                <option value="single" <?php echo e(request('marital_status') == 'single' ? 'selected' : ''); ?>>Single</option>
                                <option value="married" <?php echo e(request('marital_status') == 'married' ? 'selected' : ''); ?>>Married</option>
                                <option value="divorced" <?php echo e(request('marital_status') == 'divorced' ? 'selected' : ''); ?>>Divorced</option>
                                <option value="widowed" <?php echo e(request('marital_status') == 'widowed' ? 'selected' : ''); ?>>Widowed</option>
                                <option value="separated" <?php echo e(request('marital_status') == 'separated' ? 'selected' : ''); ?>>Separated</option>
                            </select>
                        </div>

                        <div class="space-y-2">
                            <label class="block text-sm font-bold text-gray-800">Highest Qualification</label>
                            <select name="highest_qualification" class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-200 bg-white/80 backdrop-blur-sm">
                                <option value="">All Qualifications</option>
                                <option value="none" <?php echo e(request('highest_qualification') == 'none' ? 'selected' : ''); ?>>No Formal Education</option>
                                <option value="primary" <?php echo e(request('highest_qualification') == 'primary' ? 'selected' : ''); ?>>Primary School</option>
                                <option value="jhs" <?php echo e(request('highest_qualification') == 'jhs' ? 'selected' : ''); ?>>Junior High School</option>
                                <option value="shs" <?php echo e(request('highest_qualification') == 'shs' ? 'selected' : ''); ?>>Senior High School</option>
                                <option value="tertiary" <?php echo e(request('highest_qualification') == 'tertiary' ? 'selected' : ''); ?>>Tertiary/University</option>
                                <option value="postgraduate" <?php echo e(request('highest_qualification') == 'postgraduate' ? 'selected' : ''); ?>>Postgraduate</option>
                                <option value="professional" <?php echo e(request('highest_qualification') == 'professional' ? 'selected' : ''); ?>>Professional Certification</option>
                                <option value="other" <?php echo e(request('highest_qualification') == 'other' ? 'selected' : ''); ?>>Other</option>
                            </select>
                        </div>
                        
                        
                        <div class="space-y-2">
                            <label class="block text-sm font-bold text-gray-800">Family</label>
                            <select name="family_id" class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-200 bg-white/80 backdrop-blur-sm">
                                <option value="">All Families</option>
                                <?php $__currentLoopData = $families ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $family): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($family->id); ?>" <?php echo e(request('family_id') == $family->id ? 'selected' : ''); ?>>
                                        <?php echo e($family->family_name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="space-y-2">
                            <label class="block text-sm font-bold text-gray-800">Year Group</label>
                            <select name="year_group_id" class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-200 bg-white/80 backdrop-blur-sm">
                                <option value="">All Year Groups</option>
                                <?php $__currentLoopData = \App\Models\YearGroup::active()->ordered()->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $yearGroup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($yearGroup->id); ?>" <?php echo e(request('year_group_id') == $yearGroup->id ? 'selected' : ''); ?>>
                                        <?php echo e($yearGroup->name); ?> (<?php echo e($yearGroup->abbreviation); ?>)
                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        
                        <div class="space-y-2">
                            <label class="block text-sm font-bold text-gray-800">Ministry</label>
                            <select name="ministry_id" class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-200 bg-white/80 backdrop-blur-sm">
                                <option value="">All Ministries</option>
                                <?php $__currentLoopData = $ministries ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ministry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($ministry->id); ?>" <?php echo e(request('ministry_id') == $ministry->id ? 'selected' : ''); ?>>
                                        <?php echo e($ministry->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                </div>

                <!-- Active Filters Display -->
                <?php if(request()->hasAny(['search', 'status', 'type', 'gender', 'day_born', 'marital_status', 'highest_qualification', 'family_id', 'year_group_id', 'ministry_id'])): ?>
                    <div class="flex flex-wrap items-center gap-2 pt-4 border-t border-gray-200/30">
                        <span class="text-sm font-medium text-gray-700">Active filters:</span>
                        <?php if(request('search')): ?>
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                Search: "<?php echo e(request('search')); ?>"
                                <a href="<?php echo e(request()->fullUrlWithQuery(['search' => null])); ?>" class="ml-1 text-blue-600 hover:text-blue-800">
                                    <i class="fas fa-times"></i>
                                </a>
                            </span>
                        <?php endif; ?>
                        <?php if(request('status')): ?>
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                Status: <?php echo e(ucfirst(request('status'))); ?>

                                <a href="<?php echo e(request()->fullUrlWithQuery(['status' => null])); ?>" class="ml-1 text-green-600 hover:text-green-800">
                                    <i class="fas fa-times"></i>
                                </a>
                            </span>
                        <?php endif; ?>
                        <?php if(request('type')): ?>
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-purple-100 text-purple-800">
                                Type: <?php echo e(ucfirst(request('type'))); ?>

                                <a href="<?php echo e(request()->fullUrlWithQuery(['type' => null])); ?>" class="ml-1 text-purple-600 hover:text-purple-800">
                                    <i class="fas fa-times"></i>
                                </a>
                            </span>
                        <?php endif; ?>
                        <?php if(request('year_group_id')): ?>
                            <?php
                                $yearGroup = \App\Models\YearGroup::find(request('year_group_id'));
                            ?>
                            <?php if($yearGroup): ?>
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-indigo-100 text-indigo-800">
                                    Year Group: <?php echo e($yearGroup->name); ?>

                                    <a href="<?php echo e(request()->fullUrlWithQuery(['year_group_id' => null])); ?>" class="ml-1 text-indigo-600 hover:text-indigo-800">
                                        <i class="fas fa-times"></i>
                                    </a>
                                </span>
                            <?php endif; ?>
                        <?php endif; ?>
                        <?php if(request('gender')): ?>
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-pink-100 text-pink-800">
                                Gender: <?php echo e(ucfirst(request('gender'))); ?>

                                <a href="<?php echo e(request()->fullUrlWithQuery(['gender' => null])); ?>" class="ml-1 text-pink-600 hover:text-pink-800">
                                    <i class="fas fa-times"></i>
                                </a>
                            </span>
                        <?php endif; ?>
                        <?php if(request('day_born')): ?>
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-yellow-100 text-yellow-800">
                                Day Born: <?php echo e(request('day_born')); ?>

                                <a href="<?php echo e(request()->fullUrlWithQuery(['day_born' => null])); ?>" class="ml-1 text-yellow-600 hover:text-yellow-800">
                                    <i class="fas fa-times"></i>
                                </a>
                            </span>
                        <?php endif; ?>
                        <?php if(request('marital_status')): ?>
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-rose-100 text-rose-800">
                                Marital Status: <?php echo e(ucfirst(request('marital_status'))); ?>

                                <a href="<?php echo e(request()->fullUrlWithQuery(['marital_status' => null])); ?>" class="ml-1 text-rose-600 hover:text-rose-800">
                                    <i class="fas fa-times"></i>
                                </a>
                            </span>
                        <?php endif; ?>
                        <?php if(request('highest_qualification')): ?>
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-teal-100 text-teal-800">
                                Qualification: <?php echo e(ucfirst(str_replace('_', ' ', request('highest_qualification')))); ?>

                                <a href="<?php echo e(request()->fullUrlWithQuery(['highest_qualification' => null])); ?>" class="ml-1 text-teal-600 hover:text-teal-800">
                                    <i class="fas fa-times"></i>
                                </a>
                            </span>
                        <?php endif; ?>
                        <a href="<?php echo e(route('members.index')); ?>" class="text-sm text-red-600 hover:text-red-800 font-medium">
                            <i class="fas fa-times-circle mr-1"></i>Clear all
                        </a>
                    </div>
                <?php endif; ?>
            </form>
        </div>

        <!-- Members Display Container -->
        <div id="members-container" class="space-y-8">
            <!-- Grid View (Default) -->
            <div id="grid-view" class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-3 gap-8">
                <?php $__empty_1 = true; $__currentLoopData = $members ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="member-card group bg-white/80 backdrop-blur-xl rounded-3xl shadow-xl border border-white/30 p-8 hover:shadow-2xl transition-all duration-500 hover:bg-white/90 hover:-translate-y-2 hover:scale-105 relative">
                        <!-- Selection Checkbox -->
                        <div class="absolute top-4 left-4 z-10">
                            <input type="checkbox" class="member-checkbox w-5 h-5 text-blue-600 border-gray-300 rounded focus:ring-blue-500 focus:ring-2 cursor-pointer" value="<?php echo e($member->id); ?>" onchange="updateSelectionCount()">
                        </div>
                        
                        <div class="flex items-start justify-between mb-6">
                            <div class="flex items-center space-x-4">
                                <div class="relative">
                                    <div class="w-16 h-16 bg-gradient-to-br from-blue-500 via-indigo-500 to-purple-500 rounded-2xl flex items-center justify-center shadow-lg group-hover:shadow-xl transition-all duration-300 overflow-hidden">
                                        <?php if($member->photo_path ?? false): ?>
                                            <img src="<?php echo e(asset('storage/' . $member->photo_path)); ?>" alt="<?php echo e($member->full_name); ?>" class="w-full h-full object-cover">
                                        <?php else: ?>
                                            <i class="fas fa-user text-white text-xl"></i>
                                        <?php endif; ?>
                                    </div>
                                    <div class="absolute -top-1 -right-1 w-5 h-5 <?php echo e(($member->membership_status ?? 'active') === 'active' ? 'bg-gradient-to-r from-emerald-400 to-emerald-500' : 'bg-gradient-to-r from-gray-400 to-gray-500'); ?> rounded-full border-2 border-white"></div>
                                </div>
                                <div>
                                    <h3 class="text-lg font-bold text-gray-900 group-hover:text-indigo-700 transition-colors duration-300"><?php echo e($member->full_name ?? 'John Doe'); ?></h3>
                                    <p class="text-sm text-gray-500 font-medium"><?php echo e($member->member_id ?? 'M2025001'); ?></p>
                                    <?php if($member->date_of_birth): ?>
                                        <p class="text-xs text-gray-400">Age: <?php echo e(\Carbon\Carbon::parse($member->date_of_birth)->age); ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="flex space-x-2">
                                <a href="<?php echo e(route('members.show', $member->id ?? 1)); ?>" class="p-3 text-blue-600 hover:bg-blue-50 rounded-xl transition-all duration-300 hover:scale-110" title="View Details">
                                    <i class="fas fa-eye text-lg"></i>
                                </a>
                                <a href="<?php echo e(route('members.edit', $member->id ?? 1)); ?>" class="p-3 text-emerald-600 hover:bg-emerald-50 rounded-xl transition-all duration-300 hover:scale-110" title="Edit Member">
                                    <i class="fas fa-edit text-lg"></i>
                                </a>
                            </div>
                        </div>
                        
                        <div class="space-y-4">
                            <?php if($member->email): ?>
                            <div class="flex items-center text-gray-600">
                                <div class="w-8 h-8 bg-gradient-to-r from-blue-100 to-indigo-100 rounded-lg flex items-center justify-center mr-3">
                                    <i class="fas fa-envelope text-blue-500"></i>
                                </div>
                                <span class="font-medium truncate"><?php echo e($member->email); ?></span>
                            </div>
                            <?php endif; ?>
                            <?php if($member->phone): ?>
                            <div class="flex items-center text-gray-600">
                                <div class="w-8 h-8 bg-gradient-to-r from-green-100 to-emerald-100 rounded-lg flex items-center justify-center mr-3">
                                    <i class="fas fa-phone text-green-500"></i>
                                </div>
                                <span class="font-medium"><?php echo e($member->phone); ?></span>
                            </div>
                            <?php endif; ?>
                            <?php if($member->family): ?>
                            <div class="flex items-center text-gray-600">
                                <div class="w-8 h-8 bg-gradient-to-r from-purple-100 to-pink-100 rounded-lg flex items-center justify-center mr-3">
                                    <i class="fas fa-home text-purple-500"></i>
                                </div>
                                <span class="font-medium truncate"><?php echo e($member->family->family_name); ?></span>
                            </div>
                            <?php endif; ?>
                            <?php if($member->membership_date): ?>
                            <div class="flex items-center text-gray-600">
                                <div class="w-8 h-8 bg-gradient-to-r from-orange-100 to-red-100 rounded-lg flex items-center justify-center mr-3">
                                    <i class="fas fa-calendar text-orange-500"></i>
                                </div>
                                <span class="font-medium">Joined <?php echo e($member->membership_date->format('M Y')); ?></span>
                            </div>
                            <?php endif; ?>
                            <?php if($member->ministries && $member->ministries->count() > 0): ?>
                            <div class="flex items-center text-gray-600">
                                <div class="w-8 h-8 bg-gradient-to-r from-yellow-100 to-amber-100 rounded-lg flex items-center justify-center mr-3">
                                    <i class="fas fa-hands-helping text-yellow-500"></i>
                                </div>
                                <span class="font-medium text-sm"><?php echo e($member->ministries->count()); ?> <?php echo e(Str::plural('Ministry', $member->ministries->count())); ?></span>
                            </div>
                            <?php endif; ?>
                        </div>

                        <div class="mt-6 pt-6 border-t border-gray-200/50">
                            <div class="flex items-center justify-between flex-wrap gap-2">
                                <span class="inline-flex items-center px-3 py-1 rounded-2xl text-xs font-bold <?php echo e(($member->membership_status ?? 'active') === 'active' ? 'bg-gradient-to-r from-green-100 to-emerald-100 text-green-800' : 'bg-gradient-to-r from-gray-100 to-gray-200 text-gray-800'); ?> shadow-sm">
                                    <i class="fas fa-circle mr-1 text-xs <?php echo e(($member->membership_status ?? 'active') === 'active' ? 'text-green-500' : 'text-gray-500'); ?>"></i>
                                    <?php echo e(ucfirst($member->membership_status ?? 'Active')); ?>

                                </span>
                                <?php
                                    $membershipType = $member->membership_type ?? 'communicant';
                                    $typeGradients = [
                                        'communicant' => 'from-blue-100 to-blue-200 text-blue-800',
                                        'baptized' => 'from-green-100 to-green-200 text-green-800',
                                        'confirmed' => 'from-purple-100 to-purple-200 text-purple-800',
                                        'long_distance' => 'from-orange-100 to-orange-200 text-orange-800',
                                        'adherent' => 'from-yellow-100 to-yellow-200 text-yellow-800',
                                        'catechumen' => 'from-pink-100 to-pink-200 text-pink-800'
                                    ];
                                    $typeLabels = [
                                        'communicant' => 'Communicant',
                                        'baptized' => 'Baptized',
                                        'confirmed' => 'Confirmed',
                                        'long_distance' => 'Long Distance',
                                        'adherent' => 'Adherent',
                                        'catechumen' => 'Catechumen'
                                    ];
                                ?>
                                <span class="inline-flex items-center px-3 py-1 bg-gradient-to-r <?php echo e($typeGradients[$membershipType] ?? 'from-gray-100 to-gray-200 text-gray-800'); ?> text-xs font-bold rounded-2xl shadow-sm">
                                    <?php echo e($typeLabels[$membershipType] ?? ucfirst($membershipType)); ?>

                                </span>
                                <?php if($member->yearGroup): ?>
                                    <span class="inline-flex items-center px-3 py-1 text-xs font-bold rounded-2xl shadow-sm text-white" style="background-color: <?php echo e($member->yearGroup->color); ?>;">
                                        <i class="fas fa-users mr-1"></i><?php echo e($member->yearGroup->abbreviation ?? $member->yearGroup->name); ?>

                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="col-span-full">
                        <div class="text-center py-16 bg-white/70 backdrop-blur-xl rounded-3xl shadow-xl border border-white/20">
                            <div class="w-24 h-24 bg-gradient-to-br from-blue-100 via-indigo-100 to-purple-100 rounded-3xl flex items-center justify-center mx-auto mb-6 shadow-lg">
                                <i class="fas fa-users text-4xl text-blue-500"></i>
                            </div>
                            <h3 class="text-2xl font-bold text-gray-900 mb-3">No members found</h3>
                            <p class="text-gray-600 text-lg mb-8">Get started by adding your first church member.</p>
                            <a href="<?php echo e(route('members.create')); ?>" class="inline-flex items-center px-8 py-4 bg-gradient-to-r from-blue-600 via-indigo-600 to-purple-600 text-white font-bold rounded-2xl hover:from-blue-700 hover:via-indigo-700 hover:to-purple-700 transition-all duration-300 shadow-xl hover:shadow-2xl transform hover:scale-105">
                                <i class="fas fa-user-plus mr-3"></i>
                                Add First Member
                                <div class="ml-2 w-2 h-2 bg-white/30 rounded-full animate-pulse"></div>
                            </a>
                        </div>
                    </div>
                <?php endif; ?>
            </div>

            <!-- List View (Hidden by default) -->
            <div id="list-view" class="hidden space-y-4">
                <?php $__empty_1 = true; $__currentLoopData = $members ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="member-row bg-white/80 backdrop-blur-xl rounded-2xl shadow-lg border border-white/30 p-6 hover:shadow-xl transition-all duration-300 hover:bg-white/90">
                        <div class="flex items-center justify-between">
                            <!-- Selection Checkbox -->
                            <div class="flex items-center mr-4">
                                <input type="checkbox" class="member-checkbox w-5 h-5 text-blue-600 border-gray-300 rounded focus:ring-blue-500 focus:ring-2 cursor-pointer" value="<?php echo e($member->id); ?>" onchange="updateSelectionCount()">
                            </div>
                            
                            <div class="flex items-center space-x-6 flex-1">
                                <!-- Photo and Basic Info -->
                                <div class="flex items-center space-x-4">
                                    <div class="relative">
                                        <div class="w-14 h-14 bg-gradient-to-br from-blue-500 via-indigo-500 to-purple-500 rounded-xl flex items-center justify-center shadow-md overflow-hidden">
                                            <?php if($member->photo_path ?? false): ?>
                                                <img src="<?php echo e(asset('storage/' . $member->photo_path)); ?>" alt="<?php echo e($member->full_name); ?>" class="w-full h-full object-cover">
                                            <?php else: ?>
                                                <i class="fas fa-user text-white"></i>
                                            <?php endif; ?>
                                        </div>
                                        <div class="absolute -top-1 -right-1 w-4 h-4 <?php echo e(($member->membership_status ?? 'active') === 'active' ? 'bg-emerald-500' : 'bg-gray-500'); ?> rounded-full border-2 border-white"></div>
                                    </div>
                                    <div>
                                        <h3 class="text-lg font-bold text-gray-900"><?php echo e($member->full_name ?? 'John Doe'); ?></h3>
                                        <p class="text-sm text-gray-500"><?php echo e($member->member_id ?? 'M2025001'); ?></p>
                                    </div>
                                </div>

                                <!-- Contact Info -->
                                <div class="hidden md:flex items-center space-x-6 flex-1">
                                    <div class="flex items-center space-x-2">
                                        <i class="fas fa-envelope text-blue-500 w-4"></i>
                                        <span class="text-sm text-gray-600 truncate max-w-48"><?php echo e($member->email ?? 'No email'); ?></span>
                                    </div>
                                    <div class="flex items-center space-x-2">
                                        <i class="fas fa-phone text-green-500 w-4"></i>
                                        <span class="text-sm text-gray-600"><?php echo e($member->phone ?? 'No phone'); ?></span>
                                    </div>
                                    <div class="flex items-center space-x-2">
                                        <i class="fas fa-home text-purple-500 w-4"></i>
                                        <span class="text-sm text-gray-600 truncate max-w-32"><?php echo e($member->family->family_name ?? 'No family'); ?></span>
                                    </div>
                                </div>

                                <!-- Status and Type -->
                                <div class="flex items-center space-x-2 flex-wrap gap-2">
                                    <span class="px-3 py-1 text-xs font-semibold rounded-full <?php echo e(($member->membership_status ?? 'active') === 'active' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'); ?>">
                                        <?php echo e(ucfirst($member->membership_status ?? 'Active')); ?>

                                    </span>
                                    <?php
                                        $membershipType = $member->membership_type ?? 'communicant';
                                        $typeColors = [
                                            'communicant' => 'bg-blue-100 text-blue-800',
                                            'baptized' => 'bg-green-100 text-green-800', 
                                            'confirmed' => 'bg-purple-100 text-purple-800',
                                            'long_distance' => 'bg-orange-100 text-orange-800',
                                            'adherent' => 'bg-yellow-100 text-yellow-800',
                                            'catechumen' => 'bg-pink-100 text-pink-800'
                                        ];
                                        $typeLabels = [
                                            'communicant' => 'Communicant',
                                            'baptized' => 'Baptized',
                                            'confirmed' => 'Confirmed', 
                                            'long_distance' => 'Long Distance',
                                            'adherent' => 'Adherent',
                                            'catechumen' => 'Catechumen'
                                        ];
                                    ?>
                                    <span class="px-3 py-1 text-xs font-semibold rounded-full <?php echo e($typeColors[$membershipType] ?? 'bg-gray-100 text-gray-800'); ?>">
                                        <?php echo e($typeLabels[$membershipType] ?? ucfirst($membershipType)); ?>

                                    </span>
                                    <?php if($member->yearGroup): ?>
                                        <span class="px-3 py-1 text-xs font-semibold rounded-full text-white" style="background-color: <?php echo e($member->yearGroup->color); ?>;">
                                            <i class="fas fa-users mr-1"></i><?php echo e($member->yearGroup->abbreviation ?? $member->yearGroup->name); ?>

                                        </span>
                                    <?php endif; ?>
                                    <?php if($member->date_of_birth): ?>
                                        <span class="text-xs text-gray-500">Age: <?php echo e(\Carbon\Carbon::parse($member->date_of_birth)->age); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <!-- Actions -->
                            <div class="flex items-center space-x-2">
                                <a href="<?php echo e(route('members.show', $member->id ?? 1)); ?>" class="p-2 text-blue-600 hover:bg-blue-50 rounded-lg transition-colors" title="View Details">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="<?php echo e(route('members.edit', $member->id ?? 1)); ?>" class="p-2 text-emerald-600 hover:bg-emerald-50 rounded-lg transition-colors" title="Edit Member">
                                    <i class="fas fa-edit"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="text-center py-16 bg-white/70 backdrop-blur-xl rounded-3xl shadow-xl border border-white/20">
                        <div class="w-24 h-24 bg-gradient-to-br from-blue-100 via-indigo-100 to-purple-100 rounded-3xl flex items-center justify-center mx-auto mb-6 shadow-lg">
                            <i class="fas fa-users text-4xl text-blue-500"></i>
                        </div>
                        <h3 class="text-2xl font-bold text-gray-900 mb-3">No members found</h3>
                        <p class="text-gray-600 text-lg mb-8">Get started by adding your first church member.</p>
                        <a href="<?php echo e(route('members.create')); ?>" class="inline-flex items-center px-8 py-4 bg-gradient-to-r from-blue-600 via-indigo-600 to-purple-600 text-white font-bold rounded-2xl hover:from-blue-700 hover:via-indigo-700 hover:to-purple-700 transition-all duration-300 shadow-xl hover:shadow-2xl transform hover:scale-105">
                            <i class="fas fa-user-plus mr-3"></i>
                            Add First Member
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Pagination -->
        <?php if(isset($members) && $members->hasPages()): ?>
            <div class="flex justify-center mt-12">
                <div class="bg-white/70 backdrop-blur-xl rounded-2xl shadow-lg border border-white/20 p-4">
                    <?php echo e($members->links()); ?>

                </div>
            </div>
        <?php endif; ?>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // View Toggle Functionality
    window.toggleView = function(viewType) {
        const gridView = document.getElementById('grid-view');
        const listView = document.getElementById('list-view');
        const gridBtn = document.getElementById('grid-btn');
        const listBtn = document.getElementById('list-btn');
        
        if (viewType === 'grid') {
            gridView.classList.remove('hidden');
            listView.classList.add('hidden');
            
            // Update button styles
            gridBtn.className = 'flex items-center px-4 py-2 rounded-xl transition-all duration-200 bg-blue-600 text-white shadow-md';
            listBtn.className = 'flex items-center px-4 py-2 rounded-xl transition-all duration-200 text-gray-600 hover:bg-gray-100';
            
            // Store preference
            localStorage.setItem('membersViewType', 'grid');
        } else {
            gridView.classList.add('hidden');
            listView.classList.remove('hidden');
            
            // Update button styles
            listBtn.className = 'flex items-center px-4 py-2 rounded-xl transition-all duration-200 bg-blue-600 text-white shadow-md';
            gridBtn.className = 'flex items-center px-4 py-2 rounded-xl transition-all duration-200 text-gray-600 hover:bg-gray-100';
            
            // Store preference
            localStorage.setItem('membersViewType', 'list');
        }
    };
    
    // Load saved view preference
    const savedView = localStorage.getItem('membersViewType') || 'grid';
    toggleView(savedView);
    
    // Export Dropdown Toggle
    window.toggleExportDropdown = function() {
        const menu = document.getElementById('export-menu');
        menu.classList.toggle('hidden');
    };
    
    // Close dropdown when clicking outside
    document.addEventListener('click', function(event) {
        const dropdown = document.getElementById('export-dropdown');
        const menu = document.getElementById('export-menu');
        
        if (!dropdown.contains(event.target)) {
            menu.classList.add('hidden');
        }
    });
    
    // Export Members Functionality with format selection
    window.exportMembers = function(format = 'csv') {
        // Close the dropdown
        document.getElementById('export-menu').classList.add('hidden');
        
        // Get current filter parameters
        const urlParams = new URLSearchParams(window.location.search);
        const exportUrl = new URL('/members/export', window.location.origin);
        
        // Add format parameter
        exportUrl.searchParams.set('format', format);
        
        // Add current filters to export URL
        for (const [key, value] of urlParams) {
            exportUrl.searchParams.set(key, value);
        }
        
        // Show loading indicator
        const button = event.target.closest('button');
        const originalContent = button.innerHTML;
        button.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>Exporting...';
        button.disabled = true;
        
        // Use fetch to handle the download properly with authentication
        const csrfToken = document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || '';
        
        fetch(exportUrl.toString(), {
            method: 'GET',
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                ...(csrfToken && { 'X-CSRF-TOKEN': csrfToken })
            },
            credentials: 'same-origin'
        })
        .then(response => {
            if (!response.ok) {
                throw new Error(`HTTP error! status: ${response.status}`);
            }
            
            // Get filename from Content-Disposition header
            const contentDisposition = response.headers.get('Content-Disposition');
            let filename = `members_export_${new Date().toISOString().slice(0,19).replace(/:/g, '-')}.csv`;
            if (contentDisposition) {
                const filenameMatch = contentDisposition.match(/filename="(.+)"/);
                if (filenameMatch) {
                    filename = filenameMatch[1];
                }
            }
            
            return response.blob().then(blob => ({ blob, filename }));
        })
        .then(({ blob, filename }) => {
            // Create download link
            const url = window.URL.createObjectURL(blob);
            const link = document.createElement('a');
            link.href = url;
            link.download = filename;
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
            window.URL.revokeObjectURL(url);
            
            showNotification(`Export completed! Downloaded ${filename}`, 'success');
        })
        .catch(error => {
            console.error('Export error:', error);
            console.error('Export URL:', exportUrl.toString());
            showNotification(`Export failed: ${error.message}. Check browser console for details.`, 'error');
        })
        .finally(() => {
            // Reset button
            button.innerHTML = originalContent;
            button.disabled = false;
        });
    };
    
    // Real-time search functionality
    let searchTimeout;
    const searchInput = document.querySelector('input[name="search"]');
    if (searchInput) {
        searchInput.addEventListener('input', function() {
            clearTimeout(searchTimeout);
            searchTimeout = setTimeout(() => {
                // Auto-submit form after 500ms of no typing
                this.form.submit();
            }, 500);
        });
    }
    
    // Enhanced filter interactions
    const filterSelects = document.querySelectorAll('select[name="status"], select[name="type"], select[name="gender"], select[name="age_range"]');
    filterSelects.forEach(select => {
        select.addEventListener('change', function() {
            // Auto-submit form when filter changes
            this.form.submit();
        });
    });
    
    // Smooth animations for member cards
    const observerOptions = {
        threshold: 0.1,
        rootMargin: '0px 0px -50px 0px'
    };
    
    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.style.opacity = '1';
                entry.target.style.transform = 'translateY(0)';
            }
        });
    }, observerOptions);
    
    // Observe member cards for animation
    document.querySelectorAll('.member-card, .member-row').forEach(card => {
        card.style.opacity = '0';
        card.style.transform = 'translateY(20px)';
        card.style.transition = 'opacity 0.6s ease, transform 0.6s ease';
        observer.observe(card);
    });
    
    // Quick actions for member cards
    document.querySelectorAll('.member-card').forEach(card => {
        card.addEventListener('mouseenter', function() {
            this.style.transform = 'translateY(-8px) scale(1.02)';
        });
        
        card.addEventListener('mouseleave', function() {
            this.style.transform = 'translateY(0) scale(1)';
        });
    });
    
    // Keyboard shortcuts
    document.addEventListener('keydown', function(e) {
        // Ctrl/Cmd + K to focus search
        if ((e.ctrlKey || e.metaKey) && e.key === 'k') {
            e.preventDefault();
            searchInput?.focus();
        }
        
        // G for grid view, L for list view
        if (e.target.tagName !== 'INPUT' && e.target.tagName !== 'TEXTAREA') {
            if (e.key === 'g' || e.key === 'G') {
                toggleView('grid');
            } else if (e.key === 'l' || e.key === 'L') {
                toggleView('list');
            }
        }
    });
    
    // Add keyboard shortcut hints
    const shortcutHints = document.createElement('div');
    shortcutHints.className = 'fixed bottom-4 right-4 bg-black/80 text-white text-xs px-3 py-2 rounded-lg opacity-0 transition-opacity duration-300';
    shortcutHints.innerHTML = `
        <div class="space-y-1">
            <div><kbd class="bg-gray-700 px-1 rounded">Ctrl+K</kbd> Search</div>
            <div><kbd class="bg-gray-700 px-1 rounded">G</kbd> Grid view</div>
            <div><kbd class="bg-gray-700 px-1 rounded">L</kbd> List view</div>
        </div>
    `;
    document.body.appendChild(shortcutHints);
    
    // Show shortcuts on hover over view toggle
    const viewToggle = document.querySelector('.flex.items-center.bg-white\\/80');
    if (viewToggle) {
        viewToggle.addEventListener('mouseenter', () => {
            shortcutHints.style.opacity = '1';
        });
        
        viewToggle.addEventListener('mouseleave', () => {
            shortcutHints.style.opacity = '0';
        });
    }
    
    // Quick Action Functions (attached to window for global access)
    window.bulkImport = function() {
        window.location.href = '<?php echo e(route("members.bulk-import")); ?>';
    };
    
    window.printDirectory = function() {
        const printUrl = '<?php echo e(route("members.index")); ?>' + '?print=1&' + new URLSearchParams(window.location.search);
        window.open(printUrl, '_blank');
    };
    
    window.sendBulkSMS = function() {
        // Show modal or redirect to bulk SMS page
        alert('Bulk SMS functionality - Coming Soon!\n\nThis feature will allow you to send SMS messages to selected members.');
    };
    
    // Bulk Delete Functions
    window.toggleSelectAll = function(checkbox) {
        const memberCheckboxes = document.querySelectorAll('.member-checkbox');
        memberCheckboxes.forEach(cb => {
            cb.checked = checkbox.checked;
        });
        updateSelectionCount();
    };
    
    window.updateSelectionCount = function() {
        const checkedBoxes = document.querySelectorAll('.member-checkbox:checked');
        const count = checkedBoxes.length;
        const selectAllCheckbox = document.getElementById('select-all');
        const bulkDeleteBtn = document.getElementById('bulk-delete-btn');
        const selectedCountSpan = document.getElementById('selected-count');
        
        // Update count display
        if (selectedCountSpan) {
            selectedCountSpan.textContent = count;
        }
        
        // Show/hide bulk delete button
        if (count > 0) {
            bulkDeleteBtn?.classList.remove('hidden');
        } else {
            bulkDeleteBtn?.classList.add('hidden');
        }
        
        // Update select all checkbox state
        const totalCheckboxes = document.querySelectorAll('.member-checkbox').length;
        if (selectAllCheckbox) {
            selectAllCheckbox.checked = count === totalCheckboxes && count > 0;
            selectAllCheckbox.indeterminate = count > 0 && count < totalCheckboxes;
        }
    };
    
    window.bulkDeleteMembers = function() {
        const checkedBoxes = document.querySelectorAll('.member-checkbox:checked');
        const memberIds = Array.from(checkedBoxes).map(cb => cb.value);
        
        if (memberIds.length === 0) {
            alert('Please select at least one member to delete.');
            return;
        }
        
        const confirmMessage = `Are you sure you want to delete ${memberIds.length} member(s)?\n\nThis action cannot be undone and will permanently delete:\n- Member records\n- Profile photos\n- All associated data\n\nType "DELETE" to confirm:`;
        
        const userInput = prompt(confirmMessage);
        
        if (userInput === 'DELETE') {
            // Create form and submit
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = '<?php echo e(route("members.bulk-delete")); ?>';
            
            // Add CSRF token
            const csrfInput = document.createElement('input');
            csrfInput.type = 'hidden';
            csrfInput.name = '_token';
            csrfInput.value = '<?php echo e(csrf_token()); ?>';
            form.appendChild(csrfInput);
            
            // Add member IDs
            memberIds.forEach(id => {
                const input = document.createElement('input');
                input.type = 'hidden';
                input.name = 'member_ids[]';
                input.value = id;
                form.appendChild(input);
            });
            
            document.body.appendChild(form);
            form.submit();
        } else if (userInput !== null) {
            alert('Deletion cancelled. You must type "DELETE" exactly to confirm.');
        }
    };
    
    // Enhanced member card interactions
    function viewMember(memberId) {
        window.location.href = `/members/${memberId}`;
    }
    
    function editMember(memberId) {
        window.location.href = `/members/${memberId}/edit`;
    }
    
    // Add notification system
    function showNotification(message, type = 'info') {
        const notification = document.createElement('div');
        notification.className = `fixed top-4 right-4 px-6 py-4 rounded-xl shadow-lg z-50 transform translate-x-full transition-transform duration-300 ${
            type === 'success' ? 'bg-green-600 text-white' : 
            type === 'error' ? 'bg-red-600 text-white' : 
            'bg-blue-600 text-white'
        }`;
        notification.innerHTML = `
            <div class="flex items-center">
                <i class="fas ${type === 'success' ? 'fa-check-circle' : type === 'error' ? 'fa-exclamation-circle' : 'fa-info-circle'} mr-3"></i>
                <span>${message}</span>
                <button onclick="this.parentElement.parentElement.remove()" class="ml-4 text-white/80 hover:text-white">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        `;
        
        document.body.appendChild(notification);
        
        // Animate in
        setTimeout(() => {
            notification.style.transform = 'translateX(0)';
        }, 100);
        
        // Auto remove after 5 seconds
        setTimeout(() => {
            notification.style.transform = 'translateX(full)';
            setTimeout(() => notification.remove(), 300);
        }, 5000);
    }
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('components.app-layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/presby_app/resources/views/members/index.blade.php ENDPATH**/ ?>