<?php if (isset($component)) { $__componentOriginal4619374cef299e94fd7263111d0abc69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal4619374cef299e94fd7263111d0abc69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.app-layout','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <div class="max-w-4xl mx-auto">
        <!-- Back Navigation -->
        <div class="mb-6">
            <a href="<?php echo e(route('users.show', $user)); ?>" class="inline-flex items-center text-gray-600 hover:text-purple-600 transition-colors duration-200">
                <i class="fas fa-arrow-left mr-2"></i>
                <span class="font-medium">Back to User Profile</span>
            </a>
        </div>

        <!-- Page Header -->
        <div class="mb-8 bg-gradient-to-r from-blue-600 via-purple-600 to-red-600 rounded-xl shadow-lg p-6 text-white">
            <div class="flex items-center">
                <?php if($user->profile_photo): ?>
                <img src="<?php echo e(asset('storage/' . $user->profile_photo)); ?>" 
                     alt="<?php echo e($user->name); ?>" 
                     class="w-16 h-16 rounded-full border-3 border-white shadow-lg object-cover">
                <?php else: ?>
                <div class="w-16 h-16 rounded-full border-3 border-white shadow-lg bg-white bg-opacity-20 flex items-center justify-center">
                    <span class="text-white text-2xl font-bold"><?php echo e(substr($user->name, 0, 1)); ?></span>
                </div>
                <?php endif; ?>
                <div class="ml-4">
                    <h1 class="text-2xl font-bold">Edit User Profile</h1>
                    <p class="text-blue-100 text-sm"><?php echo e($user->name); ?></p>
                </div>
            </div>
        </div>

        <!-- Messages -->
        <?php if(session('success')): ?>
        <div class="mb-6 bg-green-50 border-l-4 border-green-500 p-4 rounded-lg">
            <div class="flex items-center">
                <i class="fas fa-check-circle text-green-500 mr-3"></i>
                <p class="text-green-800 font-medium"><?php echo e(session('success')); ?></p>
            </div>
        </div>
        <?php endif; ?>

        <?php if($errors->any()): ?>
        <div class="mb-6 bg-red-50 border-l-4 border-red-500 p-4 rounded-lg">
            <div class="flex items-center mb-2">
                <i class="fas fa-exclamation-circle text-red-500 mr-3"></i>
                <p class="text-red-800 font-medium">Please correct the errors below</p>
            </div>
        </div>
        <?php endif; ?>

        <!-- Form -->
        <form action="<?php echo e(route('users.update', $user)); ?>" method="POST" class="bg-white rounded-xl shadow-lg p-8 space-y-8">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>
            
            <!-- Basic Information -->
            <div>
                <h3 class="text-lg font-semibold text-gray-800 mb-4 pb-2 border-b border-gray-200">
                    Basic Information
                </h3>
                <div class="space-y-4">
                    <div>
                        <label for="name" class="block text-sm font-medium text-gray-700 mb-2">
                            Full Name <span class="text-red-500">*</span>
                        </label>
                        <input type="text" 
                               name="name" 
                               id="name" 
                               value="<?php echo e(old('name', $user->name)); ?>" 
                               required
                               class="w-full px-4 py-2 rounded-lg border-gray-300 focus:ring-purple-500 focus:border-purple-500"
                               placeholder="Enter full name">
                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div>
                        <label for="email" class="block text-sm font-medium text-gray-700 mb-2">
                            Email Address <span class="text-red-500">*</span>
                        </label>
                        <input type="email" 
                               name="email" 
                               id="email" 
                               value="<?php echo e(old('email', $user->email)); ?>" 
                               required
                               class="w-full px-4 py-2 rounded-lg border-gray-300 focus:ring-purple-500 focus:border-purple-500"
                               placeholder="user@example.com">
                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>
                        
            <!-- Roles & Permissions -->
            <div>
                <h3 class="text-lg font-semibold text-gray-800 mb-4 pb-2 border-b border-gray-200">
                    Roles & Permissions
                </h3>
                <div class="space-y-4">
                    <div>
                        <label for="role_id" class="block text-sm font-medium text-gray-700 mb-2">
                            Primary Role <span class="text-xs text-green-600">(Recommended)</span>
                        </label>
                        <select name="role_id" id="role_id" class="w-full px-4 py-2 rounded-lg border-gray-300 focus:ring-purple-500 focus:border-purple-500">
                            <option value="">-- Select a Role --</option>
                            <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($role->id); ?>" <?php echo e(old('role_id', $user->role_id) == $role->id ? 'selected' : ''); ?>>
                                    <?php echo e($role->name); ?> (<?php echo e($role->permissions_count ?? $role->permissions->count()); ?> permissions)
                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <p class="mt-1 text-xs text-gray-500">Assign a role with specific permissions</p>
                        <?php $__errorArgs = ['role_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div>
                        <label for="role" class="block text-sm font-medium text-gray-700 mb-2">
                            System Access Level <span class="text-red-500">*</span>
                        </label>
                        <select name="role" id="role" required class="w-full px-4 py-2 rounded-lg border-gray-300 focus:ring-purple-500 focus:border-purple-500">
                            <option value="admin" <?php echo e(old('role', $user->role) === 'admin' ? 'selected' : ''); ?>>
                                Administrator - Full system access
                            </option>
                            <option value="staff" <?php echo e(old('role', $user->role) === 'staff' ? 'selected' : ''); ?>>
                                Staff Member - Standard access
                            </option>
                            <option value="student" <?php echo e(old('role', $user->role) === 'student' ? 'selected' : ''); ?>>
                                Member - Limited access
                            </option>
                        </select>
                        <p class="mt-1 text-xs text-gray-500">Fallback access level when no primary role is assigned</p>
                        <?php $__errorArgs = ['role'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>
                        
            <!-- Password -->
            <div>
                <h3 class="text-lg font-semibold text-gray-800 mb-4 pb-2 border-b border-gray-200">
                    Change Password <span class="text-sm text-gray-500 font-normal">(Optional)</span>
                </h3>
                <div class="bg-blue-50 border-l-4 border-blue-400 p-3 mb-4 rounded">
                    <p class="text-sm text-blue-800">Leave blank to keep current password</p>
                </div>
                <div class="space-y-4">
                    <div>
                        <label for="password" class="block text-sm font-medium text-gray-700 mb-2">
                            New Password
                        </label>
                        <input type="password" 
                               name="password" 
                               id="password" 
                               class="w-full px-4 py-2 rounded-lg border-gray-300 focus:ring-purple-500 focus:border-purple-500"
                               placeholder="Enter new password">
                        <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <p class="mt-1 text-xs text-gray-500">Minimum 8 characters</p>
                    </div>
                    
                    <div>
                        <label for="password_confirmation" class="block text-sm font-medium text-gray-700 mb-2">
                            Confirm Password
                        </label>
                        <input type="password" 
                               name="password_confirmation" 
                               id="password_confirmation" 
                               class="w-full px-4 py-2 rounded-lg border-gray-300 focus:ring-purple-500 focus:border-purple-500"
                               placeholder="Confirm new password">
                    </div>
                </div>
            </div>
            
            <!-- Actions -->
            <div class="flex items-center justify-between pt-6 border-t border-gray-200">
                <a href="<?php echo e(route('users.show', $user)); ?>" 
                   class="px-6 py-2 bg-gray-100 hover:bg-gray-200 text-gray-700 rounded-lg font-medium transition">
                    Cancel
                </a>
                
                <button type="submit" 
                        class="px-8 py-2 bg-gradient-to-r from-purple-600 to-blue-600 hover:from-purple-700 hover:to-blue-700 text-white rounded-lg font-semibold shadow-lg transition">
                    Update User
                </button>
            </div>
        </form>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal4619374cef299e94fd7263111d0abc69)): ?>
<?php $attributes = $__attributesOriginal4619374cef299e94fd7263111d0abc69; ?>
<?php unset($__attributesOriginal4619374cef299e94fd7263111d0abc69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4619374cef299e94fd7263111d0abc69)): ?>
<?php $component = $__componentOriginal4619374cef299e94fd7263111d0abc69; ?>
<?php unset($__componentOriginal4619374cef299e94fd7263111d0abc69); ?>
<?php endif; ?>
<?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/presby_app/resources/views/users/edit.blade.php ENDPATH**/ ?>