<?php $__env->startSection('title', 'Bulk Import Members'); ?>

<?php
    $dynamicSubtitle = 'Import multiple members to ' . (isset($organizationSettings) ? $organizationSettings['name'] : 'Presbyterian Church of Ghana');
?>

<?php $__env->startSection('subtitle', $dynamicSubtitle); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-8">
    <!-- Header Section -->
    <div class="relative overflow-hidden bg-gradient-to-r from-emerald-600 via-green-600 to-teal-600 rounded-3xl shadow-2xl">
        <div class="absolute inset-0 bg-black opacity-5"></div>
        
        <div class="relative px-8 py-16">
            <div class="max-w-4xl mx-auto text-center">
                <div class="inline-flex items-center justify-center w-20 h-20 bg-white bg-opacity-20 backdrop-blur-sm rounded-2xl mb-6 shadow-xl">
                    <i class="fas fa-file-excel text-3xl text-white"></i>
                </div>
                <h1 class="text-5xl font-bold text-white mb-4">Bulk Import Members</h1>
                <p class="text-xl text-white opacity-90 mb-8 max-w-2xl mx-auto">
                    Import multiple church members at once using an Excel file. Streamline your member registration process.
                </p>
                <div class="flex items-center justify-center space-x-8 text-white/80">
                    <div class="flex items-center">
                        <i class="fas fa-users mr-2"></i>
                        <span class="text-sm">Multiple Members</span>
                    </div>
                    <div class="flex items-center">
                        <i class="fas fa-clock mr-2"></i>
                        <span class="text-sm">Time Saving</span>
                    </div>
                    <div class="flex items-center">
                        <i class="fas fa-check-circle mr-2"></i>
                        <span class="text-sm">Validated Data</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Success/Error Messages -->
    <?php if(session('success')): ?>
        <div class="bg-green-50 border border-green-200 rounded-2xl p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <i class="fas fa-check-circle text-green-600 text-2xl"></i>
                </div>
                <div class="ml-4">
                    <h3 class="text-lg font-semibold text-green-800">Import Successful!</h3>
                    <p class="text-green-700"><?php echo e(session('success')); ?></p>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php if(session('error')): ?>
        <div class="bg-red-50 border border-red-200 rounded-2xl p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <i class="fas fa-exclamation-circle text-red-600 text-2xl"></i>
                </div>
                <div class="ml-4">
                    <h3 class="text-lg font-semibold text-red-800">Import Failed</h3>
                    <p class="text-red-700"><?php echo e(session('error')); ?></p>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <!-- Import Results -->
    <?php if(session('import_results')): ?>
        <?php $results = session('import_results'); ?>
        <div class="bg-blue-50 border border-blue-200 rounded-2xl p-6">
            <h3 class="text-lg font-semibold text-blue-800 mb-4">Import Results</h3>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                <div class="bg-green-100 rounded-lg p-4">
                    <div class="text-2xl font-bold text-green-800"><?php echo e($results['success']); ?></div>
                    <div class="text-green-600">Members Imported</div>
                </div>
                <div class="bg-red-100 rounded-lg p-4">
                    <div class="text-2xl font-bold text-red-800"><?php echo e($results['errors']); ?></div>
                    <div class="text-red-600">Errors Encountered</div>
                </div>
            </div>
            
            <?php if(!empty($results['error_details'])): ?>
                <div class="mt-4">
                    <h4 class="font-semibold text-red-800 mb-2">Error Details:</h4>
                    <div class="max-h-60 overflow-y-auto">
                        <?php $__currentLoopData = $results['error_details']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="bg-red-100 rounded-lg p-3 mb-2">
                                <div class="font-medium text-red-800">Row <?php echo e($error['row']); ?>:</div>
                                <ul class="text-red-700 text-sm mt-1">
                                    <?php $__currentLoopData = $error['errors']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $errorMsg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li>• <?php echo e($errorMsg); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    <?php endif; ?>

    <!-- Main Content -->
    <div class="max-w-4xl mx-auto">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
            <!-- Upload Form -->
            <div class="bg-white/90 backdrop-blur-sm rounded-2xl shadow-xl border border-gray-100/50 p-8 hover:shadow-2xl transition-all duration-300">
                <div class="flex items-center mb-6">
                    <div class="w-12 h-12 bg-gradient-to-br from-emerald-600 to-green-600 rounded-xl flex items-center justify-center shadow-lg">
                        <i class="fas fa-upload text-white text-xl"></i>
                    </div>
                    <div class="ml-4">
                        <h2 class="text-2xl font-bold text-gray-900">Upload Excel File</h2>
                        <p class="text-gray-600">Select your member data file to import</p>
                    </div>
                </div>

                <form action="<?php echo e(route('members.bulk-import.process')); ?>" method="POST" enctype="multipart/form-data" class="space-y-6">
                    <?php echo csrf_field(); ?>
                    
                    <div>
                        <label for="excel_file" class="block text-sm font-medium text-gray-700 mb-2">
                            Excel File (xlsx, xls, csv)
                        </label>
                        <div class="relative">
                            <div class="flex items-center justify-center w-full">
                                <label for="excel_file" class="flex flex-col items-center justify-center w-full h-32 border-2 border-gray-300 border-dashed rounded-xl cursor-pointer bg-gray-50 hover:bg-gray-100 transition-all duration-200">
                                    <div class="flex flex-col items-center justify-center pt-5 pb-6">
                                        <i class="fas fa-cloud-upload-alt text-3xl text-gray-400 mb-2"></i>
                                        <p class="mb-2 text-sm text-gray-500"><span class="font-semibold">Click to upload</span> or drag and drop</p>
                                        <p class="text-xs text-gray-500">Excel (.xlsx, .xls) or CSV files (MAX. 10MB)</p>
                                    </div>
                                    <input type="file" 
                                           id="excel_file" 
                                           name="excel_file" 
                                           accept=".xlsx,.xls,.csv"
                                           class="hidden"
                                           required
                                           onchange="updateFileName(this)">
                                </label>
                            </div>
                            <div id="file-name" class="mt-2 text-sm text-gray-600 hidden"></div>
                        </div>
                        <?php $__errorArgs = ['excel_file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="bg-yellow-50 border border-yellow-200 rounded-xl p-4">
                        <div class="flex items-start">
                            <i class="fas fa-exclamation-triangle text-yellow-600 mt-1"></i>
                            <div class="ml-3">
                                <h4 class="text-sm font-medium text-yellow-800">Important Notes:</h4>
                                <ul class="text-sm text-yellow-700 mt-1 space-y-1">
                                    <li>• Maximum file size: 10MB</li>
                                    <li>• Supported formats: Excel (.xlsx, .xls) and CSV (.csv)</li>
                                    <li>• Default password for imported members: "password123"</li>
                                    <li>• Members with existing phone numbers will be skipped</li>
                                    <li>• Email is optional but must be valid if provided</li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <button type="submit" class="w-full bg-gradient-to-r from-emerald-600 via-green-600 to-teal-600 text-white font-bold py-4 px-6 rounded-xl hover:from-emerald-700 hover:via-green-700 hover:to-teal-700 transition-all duration-300 transform hover:scale-105 shadow-xl hover:shadow-2xl">
                        <i class="fas fa-upload mr-2"></i>
                        Import Members
                        <div class="inline-block ml-2 w-2 h-2 bg-white/30 rounded-full animate-pulse"></div>
                    </button>
                </form>
            </div>

            <!-- Instructions -->
            <div class="bg-white/90 backdrop-blur-sm rounded-2xl shadow-xl border border-gray-100/50 p-8 hover:shadow-2xl transition-all duration-300">
                <div class="flex items-center mb-6">
                    <div class="w-12 h-12 bg-gradient-to-br from-blue-600 to-indigo-600 rounded-xl flex items-center justify-center shadow-lg">
                        <i class="fas fa-info-circle text-white text-xl"></i>
                    </div>
                    <div class="ml-4">
                        <h2 class="text-2xl font-bold text-gray-900">Step-by-Step Guide</h2>
                        <p class="text-gray-600">Follow these steps for successful import</p>
                    </div>
                </div>

                <div class="space-y-6">
                    <div class="flex items-start group">
                        <div class="w-10 h-10 bg-gradient-to-br from-emerald-500 to-green-600 text-white rounded-full flex items-center justify-center text-sm font-bold mr-4 mt-1 shadow-lg group-hover:scale-110 transition-transform duration-200">1</div>
                        <div class="flex-1">
                            <h4 class="font-semibold text-gray-900 mb-1">Download Template</h4>
                            <p class="text-gray-600 text-sm mb-2">Use our pre-formatted Excel template to ensure proper data structure</p>
                            <div class="flex items-center text-xs text-emerald-600">
                                <i class="fas fa-download mr-1"></i>
                                <span>Click the button below to download</span>
                            </div>
                        </div>
                    </div>
                    
                    <div class="flex items-start group">
                        <div class="w-10 h-10 bg-gradient-to-br from-blue-500 to-indigo-600 text-white rounded-full flex items-center justify-center text-sm font-bold mr-4 mt-1 shadow-lg group-hover:scale-110 transition-transform duration-200">2</div>
                        <div class="flex-1">
                            <h4 class="font-semibold text-gray-900 mb-1">Fill Member Data</h4>
                            <p class="text-gray-600 text-sm mb-2">Enter member information following the template format exactly</p>
                            <div class="flex items-center text-xs text-blue-600">
                                <i class="fas fa-edit mr-1"></i>
                                <span>Required: First Name, Last Name, Phone, Gender</span>
                            </div>
                        </div>
                    </div>
                    
                    <div class="flex items-start group">
                        <div class="w-10 h-10 bg-gradient-to-br from-purple-500 to-pink-600 text-white rounded-full flex items-center justify-center text-sm font-bold mr-4 mt-1 shadow-lg group-hover:scale-110 transition-transform duration-200">3</div>
                        <div class="flex-1">
                            <h4 class="font-semibold text-gray-900 mb-1">Upload & Import</h4>
                            <p class="text-gray-600 text-sm mb-2">Upload your completed file and review the import results</p>
                            <div class="flex items-center text-xs text-purple-600">
                                <i class="fas fa-cloud-upload-alt mr-1"></i>
                                <span>Drag & drop or click to select file</span>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="mt-8">
                    <a href="<?php echo e(route('members.bulk-import.template')); ?>" 
                       class="w-full bg-gradient-to-r from-emerald-600 via-green-600 to-teal-600 text-white font-bold py-4 px-6 rounded-xl hover:from-emerald-700 hover:via-green-700 hover:to-teal-700 transition-all duration-300 transform hover:scale-105 shadow-xl hover:shadow-2xl inline-flex items-center justify-center group">
                        <i class="fas fa-download mr-3 group-hover:animate-bounce"></i>
                        Download Excel Template
                        <div class="ml-2 w-2 h-2 bg-white/30 rounded-full animate-pulse"></div>
                    </a>
                </div>

                <!-- Field Requirements -->
                <div class="mt-6 space-y-4">
                    <div class="p-4 bg-gradient-to-r from-emerald-50 to-green-50 border border-emerald-200 rounded-xl">
                        <h4 class="font-semibold text-emerald-800 mb-3 flex items-center">
                            <i class="fas fa-check-circle mr-2"></i>
                            Required Fields
                        </h4>
                        <div class="grid grid-cols-2 gap-3 text-sm">
                            <div class="flex items-center text-emerald-700">
                                <i class="fas fa-user mr-2 text-xs"></i>
                                First Name
                            </div>
                            <div class="flex items-center text-emerald-700">
                                <i class="fas fa-user mr-2 text-xs"></i>
                                Last Name
                            </div>
                            <div class="flex items-center text-emerald-700">
                                <i class="fas fa-phone mr-2 text-xs"></i>
                                Phone Number
                            </div>
                            <div class="flex items-center text-emerald-700">
                                <i class="fas fa-venus-mars mr-2 text-xs"></i>
                                Gender
                            </div>
                        </div>
                    </div>
                    
                    <div class="p-4 bg-gradient-to-r from-blue-50 to-indigo-50 border border-blue-200 rounded-xl">
                        <h4 class="font-semibold text-blue-800 mb-3 flex items-center">
                            <i class="fas fa-info-circle mr-2"></i>
                            Optional Fields
                        </h4>
                        <div class="text-sm text-blue-700 space-y-1">
                            <div>• Middle Name • Email Address • Date of Birth</div>
                            <div>• Home Address • Occupation • Marital Status</div>
                            <div>• Emergency Contact • Ministry Preferences • Special Notes</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Back to Members -->
    <div class="max-w-4xl mx-auto">
        <a href="<?php echo e(route('members.index')); ?>" 
           class="inline-flex items-center px-6 py-3 bg-white/80 backdrop-blur-sm border border-gray-200 text-gray-700 font-medium rounded-xl hover:bg-gray-50 hover:shadow-lg transition-all duration-200 transform hover:scale-105">
            <i class="fas fa-arrow-left mr-2"></i>
            Back to Members
        </a>
    </div>
</div>

<script>
// File upload functionality
function updateFileName(input) {
    const fileNameDiv = document.getElementById('file-name');
    const label = input.parentElement;
    
    if (input.files && input.files[0]) {
        const fileName = input.files[0].name;
        const fileSize = (input.files[0].size / 1024 / 1024).toFixed(2);
        
        fileNameDiv.innerHTML = `
            <div class="flex items-center justify-between p-3 bg-emerald-50 border border-emerald-200 rounded-lg">
                <div class="flex items-center">
                    <i class="fas fa-file-excel text-emerald-600 mr-2"></i>
                    <div>
                        <div class="font-medium text-emerald-800">${fileName}</div>
                        <div class="text-xs text-emerald-600">${fileSize} MB</div>
                    </div>
                </div>
                <button type="button" onclick="clearFile()" class="text-red-500 hover:text-red-700">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        `;
        fileNameDiv.classList.remove('hidden');
        
        // Update label appearance
        label.classList.add('border-emerald-300', 'bg-emerald-50');
        label.classList.remove('border-gray-300', 'bg-gray-50');
    }
}

function clearFile() {
    const input = document.getElementById('excel_file');
    const fileNameDiv = document.getElementById('file-name');
    const label = input.parentElement;
    
    input.value = '';
    fileNameDiv.classList.add('hidden');
    
    // Reset label appearance
    label.classList.remove('border-emerald-300', 'bg-emerald-50');
    label.classList.add('border-gray-300', 'bg-gray-50');
}

// Drag and drop functionality
const dropArea = document.querySelector('label[for="excel_file"]');

['dragenter', 'dragover', 'dragleave', 'drop'].forEach(eventName => {
    dropArea.addEventListener(eventName, preventDefaults, false);
});

function preventDefaults(e) {
    e.preventDefault();
    e.stopPropagation();
}

['dragenter', 'dragover'].forEach(eventName => {
    dropArea.addEventListener(eventName, highlight, false);
});

['dragleave', 'drop'].forEach(eventName => {
    dropArea.addEventListener(eventName, unhighlight, false);
});

function highlight(e) {
    dropArea.classList.add('border-emerald-400', 'bg-emerald-100');
}

function unhighlight(e) {
    dropArea.classList.remove('border-emerald-400', 'bg-emerald-100');
}

dropArea.addEventListener('drop', handleDrop, false);

function handleDrop(e) {
    const dt = e.dataTransfer;
    const files = dt.files;
    
    const input = document.getElementById('excel_file');
    input.files = files;
    
    updateFileName(input);
}

// Form validation
document.querySelector('form').addEventListener('submit', function(e) {
    const fileInput = document.getElementById('excel_file');
    
    if (!fileInput.files || !fileInput.files[0]) {
        e.preventDefault();
        showNotification('Please select a file to upload', 'error');
        return false;
    }
    
    const file = fileInput.files[0];
    const maxSize = 10 * 1024 * 1024; // 10MB
    
    if (file.size > maxSize) {
        e.preventDefault();
        showNotification('File size must be less than 10MB', 'error');
        return false;
    }
    
    const allowedTypes = [
        'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
        'application/vnd.ms-excel',
        'text/csv'
    ];
    
    if (!allowedTypes.includes(file.type)) {
        e.preventDefault();
        showNotification('Please select a valid Excel or CSV file', 'error');
        return false;
    }
    
    // Show loading state
    const submitBtn = this.querySelector('button[type="submit"]');
    submitBtn.innerHTML = `
        <i class="fas fa-spinner fa-spin mr-2"></i>
        Processing Import...
    `;
    submitBtn.disabled = true;
});

// Notification system
function showNotification(message, type = 'info') {
    const notification = document.createElement('div');
    notification.className = `fixed top-4 right-4 px-6 py-4 rounded-xl shadow-lg z-50 transform translate-x-full transition-transform duration-300 ${
        type === 'success' ? 'bg-emerald-600 text-white' : 
        type === 'error' ? 'bg-red-600 text-white' : 
        'bg-blue-600 text-white'
    }`;
    notification.innerHTML = `
        <div class="flex items-center">
            <i class="fas ${type === 'success' ? 'fa-check-circle' : type === 'error' ? 'fa-exclamation-circle' : 'fa-info-circle'} mr-3"></i>
            <span>${message}</span>
            <button onclick="this.parentElement.parentElement.remove()" class="ml-4 text-white/80 hover:text-white">
                <i class="fas fa-times"></i>
            </button>
        </div>
    `;
    
    document.body.appendChild(notification);
    
    // Animate in
    setTimeout(() => {
        notification.style.transform = 'translateX(0)';
    }, 100);
    
    // Auto remove after 5 seconds
    setTimeout(() => {
        notification.style.transform = 'translateX(100%)';
        setTimeout(() => notification.remove(), 300);
    }, 5000);
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('components.app-layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/presby_app/resources/views/members/bulk-import.blade.php ENDPATH**/ ?>