<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames(([
    'type' => 'button',
    'variant' => 'primary',
    'size' => 'md',
    'href' => null,
    'disabled' => false,
    'icon' => null,
    'iconPosition' => 'left',
    'fullWidth' => false,
]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter(([
    'type' => 'button',
    'variant' => 'primary',
    'size' => 'md',
    'href' => null,
    'disabled' => false,
    'icon' => null,
    'iconPosition' => 'left',
    'fullWidth' => false,
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars); ?>

<?php
    $baseClasses = 'inline-flex items-center justify-center font-medium transition-colors duration-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-offset-2';
    
    $variantClasses = [
        'primary' => 'bg-primary-600 text-white hover:bg-primary-700 focus:ring-primary-500',
        'secondary' => 'bg-gray-100 text-gray-800 hover:bg-gray-200 focus:ring-gray-500',
        'success' => 'bg-green-600 text-white hover:bg-green-700 focus:ring-green-500',
        'danger' => 'bg-red-600 text-white hover:bg-red-700 focus:ring-red-500',
        'warning' => 'bg-yellow-500 text-white hover:bg-yellow-600 focus:ring-yellow-500',
        'info' => 'bg-blue-500 text-white hover:bg-blue-600 focus:ring-blue-500',
        'outline-primary' => 'border border-primary-600 text-primary-600 hover:bg-primary-50 focus:ring-primary-500',
        'outline-secondary' => 'border border-gray-300 text-gray-700 hover:bg-gray-50 focus:ring-gray-500',
        'outline-danger' => 'border border-red-600 text-red-600 hover:bg-red-50 focus:ring-red-500',
        'link' => 'text-primary-600 hover:text-primary-700 hover:underline',
        'gradient' => 'gradient-bg text-white hover:opacity-90 focus:ring-primary-500',
    ];
    
    $sizeClasses = [
        'xs' => 'text-xs px-2.5 py-1.5',
        'sm' => 'text-sm px-3 py-2',
        'md' => 'text-sm px-4 py-2',
        'lg' => 'text-base px-5 py-2.5',
        'xl' => 'text-base px-6 py-3',
    ];
    
    $disabledClasses = 'opacity-50 cursor-not-allowed';
    $fullWidthClasses = 'w-full';
    
    $classes = $baseClasses . ' ' . 
               $variantClasses[$variant] . ' ' . 
               $sizeClasses[$size] . ' ' . 
               ($disabled ? $disabledClasses : '') . ' ' . 
               ($fullWidth ? $fullWidthClasses : '');
?>

<?php if($href && !$disabled): ?>
    <a href="<?php echo e($href); ?>" <?php echo e($attributes->merge(['class' => $classes])); ?>>
        <?php if($icon && $iconPosition === 'left'): ?>
            <i class="<?php echo e($icon); ?> mr-2"></i>
        <?php endif; ?>
        
        <?php echo e($slot); ?>

        
        <?php if($icon && $iconPosition === 'right'): ?>
            <i class="<?php echo e($icon); ?> ml-2"></i>
        <?php endif; ?>
    </a>
<?php else: ?>
    <button type="<?php echo e($type); ?>" <?php echo e($attributes->merge(['class' => $classes])); ?> <?php if($disabled): ?> disabled <?php endif; ?>>
        <?php if($icon && $iconPosition === 'left'): ?>
            <i class="<?php echo e($icon); ?> mr-2"></i>
        <?php endif; ?>
        
        <?php echo e($slot); ?>

        
        <?php if($icon && $iconPosition === 'right'): ?>
            <i class="<?php echo e($icon); ?> ml-2"></i>
        <?php endif; ?>
    </button>
<?php endif; ?>
<?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/presby_app/resources/views/components/button.blade.php ENDPATH**/ ?>