<?php if (isset($component)) { $__componentOriginal4619374cef299e94fd7263111d0abc69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal4619374cef299e94fd7263111d0abc69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.app-layout','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <!-- Back Navigation -->
    <div class="mb-6">
        <a href="<?php echo e(route('users.index')); ?>" class="inline-flex items-center text-gray-600 hover:text-purple-600 transition-colors duration-200">
            <i class="fas fa-arrow-left mr-2"></i>
            <span class="font-medium">Back to Users</span>
        </a>
    </div>

    <!-- Success/Error Messages -->
    <?php if(session('success')): ?>
    <div class="mb-6 bg-green-50 border-l-4 border-green-500 p-4 rounded-lg">
        <div class="flex items-center">
            <i class="fas fa-check-circle text-green-500 mr-3"></i>
            <p class="text-green-800 font-medium"><?php echo e(session('success')); ?></p>
        </div>
    </div>
    <?php endif; ?>

    <?php if(session('error')): ?>
    <div class="mb-6 bg-red-50 border-l-4 border-red-500 p-4 rounded-lg">
        <div class="flex items-center">
            <i class="fas fa-exclamation-circle text-red-500 mr-3"></i>
            <p class="text-red-800 font-medium"><?php echo e(session('error')); ?></p>
        </div>
    </div>
    <?php endif; ?>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
        <!-- Left Column - Profile Card -->
        <div class="lg:col-span-1">
            <!-- Profile Card -->
            <div class="bg-white rounded-xl shadow-lg overflow-hidden border border-gray-100">
                <!-- Header with Gradient -->
                <div class="bg-gradient-to-r from-blue-600 via-purple-600 to-red-600 p-6 text-center">
                    <?php if($user->profile_photo): ?>
                    <img src="<?php echo e(asset('storage/' . $user->profile_photo)); ?>" 
                         alt="<?php echo e($user->name); ?>" 
                         class="w-32 h-32 rounded-full mx-auto border-4 border-white shadow-xl object-cover">
                    <?php else: ?>
                    <div class="w-32 h-32 rounded-full mx-auto border-4 border-white shadow-xl bg-gradient-to-br from-purple-500 to-blue-500 flex items-center justify-center">
                        <span class="text-white text-5xl font-bold"><?php echo e(substr($user->name, 0, 1)); ?></span>
                    </div>
                    <?php endif; ?>
                    
                    <h2 class="mt-4 text-2xl font-bold text-white"><?php echo e($user->name); ?></h2>
                    <p class="text-blue-100 text-sm mt-1">
                        <i class="fas fa-envelope mr-1"></i>
                        <?php echo e($user->email); ?>

                    </p>
                    
                    <?php if($user->id === auth()->id()): ?>
                    <div class="mt-3">
                        <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-semibold bg-white text-purple-600">
                            <i class="fas fa-star mr-1"></i>
                            This is you
                        </span>
                    </div>
                    <?php endif; ?>
                </div>

                <!-- User Stats -->
                <div class="p-6 bg-gradient-to-br from-gray-50 to-white">
                    <div class="grid grid-cols-2 gap-4">
                        <div class="text-center p-4 bg-white rounded-lg shadow-sm border border-gray-100">
                            <div class="text-2xl font-bold text-blue-600">
                                <?php echo e(number_format($user->created_at->diffInDays(now()), 0)); ?>

                            </div>
                            <div class="text-xs text-gray-600 mt-1">Days Active</div>
                        </div>
                        <div class="text-center p-4 bg-white rounded-lg shadow-sm border border-gray-100">
                            <div class="text-2xl font-bold text-purple-600">
                                <?php echo e($user->updated_at->diffForHumans()); ?>

                            </div>
                            <div class="text-xs text-gray-600 mt-1">Last Updated</div>
                        </div>
                    </div>
                </div>

                <!-- Quick Actions -->
                <div class="p-6 border-t border-gray-100 space-y-3">
                    <a href="<?php echo e(route('users.edit', $user)); ?>" 
                       class="w-full flex items-center justify-center px-4 py-3 bg-gradient-to-r from-purple-600 to-blue-600 hover:from-purple-700 hover:to-blue-700 text-white rounded-lg font-medium shadow-md hover:shadow-lg transition-all duration-200">
                        <i class="fas fa-edit mr-2"></i>
                        Edit Profile
                    </a>
                    
                    <?php if(Auth::user()->role === 'admin'): ?>
                    <a href="<?php echo e(route('users.reset-password', $user)); ?>" 
                       class="w-full flex items-center justify-center px-4 py-3 bg-gradient-to-r from-blue-500 to-cyan-500 hover:from-blue-600 hover:to-cyan-600 text-white rounded-lg font-medium shadow-md hover:shadow-lg transition-all duration-200">
                        <i class="fas fa-key mr-2"></i>
                        Reset Password
                    </a>
                    <?php endif; ?>
                    
                    <?php if(Auth::user()->role === 'admin' && Auth::id() !== $user->id): ?>
                    <form action="<?php echo e(route('users.destroy', $user)); ?>" method="POST" 
                          onsubmit="return confirm('Are you sure you want to delete <?php echo e($user->name); ?>? This action cannot be undone.');">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" 
                                class="w-full flex items-center justify-center px-4 py-3 bg-gradient-to-r from-red-500 to-red-600 hover:from-red-600 hover:to-red-700 text-white rounded-lg font-medium shadow-md hover:shadow-lg transition-all duration-200">
                            <i class="fas fa-trash-alt mr-2"></i>
                            Delete User
                        </button>
                    </form>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Right Column - Details -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Account Information -->
            <div class="bg-white rounded-xl shadow-lg border border-gray-100 overflow-hidden">
                <div class="bg-gradient-to-r from-blue-50 to-purple-50 px-6 py-4 border-b border-gray-200">
                    <h3 class="text-lg font-semibold text-gray-800 flex items-center">
                        <i class="fas fa-user-circle text-purple-600 mr-2"></i>
                        Account Information
                    </h3>
                </div>
                <div class="p-6">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div class="bg-gradient-to-br from-blue-50 to-blue-100 p-4 rounded-lg border border-blue-200">
                            <div class="flex items-center mb-2">
                                <i class="fas fa-user text-blue-600 mr-2"></i>
                                <span class="text-sm font-medium text-gray-600">Full Name</span>
                            </div>
                            <p class="text-lg font-semibold text-gray-900"><?php echo e($user->name); ?></p>
                        </div>

                        <div class="bg-gradient-to-br from-purple-50 to-purple-100 p-4 rounded-lg border border-purple-200">
                            <div class="flex items-center mb-2">
                                <i class="fas fa-envelope text-purple-600 mr-2"></i>
                                <span class="text-sm font-medium text-gray-600">Email Address</span>
                            </div>
                            <p class="text-lg font-semibold text-gray-900 break-all"><?php echo e($user->email); ?></p>
                        </div>

                        <div class="bg-gradient-to-br from-green-50 to-green-100 p-4 rounded-lg border border-green-200">
                            <div class="flex items-center mb-2">
                                <i class="fas fa-calendar-plus text-green-600 mr-2"></i>
                                <span class="text-sm font-medium text-gray-600">Account Created</span>
                            </div>
                            <p class="text-lg font-semibold text-gray-900"><?php echo e($user->created_at->format('M d, Y')); ?></p>
                            <p class="text-xs text-gray-600 mt-1"><?php echo e($user->created_at->diffForHumans()); ?></p>
                        </div>

                        <div class="bg-gradient-to-br from-orange-50 to-orange-100 p-4 rounded-lg border border-orange-200">
                            <div class="flex items-center mb-2">
                                <i class="fas fa-clock text-orange-600 mr-2"></i>
                                <span class="text-sm font-medium text-gray-600">Last Updated</span>
                            </div>
                            <p class="text-lg font-semibold text-gray-900"><?php echo e($user->updated_at->format('M d, Y')); ?></p>
                            <p class="text-xs text-gray-600 mt-1"><?php echo e($user->updated_at->diffForHumans()); ?></p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Roles & Permissions -->
            <div class="bg-white rounded-xl shadow-lg border border-gray-100 overflow-hidden">
                <div class="bg-gradient-to-r from-purple-50 to-red-50 px-6 py-4 border-b border-gray-200">
                    <h3 class="text-lg font-semibold text-gray-800 flex items-center">
                        <i class="fas fa-shield-alt text-purple-600 mr-2"></i>
                        Roles & Permissions
                    </h3>
                </div>
                <div class="p-6">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Primary Role -->
                        <div class="bg-gradient-to-br from-green-50 to-emerald-50 p-6 rounded-lg border-2 border-green-200">
                            <div class="flex items-center justify-between mb-3">
                                <div class="flex items-center">
                                    <i class="fas fa-shield-alt text-green-600 text-xl mr-2"></i>
                                    <span class="text-sm font-semibold text-gray-700">Primary Role</span>
                                </div>
                                <span class="px-2 py-1 bg-green-200 text-green-800 text-xs font-bold rounded-full">NEW</span>
                            </div>
                            <?php if($user->role_id && $user->assignedRole): ?>
                            <div class="mt-3">
                                <div class="flex items-center justify-between mb-2">
                                    <span class="text-2xl font-bold text-gray-900"><?php echo e($user->assignedRole->name); ?></span>
                                    <a href="<?php echo e(route('roles.show', $user->role_id)); ?>" 
                                       class="text-green-600 hover:text-green-800 text-sm font-medium">
                                        <i class="fas fa-external-link-alt"></i>
                                    </a>
                                </div>
                                <p class="text-sm text-gray-600 mb-3"><?php echo e($user->assignedRole->description ?? 'No description'); ?></p>
                                <div class="flex items-center text-sm text-gray-700 bg-white p-2 rounded">
                                    <i class="fas fa-key text-green-600 mr-2"></i>
                                    <span class="font-medium"><?php echo e($user->assignedRole->permissions->count()); ?> permissions</span>
                                </div>
                            </div>
                            <?php else: ?>
                            <div class="mt-3 text-center py-4">
                                <i class="fas fa-exclamation-circle text-gray-400 text-3xl mb-2"></i>
                                <p class="text-gray-500 text-sm">No primary role assigned</p>
                                <?php if(Auth::user()->role === 'admin'): ?>
                                <a href="<?php echo e(route('users.edit', $user)); ?>" class="text-green-600 hover:text-green-800 text-sm font-medium mt-2 inline-block">
                                    <i class="fas fa-plus-circle mr-1"></i>
                                    Assign Role
                                </a>
                                <?php endif; ?>
                            </div>
                            <?php endif; ?>
                        </div>

                        <!-- System Access Level -->
                        <div class="bg-gradient-to-br from-blue-50 to-indigo-50 p-6 rounded-lg border-2 border-blue-200">
                            <div class="flex items-center justify-between mb-3">
                                <div class="flex items-center">
                                    <i class="fas fa-key text-blue-600 text-xl mr-2"></i>
                                    <span class="text-sm font-semibold text-gray-700">System Access Level</span>
                                </div>
                                <span class="px-2 py-1 bg-blue-200 text-blue-800 text-xs font-bold rounded-full">FALLBACK</span>
                            </div>
                            <div class="mt-3">
                                <div class="flex items-center mb-3">
                                    <?php if($user->role === 'admin'): ?>
                                    <div class="w-12 h-12 rounded-full bg-gradient-to-br from-red-500 to-red-600 flex items-center justify-center mr-3">
                                        <i class="fas fa-user-shield text-white text-xl"></i>
                                    </div>
                                    <div>
                                        <span class="text-2xl font-bold text-gray-900">Administrator</span>
                                        <p class="text-xs text-gray-600">Full system access</p>
                                    </div>
                                    <?php elseif($user->role === 'staff'): ?>
                                    <div class="w-12 h-12 rounded-full bg-gradient-to-br from-blue-500 to-blue-600 flex items-center justify-center mr-3">
                                        <i class="fas fa-user-tie text-white text-xl"></i>
                                    </div>
                                    <div>
                                        <span class="text-2xl font-bold text-gray-900">Staff Member</span>
                                        <p class="text-xs text-gray-600">Standard access</p>
                                    </div>
                                    <?php else: ?>
                                    <div class="w-12 h-12 rounded-full bg-gradient-to-br from-purple-500 to-purple-600 flex items-center justify-center mr-3">
                                        <i class="fas fa-user text-white text-xl"></i>
                                    </div>
                                    <div>
                                        <span class="text-2xl font-bold text-gray-900">Member</span>
                                        <p class="text-xs text-gray-600">Limited access</p>
                                    </div>
                                    <?php endif; ?>
                                </div>
                                <div class="bg-white p-3 rounded text-xs text-gray-600">
                                    <i class="fas fa-info-circle text-blue-600 mr-1"></i>
                                    Used when no primary role is assigned
                                </div>
                            </div>
                        </div>
                    </div>

                    <?php if($user->role_id && $user->assignedRole): ?>
                    <!-- Permissions Preview -->
                    <div class="mt-6 p-4 bg-gradient-to-r from-purple-50 to-blue-50 rounded-lg border border-purple-200">
                        <h4 class="font-semibold text-gray-800 mb-3 flex items-center">
                            <i class="fas fa-list-check text-purple-600 mr-2"></i>
                            Assigned Permissions
                        </h4>
                        <div class="grid grid-cols-2 md:grid-cols-3 gap-2">
                            <?php $__currentLoopData = $user->assignedRole->permissions->take(6); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="bg-white px-3 py-2 rounded text-xs font-medium text-gray-700 border border-gray-200">
                                <i class="fas fa-check text-green-600 mr-1"></i>
                                <?php echo e($permission->name); ?>

                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <?php if($user->assignedRole->permissions->count() > 6): ?>
                        <a href="<?php echo e(route('roles.show', $user->role_id)); ?>" class="mt-3 inline-flex items-center text-sm text-purple-600 hover:text-purple-800 font-medium">
                            View all <?php echo e($user->assignedRole->permissions->count()); ?> permissions
                            <i class="fas fa-arrow-right ml-1"></i>
                        </a>
                        <?php endif; ?>
                    </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Activity Timeline -->
            <div class="bg-white rounded-xl shadow-lg border border-gray-100 overflow-hidden">
                <div class="bg-gradient-to-r from-cyan-50 to-blue-50 px-6 py-4 border-b border-gray-200">
                    <h3 class="text-lg font-semibold text-gray-800 flex items-center">
                        <i class="fas fa-history text-cyan-600 mr-2"></i>
                        Activity Timeline
                    </h3>
                </div>
                <div class="p-6">
                    <div class="space-y-4">
                        <div class="flex items-start">
                            <div class="flex-shrink-0">
                                <div class="w-10 h-10 rounded-full bg-gradient-to-br from-green-500 to-green-600 flex items-center justify-center">
                                    <i class="fas fa-user-plus text-white"></i>
                                </div>
                            </div>
                            <div class="ml-4 flex-1">
                                <p class="text-sm font-medium text-gray-900">Account Created</p>
                                <p class="text-xs text-gray-600"><?php echo e($user->created_at->format('F j, Y \a\t g:i A')); ?></p>
                                <p class="text-xs text-gray-500 mt-1"><?php echo e($user->created_at->diffForHumans()); ?></p>
                            </div>
                        </div>

                        <div class="flex items-start">
                            <div class="flex-shrink-0">
                                <div class="w-10 h-10 rounded-full bg-gradient-to-br from-blue-500 to-blue-600 flex items-center justify-center">
                                    <i class="fas fa-edit text-white"></i>
                                </div>
                            </div>
                            <div class="ml-4 flex-1">
                                <p class="text-sm font-medium text-gray-900">Last Profile Update</p>
                                <p class="text-xs text-gray-600"><?php echo e($user->updated_at->format('F j, Y \a\t g:i A')); ?></p>
                                <p class="text-xs text-gray-500 mt-1"><?php echo e($user->updated_at->diffForHumans()); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal4619374cef299e94fd7263111d0abc69)): ?>
<?php $attributes = $__attributesOriginal4619374cef299e94fd7263111d0abc69; ?>
<?php unset($__attributesOriginal4619374cef299e94fd7263111d0abc69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4619374cef299e94fd7263111d0abc69)): ?>
<?php $component = $__componentOriginal4619374cef299e94fd7263111d0abc69; ?>
<?php unset($__componentOriginal4619374cef299e94fd7263111d0abc69); ?>
<?php endif; ?>
<?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/presby_app/resources/views/users/show.blade.php ENDPATH**/ ?>