<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Attendance Report - <?php echo e($event->title); ?></title>
    <style>
        body { 
            font-family: Arial, sans-serif; 
            margin: 20px;
            color: #333;
        }
        .header { 
            text-align: center; 
            margin-bottom: 30px; 
            border-bottom: 3px solid #16a34a; 
            padding-bottom: 15px; 
        }
        .header h1 {
            color: #16a34a;
            margin: 0;
            font-size: 28px;
        }
        .header h2 {
            color: #555;
            margin: 10px 0 0 0;
            font-size: 20px;
        }
        .event-info { 
            margin: 20px 0; 
            background: #f0fdf4; 
            padding: 15px; 
            border-radius: 8px;
            border-left: 4px solid #16a34a;
        }
        .event-info p {
            margin: 5px 0;
            font-size: 14px;
        }
        table { 
            width: 100%; 
            border-collapse: collapse; 
            margin: 20px 0;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        }
        th, td { 
            padding: 12px; 
            text-align: left; 
            border: 1px solid #e5e7eb; 
        }
        th { 
            background: #16a34a; 
            color: white;
            font-weight: 600;
            text-transform: uppercase;
            font-size: 12px;
            letter-spacing: 0.5px;
        }
        tr:nth-child(even) { 
            background: #f9fafb; 
        }
        tr:hover {
            background: #f0fdf4;
        }
        .stats { 
            display: flex; 
            justify-content: space-around; 
            margin: 20px 0;
            gap: 15px;
        }
        .stat-box { 
            flex: 1;
            text-align: center; 
            padding: 20px; 
            background: linear-gradient(135deg, #16a34a 0%, #15803d 100%);
            border-radius: 8px;
            color: white;
            box-shadow: 0 4px 6px rgba(22, 163, 74, 0.2);
        }
        .stat-box h3 {
            margin: 0;
            font-size: 32px;
            font-weight: bold;
        }
        .stat-box p {
            margin: 5px 0 0 0;
            font-size: 14px;
            opacity: 0.9;
        }
        .method-badge {
            display: inline-block;
            padding: 4px 10px;
            border-radius: 12px;
            font-size: 11px;
            font-weight: 600;
        }
        .method-qr {
            background: #dbeafe;
            color: #1e40af;
        }
        .method-manual {
            background: #fef3c7;
            color: #92400e;
        }
        .footer {
            margin-top: 40px;
            padding-top: 20px;
            border-top: 2px solid #e5e7eb;
            text-align: center;
            color: #666;
            font-size: 12px;
        }
        .print-button {
            position: fixed;
            top: 20px;
            right: 20px;
            padding: 12px 24px;
            background: #16a34a;
            color: white;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 14px;
            font-weight: 600;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
            transition: all 0.2s;
        }
        .print-button:hover {
            background: #15803d;
            transform: translateY(-2px);
            box-shadow: 0 6px 8px rgba(0,0,0,0.15);
        }
        @media print {
            .no-print { 
                display: none !important; 
            }
            .print-button {
                display: none;
            }
            body {
                margin: 0;
            }
        }
    </style>
</head>
<body>
    <button onclick="window.print()" class="print-button no-print">
        <i class="fas fa-print"></i> Print Report
    </button>
    
    <div class="header">
        <h1>✓ Attendance Report</h1>
        <h2><?php echo e($event->title); ?></h2>
    </div>
    
    <div class="event-info">
        <p><strong>📅 Date:</strong> <?php echo e($event->start_datetime->format('l, F d, Y')); ?></p>
        <p><strong>🕐 Time:</strong> <?php echo e($event->start_datetime->format('h:i A')); ?>

            <?php if($event->end_datetime): ?>
                - <?php echo e($event->end_datetime->format('h:i A')); ?>

            <?php endif; ?>
        </p>
        <p><strong>📍 Location:</strong> <?php echo e($event->location ?? 'Church Premises'); ?></p>
    </div>
    
    <div class="stats">
        <div class="stat-box">
            <h3><?php echo e($attendances->count()); ?></h3>
            <p>Members Present</p>
        </div>
        <div class="stat-box">
            <h3><?php echo e($attendances->where('attendance_method', 'qr_code')->count()); ?></h3>
            <p>QR Check-ins</p>
        </div>
        <div class="stat-box">
            <h3><?php echo e($attendances->where('attendance_method', 'manual')->count()); ?></h3>
            <p>Manual Entries</p>
        </div>
    </div>
    
    <h3 style="margin: 30px 0 15px 0; color: #16a34a; font-size: 18px;">
        Present Members (<?php echo e($attendances->count()); ?> attended)
    </h3>
    
    <?php if($attendances->count() > 0): ?>
    <table>
        <thead>
            <tr>
                <th style="width: 5%;">#</th>
                <th style="width: 12%;">Member ID</th>
                <th style="width: 25%;">Name</th>
                <th style="width: 15%;">Phone</th>
                <th style="width: 13%;">Check In</th>
                <th style="width: 13%;">Check Out</th>
                <th style="width: 10%;">Method</th>
                <th style="width: 7%;">Duration</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $attendances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $attendance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($index + 1); ?></td>
                <td><?php echo e($attendance->member->member_id); ?></td>
                <td><strong><?php echo e($attendance->member->full_name); ?></strong></td>
                <td><?php echo e($attendance->member->phone ?? 'N/A'); ?></td>
                <td><?php echo e($attendance->checked_in_at->format('h:i A')); ?></td>
                <td>
                    <?php if($attendance->checked_out_at): ?>
                        <?php echo e($attendance->checked_out_at->format('h:i A')); ?>

                    <?php else: ?>
                        <span style="color: #16a34a; font-weight: 600;">Active</span>
                    <?php endif; ?>
                </td>
                <td>
                    <span class="method-badge method-<?php echo e($attendance->attendance_method === 'qr_code' ? 'qr' : 'manual'); ?>">
                        <?php if($attendance->attendance_method === 'qr_code'): ?>
                            📱 QR Code
                        <?php else: ?>
                            ✏️ Manual
                        <?php endif; ?>
                    </span>
                </td>
                <td>
                    <?php if($attendance->checked_out_at): ?>
                        <?php echo e($attendance->checked_in_at->diffInMinutes($attendance->checked_out_at)); ?>m
                    <?php else: ?>
                        -
                    <?php endif; ?>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
    <?php else: ?>
    <p style="text-align: center; color: #dc2626; font-size: 20px; padding: 40px;">
        ⚠️ No attendance records found for this event.
    </p>
    <?php endif; ?>
    
    <div class="footer">
        <p><strong><?php echo e(\App\Models\Setting::getValue('organization_name', 'general', 'Presbyterian Church of Ghana')); ?></strong></p>
        <p>Generated on <?php echo e(now()->format('F d, Y \a\t h:i A')); ?></p>
        <p style="margin-top: 10px; font-size: 11px;">This is an official attendance record. Handle with confidentiality.</p>
    </div>
</body>
</html>
<?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/presby_app/resources/views/attendance/print-attendance.blade.php ENDPATH**/ ?>