<x-app-layout>
<div class="space-y-6">
    <!-- Hero Header -->
    <div class="relative overflow-hidden rounded-3xl shadow-2xl" 
         style="background: linear-gradient(135deg, {{ $yearGroup->color ?? '#3b82f6' }} 0%, {{ $yearGroup->color ?? '#3b82f6' }}dd 50%, {{ $yearGroup->color ?? '#3b82f6' }}bb 100%);">
        <div class="absolute inset-0 bg-black/10"></div>
        <div class="absolute inset-0" style="background-image: radial-gradient(circle at 20% 50%, rgba(255, 255, 255, 0.15) 0%, transparent 50%),
            radial-gradient(circle at 80% 80%, rgba(255, 255, 255, 0.15) 0%, transparent 50%);"></div>
        <div class="relative p-8 md:p-12">
            <div class="flex flex-col lg:flex-row items-start lg:items-center justify-between gap-6">
                <div class="flex items-start space-x-4">
                    <a href="{{ route('age-groups.index') }}" 
                       class="w-12 h-12 bg-white/20 backdrop-blur-sm hover:bg-white/30 rounded-xl flex items-center justify-center transition-all border border-white/30 shadow-lg">
                        <i class="fas fa-arrow-left text-white text-lg"></i>
                    </a>
                    <div class="w-16 h-16 bg-white/20 backdrop-blur-sm rounded-2xl flex items-center justify-center border-2 border-white/30 shadow-lg">
                        <i class="fas fa-users text-white text-2xl"></i>
                    </div>
                    <div>
                        <h1 class="text-4xl md:text-5xl font-bold text-white mb-2">
                            {{ $yearGroup->name }}
                        </h1>
                        <div class="flex flex-wrap items-center gap-4 text-white/90">
                            <div class="flex items-center">
                                <i class="fas fa-birthday-cake mr-2"></i>
                                <span class="text-lg">Ages {{ $yearGroup->min_age }}-{{ $yearGroup->max_age }}</span>
                            </div>
                            <span class="text-white/50">•</span>
                            <div class="flex items-center">
                                <i class="fas fa-user-friends mr-2"></i>
                                <span class="text-lg font-semibold">{{ $members->total() }} members</span>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="flex items-center gap-3">
                    <form action="{{ route('age-groups.print', $yearGroup) }}" method="GET" class="inline">
                        @if(request('gender'))
                            <input type="hidden" name="gender" value="{{ request('gender') }}">
                        @endif
                        @if(request('membership_type'))
                            <input type="hidden" name="membership_type" value="{{ request('membership_type') }}">
                        @endif
                        @if(request('search'))
                            <input type="hidden" name="search" value="{{ request('search') }}">
                        @endif
                        <button type="submit" class="px-6 py-3 bg-white/20 backdrop-blur-sm hover:bg-white/30 text-white rounded-xl transition-all duration-200 border border-white/30 shadow-lg hover:shadow-xl flex items-center">
                            <i class="fas fa-print mr-2"></i>
                            <span class="font-medium">Print PDF</span>
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters Section -->
    <div class="bg-white rounded-2xl shadow-lg border border-gray-100 overflow-hidden">
        <div class="bg-gradient-to-r from-gray-50 to-gray-100 px-6 py-4 border-b border-gray-200">
            <div class="flex items-center justify-between">
                <div class="flex items-center">
                    <div class="w-10 h-10 bg-gradient-to-br from-blue-500 to-blue-600 rounded-xl flex items-center justify-center mr-3">
                        <i class="fas fa-filter text-white"></i>
                    </div>
                    <h3 class="text-lg font-bold text-gray-900">Search & Filter Members</h3>
                </div>
                @if(request()->hasAny(['gender', 'membership_type', 'search']))
                    <a href="{{ route('age-groups.show', $yearGroup) }}" 
                       class="px-4 py-2 bg-red-50 hover:bg-red-100 text-red-600 rounded-lg transition-colors text-sm font-medium">
                        <i class="fas fa-times-circle mr-1"></i>
                        Clear All
                    </a>
                @endif
            </div>
        </div>

        <form action="{{ route('age-groups.show', $yearGroup) }}" method="GET" class="p-6">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-4">
                <!-- Search -->
                <div class="md:col-span-2">
                    <label class="block text-sm font-semibold text-gray-700 mb-2">
                        <i class="fas fa-search text-gray-400 mr-1"></i>
                        Search Members
                    </label>
                    <div class="relative">
                        <input type="text" 
                               name="search" 
                               value="{{ request('search') }}" 
                               placeholder="Search by name, ID, or phone..." 
                               class="w-full pl-11 pr-4 py-3 border-2 border-gray-200 rounded-xl focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all">
                        <i class="fas fa-search absolute left-4 top-1/2 transform -translate-y-1/2 text-gray-400"></i>
                    </div>
                </div>

                <!-- Gender Filter -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">
                        <i class="fas fa-venus-mars text-gray-400 mr-1"></i>
                        Gender
                    </label>
                    <select name="gender" class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all">
                        <option value="">All Genders</option>
                        <option value="male" {{ request('gender') == 'male' ? 'selected' : '' }}>👨 Male</option>
                        <option value="female" {{ request('gender') == 'female' ? 'selected' : '' }}>👩 Female</option>
                    </select>
                </div>

                <!-- Membership Type Filter -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">
                        <i class="fas fa-id-card text-gray-400 mr-1"></i>
                        Membership Type
                    </label>
                    <select name="membership_type" class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all">
                        <option value="">All Types</option>
                        <option value="communicant" {{ request('membership_type') == 'communicant' ? 'selected' : '' }}>Communicant</option>
                        <option value="baptized" {{ request('membership_type') == 'baptized' ? 'selected' : '' }}>Baptized</option>
                        <option value="confirmed" {{ request('membership_type') == 'confirmed' ? 'selected' : '' }}>Confirmed</option>
                        <option value="adherent" {{ request('membership_type') == 'adherent' ? 'selected' : '' }}>Adherent</option>
                        <option value="catechumen" {{ request('membership_type') == 'catechumen' ? 'selected' : '' }}>Catechumen</option>
                    </select>
                </div>
            </div>

            <button type="submit" class="px-8 py-3 bg-gradient-to-r from-blue-600 to-blue-700 hover:from-blue-700 hover:to-blue-800 text-white rounded-xl transition-all shadow-lg hover:shadow-xl font-medium">
                <i class="fas fa-filter mr-2"></i>
                Apply Filters
            </button>
        </form>
    </div>

    <!-- Members List -->
    <div class="bg-white rounded-2xl shadow-lg overflow-hidden border border-gray-100">
        <div class="bg-gradient-to-r from-blue-600 via-blue-700 to-cyan-600 p-6">
            <div class="flex items-center justify-between">
                <div class="flex items-center space-x-4">
                    <div class="w-12 h-12 bg-white/20 backdrop-blur-sm rounded-xl flex items-center justify-center border border-white/30">
                        <i class="fas fa-users text-white text-xl"></i>
                    </div>
                    <div>
                        <h2 class="text-2xl font-bold text-white">Members Directory</h2>
                        <p class="text-blue-100 mt-1 flex items-center">
                            <span class="inline-flex items-center px-3 py-1 bg-white/20 rounded-lg mr-2 font-medium">
                                {{ $members->count() }} of {{ $members->total() }}
                            </span>
                            <span>members displayed</span>
                        </p>
                    </div>
                </div>
            </div>
        </div>

        @if($members->isEmpty())
            <div class="p-12 text-center">
                <div class="w-20 h-20 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-user-slash text-gray-400 text-3xl"></i>
                </div>
                <h3 class="text-xl font-semibold text-gray-600 mb-2">No Members Found</h3>
                <p class="text-gray-500">
                    @if(request()->hasAny(['gender', 'membership_type', 'search']))
                        Try adjusting your filters or <a href="{{ route('age-groups.show', $yearGroup) }}" class="text-blue-600 hover:underline">clear all filters</a>.
                    @else
                        No active members in this age group yet.
                    @endif
                </p>
            </div>
        @else
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-gray-50 border-b border-gray-200">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Member</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Contact</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Age</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Gender</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Type</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200">
                        @foreach($members as $member)
                        <tr class="hover:bg-blue-50 transition-all duration-200 group">
                            <td class="px-6 py-4">
                                <div class="flex items-center">
                                    <div class="w-12 h-12 bg-gradient-to-br from-blue-500 to-cyan-600 rounded-xl flex items-center justify-center text-white font-bold shadow-md group-hover:scale-110 transition-transform">
                                        {{ strtoupper(substr($member->first_name, 0, 1)) }}{{ strtoupper(substr($member->last_name, 0, 1)) }}
                                    </div>
                                    <div class="ml-4">
                                        <div class="text-sm font-bold text-gray-900 group-hover:text-blue-600 transition-colors">{{ $member->full_name }}</div>
                                        <div class="text-xs text-gray-500 font-mono">{{ $member->member_id }}</div>
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4">
                                <div class="flex items-center text-sm text-gray-700">
                                    <i class="fas fa-phone text-blue-500 mr-2 text-xs"></i>
                                    {{ $member->phone }}
                                </div>
                                @if($member->email)
                                <div class="flex items-center text-xs text-gray-500 mt-1">
                                    <i class="fas fa-envelope text-gray-400 mr-2"></i>
                                    {{ $member->email }}
                                </div>
                                @endif
                            </td>
                            <td class="px-6 py-4">
                                <div class="flex items-center">
                                    @if($member->date_of_birth)
                                        <div class="px-3 py-1 bg-purple-50 border border-purple-200 rounded-lg">
                                            <span class="text-sm font-bold text-purple-700">{{ \Carbon\Carbon::parse($member->date_of_birth)->age }}</span>
                                            <span class="text-xs text-purple-600 ml-1">yrs</span>
                                        </div>
                                    @else
                                        <span class="text-gray-400 text-sm">N/A</span>
                                    @endif
                                </div>
                            </td>
                            <td class="px-6 py-4">
                                <span class="inline-flex items-center px-3 py-1 text-xs font-semibold rounded-lg {{ $member->gender == 'male' ? 'bg-blue-100 text-blue-700 border border-blue-200' : 'bg-pink-100 text-pink-700 border border-pink-200' }}">
                                    @if($member->gender == 'male')
                                        <i class="fas fa-mars mr-1"></i>
                                    @else
                                        <i class="fas fa-venus mr-1"></i>
                                    @endif
                                    {{ ucfirst($member->gender) }}
                                </span>
                            </td>
                            <td class="px-6 py-4">
                                <span class="inline-flex items-center px-3 py-1 text-xs font-medium rounded-lg bg-gray-100 text-gray-700 border border-gray-200">
                                    <i class="fas fa-id-badge mr-1 text-gray-500"></i>
                                    {{ ucfirst(str_replace('_', ' ', $member->membership_type ?? 'N/A')) }}
                                </span>
                            </td>
                            <td class="px-6 py-4">
                                <div class="flex items-center space-x-2">
                                    <a href="{{ route('members.show', $member) }}" 
                                       class="w-8 h-8 bg-blue-100 hover:bg-blue-600 text-blue-600 hover:text-white rounded-lg flex items-center justify-center transition-all transform hover:scale-110" 
                                       title="View Details">
                                        <i class="fas fa-eye text-xs"></i>
                                    </a>
                                    <a href="{{ route('members.edit', $member) }}" 
                                       class="w-8 h-8 bg-green-100 hover:bg-green-600 text-green-600 hover:text-white rounded-lg flex items-center justify-center transition-all transform hover:scale-110" 
                                       title="Edit Member">
                                        <i class="fas fa-edit text-xs"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="px-6 py-4 border-t border-gray-200">
                {{ $members->withQueryString()->links() }}
            </div>
        @endif
    </div>
</div>
</x-app-layout>
