<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>{{ $yearGroup->name }} - Members List</title>
    <style>
        @page {
            margin: 1cm;
        }
        
        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 10pt;
            color: #333;
            line-height: 1.4;
        }
        
        .header {
            text-align: center;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 2px solid #2563eb;
        }
        
        .header h1 {
            color: #2563eb;
            margin: 0;
            font-size: 20pt;
            font-weight: bold;
        }
        
        .header .subtitle {
            color: #666;
            margin: 5px 0;
            font-size: 11pt;
        }
        
        .header .date {
            color: #999;
            font-size: 9pt;
            margin-top: 5px;
        }
        
        .info-box {
            background: #f3f4f6;
            padding: 10px;
            margin-bottom: 15px;
            border-radius: 5px;
            border-left: 4px solid #2563eb;
        }
        
        .info-box table {
            width: 100%;
        }
        
        .info-box td {
            padding: 3px 5px;
        }
        
        .info-box td:first-child {
            font-weight: bold;
            color: #666;
            width: 120px;
        }
        
        table.members {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }
        
        table.members thead {
            background: #2563eb;
            color: white;
        }
        
        table.members th {
            padding: 8px 6px;
            text-align: left;
            font-weight: bold;
            font-size: 9pt;
        }
        
        table.members tbody tr {
            border-bottom: 1px solid #e5e7eb;
        }
        
        table.members tbody tr:nth-child(even) {
            background: #f9fafb;
        }
        
        table.members td {
            padding: 6px 6px;
            font-size: 9pt;
        }
        
        .gender-badge {
            display: inline-block;
            padding: 2px 8px;
            border-radius: 12px;
            font-size: 8pt;
            font-weight: 600;
        }
        
        .gender-male {
            background: #dbeafe;
            color: #1e40af;
        }
        
        .gender-female {
            background: #fce7f3;
            color: #9f1239;
        }
        
        .footer {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            text-align: center;
            font-size: 8pt;
            color: #999;
            padding: 10px 0;
            border-top: 1px solid #e5e7eb;
        }
        
        .page-number:after {
            content: counter(page);
        }
        
        .summary-box {
            background: #f0f9ff;
            border: 1px solid #bae6fd;
            padding: 10px;
            margin-bottom: 15px;
            border-radius: 5px;
        }
        
        .summary-box h3 {
            margin: 0 0 8px 0;
            color: #0369a1;
            font-size: 11pt;
        }
        
        .summary-stats {
            display: table;
            width: 100%;
        }
        
        .summary-stat {
            display: table-cell;
            text-align: center;
            padding: 5px;
        }
        
        .summary-stat .label {
            font-size: 8pt;
            color: #666;
            margin-bottom: 2px;
        }
        
        .summary-stat .value {
            font-size: 14pt;
            font-weight: bold;
            color: #2563eb;
        }
    </style>
</head>
<body>
    <!-- Header -->
    <div class="header">
        <h1>{{ \App\Models\Setting::getValue('organization_name', 'general', 'Presbyterian Church of Ghana') }}</h1>
        <div class="subtitle">{{ $yearGroup->name }} - Members Directory</div>
        <div class="date">Generated on {{ now()->format('F j, Y \a\t g:i A') }}</div>
    </div>

    <!-- Age Group Info -->
    <div class="info-box">
        <table>
            <tr>
                <td>Age Group:</td>
                <td>{{ $yearGroup->name }} ({{ $yearGroup->abbreviation }})</td>
            </tr>
            <tr>
                <td>Age Range:</td>
                <td>{{ $yearGroup->min_age }} - {{ $yearGroup->max_age }} years</td>
            </tr>
            @if($yearGroup->description)
            <tr>
                <td>Description:</td>
                <td>{{ $yearGroup->description }}</td>
            </tr>
            @endif
        </table>
    </div>

    <!-- Summary Statistics -->
    <div class="summary-box">
        <h3>Summary Statistics</h3>
        <div class="summary-stats">
            <div class="summary-stat">
                <div class="label">Total Members</div>
                <div class="value">{{ $members->count() }}</div>
            </div>
            <div class="summary-stat">
                <div class="label">Male</div>
                <div class="value">{{ $members->where('gender', 'male')->count() }}</div>
            </div>
            <div class="summary-stat">
                <div class="label">Female</div>
                <div class="value">{{ $members->where('gender', 'female')->count() }}</div>
            </div>
            <div class="summary-stat">
                <div class="label">Communicants</div>
                <div class="value">{{ $members->where('membership_type', 'communicant')->count() }}</div>
            </div>
        </div>
    </div>

    <!-- Members Table -->
    <table class="members">
        <thead>
            <tr>
                <th style="width: 5%;">#</th>
                <th style="width: 12%;">Member ID</th>
                <th style="width: 25%;">Full Name</th>
                <th style="width: 8%;">Age</th>
                <th style="width: 10%;">Gender</th>
                <th style="width: 15%;">Phone</th>
                <th style="width: 15%;">Membership Type</th>
                <th style="width: 10%;">Date Joined</th>
            </tr>
        </thead>
        <tbody>
            @forelse($members as $index => $member)
            <tr>
                <td>{{ $index + 1 }}</td>
                <td>{{ $member->member_id }}</td>
                <td>{{ $member->full_name }}</td>
                <td>
                    @if($member->date_of_birth)
                        {{ \Carbon\Carbon::parse($member->date_of_birth)->age }}
                    @else
                        N/A
                    @endif
                </td>
                <td>
                    <span class="gender-badge gender-{{ $member->gender }}">
                        {{ ucfirst($member->gender) }}
                    </span>
                </td>
                <td>{{ $member->phone }}</td>
                <td>{{ ucfirst(str_replace('_', ' ', $member->membership_type ?? 'N/A')) }}</td>
                <td>{{ $member->membership_date ? \Carbon\Carbon::parse($member->membership_date)->format('M d, Y') : 'N/A' }}</td>
            </tr>
            @empty
            <tr>
                <td colspan="8" style="text-align: center; padding: 20px; color: #999;">
                    No members found in this age group
                </td>
            </tr>
            @endforelse
        </tbody>
    </table>

    <!-- Footer -->
    <div class="footer">
        <div>{{ \App\Models\Setting::getValue('organization_name', 'general', 'Presbyterian Church of Ghana') }} - Age Group Directory</div>
        <div>Page <span class="page-number"></span> - Confidential Document</div>
    </div>
</body>
</html>
