@extends('components.app-layout')

@section('title', 'Staff Dashboard')

@section('content')
<div class="min-h-screen bg-gradient-to-br from-slate-50 via-blue-50 to-indigo-50">
    <!-- Enhanced Header Section -->
    <div class="relative overflow-hidden">
        <!-- Background Pattern -->
        <div class="absolute inset-0 bg-gradient-to-r from-blue-600 via-red-600 to-blue-700 opacity-90"></div>
        <div class="absolute inset-0" style="background-image: url('data:image/svg+xml,%3Csvg width="60" height="60" viewBox="0 0 60 60" xmlns="http://www.w3.org/2000/svg"%3E%3Cg fill="none" fill-rule="evenodd"%3E%3Cg fill="%23ffffff" fill-opacity="0.1"%3E%3Ccircle cx="30" cy="30" r="2"/%3E%3C/g%3E%3C/g%3E%3C/svg%3E');"></div>
        
        <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="py-12">
                <div class="flex items-center justify-between">
                    <div class="flex items-center space-x-6">
                        <!-- Enhanced User Avatar -->
                        <div class="relative">
                            @if(auth()->user()->profile_photo)
                                <img class="h-16 w-16 rounded-full ring-4 ring-white shadow-lg object-cover" src="{{ asset('storage/' . auth()->user()->profile_photo) }}" alt="{{ auth()->user()->name }}">
                            @else
                                <div class="h-16 w-16 rounded-full bg-white bg-opacity-20 backdrop-blur-sm ring-4 ring-white shadow-lg flex items-center justify-center">
                                    <span class="text-white font-bold text-xl">{{ substr(auth()->user()->name, 0, 1) }}</span>
                                </div>
                            @endif
                            <div class="absolute -bottom-1 -right-1 h-6 w-6 bg-green-400 rounded-full ring-2 ring-white flex items-center justify-center">
                                <i class="fas fa-check text-white text-xs"></i>
                            </div>
                        </div>
                        
                        <div>
                            <h1 class="text-4xl font-bold text-white mb-2">Welcome back, {{ auth()->user()->name }}!</h1>
                            <p class="text-blue-100 text-lg">{{ $roleInfo['name'] }} Dashboard</p>
                            <div class="flex items-center mt-3 space-x-4 text-blue-100">
                                <div class="flex items-center">
                                    <i class="fas fa-calendar-alt mr-2"></i>
                                    <span class="text-sm">{{ now()->format('l, F j, Y') }}</span>
                                </div>
                                <div class="flex items-center">
                                    <i class="fas fa-clock mr-2"></i>
                                    <span class="text-sm">{{ now()->format('g:i A') }}</span>
                                </div>
                                @if($roleInfo['permissions_count'] > 0)
                                <div class="flex items-center">
                                    <i class="fas fa-shield-alt mr-2"></i>
                                    <span class="text-sm">{{ $roleInfo['permissions_count'] }} Permissions</span>
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>
                    
                    <!-- Quick Actions -->
                    <div class="hidden lg:flex items-center space-x-3">
                        <a href="{{ route('profile.edit') }}" class="bg-white bg-opacity-20 backdrop-blur-sm text-white px-4 py-2 rounded-lg hover:bg-opacity-30 transition-all duration-200 flex items-center">
                            <i class="fas fa-user-edit mr-2"></i>
                            Edit Profile
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <!-- Permission-Based Statistics Cards -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
            
            @if(isset($stats['members']))
            <!-- Total Members Card -->
            <div class="group bg-gradient-to-br from-blue-50 to-blue-100 rounded-2xl shadow-lg hover:shadow-xl transition-all duration-300 p-6 border border-blue-200 hover:border-blue-300 transform hover:-translate-y-1">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm font-semibold text-blue-700 uppercase tracking-wide mb-2">Total Members</p>
                        <p class="text-3xl font-bold text-blue-900">{{ number_format($stats['members']['total_members']) }}</p>
                        <p class="text-xs text-blue-600 mt-2">
                            <i class="fas fa-check-circle mr-1"></i>{{ number_format($stats['members']['active_members']) }} Active
                        </p>
                    </div>
                    <div class="p-4 rounded-2xl bg-gradient-to-br from-blue-500 to-blue-600 text-white shadow-lg">
                        <i class="fas fa-users text-2xl"></i>
                    </div>
                </div>
            </div>
            @endif

            @if(isset($stats['events']))
            <!-- Events Card -->
            <div class="group bg-gradient-to-br from-orange-50 to-orange-100 rounded-2xl shadow-lg hover:shadow-xl transition-all duration-300 p-6 border border-orange-200 hover:border-orange-300 transform hover:-translate-y-1">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm font-semibold text-orange-700 uppercase tracking-wide mb-2">Upcoming Events</p>
                        <p class="text-3xl font-bold text-orange-900">{{ number_format($stats['events']['upcoming_events']) }}</p>
                        <p class="text-xs text-orange-600 mt-2">
                            <i class="fas fa-calendar mr-1"></i>{{ number_format($stats['events']['this_month']) }} This Month
                        </p>
                    </div>
                    <div class="p-4 rounded-2xl bg-gradient-to-br from-orange-500 to-orange-600 text-white shadow-lg">
                        <i class="fas fa-calendar-alt text-2xl"></i>
                    </div>
                </div>
            </div>
            @endif

            @if(isset($stats['payments']))
            <!-- Payments Card -->
            <div class="group bg-gradient-to-br from-green-50 to-green-100 rounded-2xl shadow-lg hover:shadow-xl transition-all duration-300 p-6 border border-green-200 hover:border-green-300 transform hover:-translate-y-1">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm font-semibold text-green-700 uppercase tracking-wide mb-2">This Month</p>
                        <p class="text-3xl font-bold text-green-900">₵{{ number_format($stats['payments']['this_month_amount'], 2) }}</p>
                        <p class="text-xs text-green-600 mt-2">
                            <i class="fas fa-receipt mr-1"></i>{{ number_format($stats['payments']['total_payments']) }} Payments
                        </p>
                    </div>
                    <div class="p-4 rounded-2xl bg-gradient-to-br from-green-500 to-green-600 text-white shadow-lg">
                        <i class="fas fa-hand-holding-usd text-2xl"></i>
                    </div>
                </div>
            </div>
            @endif

            @if(isset($stats['attendance']))
            <!-- Attendance Card -->
            <div class="group bg-gradient-to-br from-cyan-50 to-cyan-100 rounded-2xl shadow-lg hover:shadow-xl transition-all duration-300 p-6 border border-cyan-200 hover:border-cyan-300 transform hover:-translate-y-1">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm font-semibold text-cyan-700 uppercase tracking-wide mb-2">Attendance</p>
                        <p class="text-3xl font-bold text-cyan-900">{{ number_format($stats['attendance']['this_month']) }}</p>
                        <p class="text-xs text-cyan-600 mt-2">
                            <i class="fas fa-clipboard-check mr-1"></i>This Month
                        </p>
                    </div>
                    <div class="p-4 rounded-2xl bg-gradient-to-br from-cyan-500 to-cyan-600 text-white shadow-lg">
                        <i class="fas fa-clipboard-check text-2xl"></i>
                    </div>
                </div>
            </div>
            @endif

            @if(isset($stats['ministries']))
            <!-- Ministries Card -->
            <div class="group bg-gradient-to-br from-pink-50 to-pink-100 rounded-2xl shadow-lg hover:shadow-xl transition-all duration-300 p-6 border border-pink-200 hover:border-pink-300 transform hover:-translate-y-1">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm font-semibold text-pink-700 uppercase tracking-wide mb-2">Ministries</p>
                        <p class="text-3xl font-bold text-pink-900">{{ number_format($stats['ministries']['total_ministries']) }}</p>
                        <p class="text-xs text-pink-600 mt-2">
                            <i class="fas fa-users mr-1"></i>{{ number_format($stats['ministries']['total_members']) }} Members
                        </p>
                    </div>
                    <div class="p-4 rounded-2xl bg-gradient-to-br from-pink-500 to-pink-600 text-white shadow-lg">
                        <i class="fas fa-hands-praying text-2xl"></i>
                    </div>
                </div>
            </div>
            @endif

            @if(isset($stats['messages']))
            <!-- Messages Card -->
            <div class="group bg-gradient-to-br from-yellow-50 to-yellow-100 rounded-2xl shadow-lg hover:shadow-xl transition-all duration-300 p-6 border border-yellow-200 hover:border-yellow-300 transform hover:-translate-y-1">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm font-semibold text-yellow-700 uppercase tracking-wide mb-2">SMS Messages</p>
                        <p class="text-3xl font-bold text-yellow-900">{{ number_format($stats['messages']['total_sent']) }}</p>
                        <p class="text-xs text-yellow-600 mt-2">
                            <i class="fas fa-clock mr-1"></i>{{ number_format($stats['messages']['pending']) }} Pending
                        </p>
                    </div>
                    <div class="p-4 rounded-2xl bg-gradient-to-br from-yellow-500 to-yellow-600 text-white shadow-lg">
                        <i class="fas fa-sms text-2xl"></i>
                    </div>
                </div>
            </div>
            @endif
        </div>

        <!-- Quick Actions Section -->
        @if(count($quickActions) > 0)
        <div class="bg-white rounded-2xl shadow-lg border border-gray-200 p-6 mb-8">
            <div class="flex items-center justify-between mb-6">
                <h2 class="text-xl font-bold text-gray-900 flex items-center">
                    <i class="fas fa-bolt text-yellow-500 mr-3"></i>
                    Quick Actions
                </h2>
                <span class="text-sm text-gray-500">{{ count($quickActions) }} available</span>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                @foreach($quickActions as $action)
                <a href="{{ route($action['route']) }}" class="group flex items-center p-4 bg-{{ $action['color'] }}-50 hover:bg-{{ $action['color'] }}-100 rounded-xl transition-all duration-200 border border-{{ $action['color'] }}-200 hover:border-{{ $action['color'] }}-300 hover:shadow-md">
                    <div class="w-12 h-12 bg-gradient-to-br from-{{ $action['color'] }}-500 to-{{ $action['color'] }}-600 rounded-xl flex items-center justify-center group-hover:scale-110 transition-transform shadow-lg">
                        <i class="fas {{ $action['icon'] }} text-white text-lg"></i>
                    </div>
                    <div class="ml-4 flex-1">
                        <p class="text-sm font-semibold text-gray-900 group-hover:text-{{ $action['color'] }}-700">{{ $action['title'] }}</p>
                        <p class="text-xs text-gray-600">{{ $action['description'] }}</p>
                    </div>
                    <i class="fas fa-arrow-right text-{{ $action['color'] }}-500 opacity-0 group-hover:opacity-100 transition-opacity"></i>
                </a>
                @endforeach
            </div>
        </div>
        @endif

        <!-- Recent Activities Section -->
        @if(count($recentActivities) > 0)
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
            @if(isset($recentActivities['members']) && $recentActivities['members']->count() > 0)
            <div class="bg-white rounded-2xl shadow-lg border border-gray-200 p-6">
                <div class="flex items-center justify-between mb-6">
                    <h2 class="text-lg font-bold text-gray-900 flex items-center">
                        <i class="fas fa-user-plus text-blue-500 mr-3"></i>
                        Recent Members
                    </h2>
                    <a href="{{ route('members.index') }}" class="text-blue-600 hover:text-blue-800 text-sm font-medium">
                        View All <i class="fas fa-arrow-right ml-1"></i>
                    </a>
                </div>
                
                <div class="space-y-3">
                    @foreach($recentActivities['members'] as $member)
                    <div class="flex items-center p-3 bg-blue-50 rounded-lg hover:bg-blue-100 transition-colors">
                        <div class="w-10 h-10 rounded-full bg-gradient-to-br from-blue-500 to-blue-600 flex items-center justify-center text-white font-bold">
                            {{ substr($member->first_name, 0, 1) }}
                        </div>
                        <div class="ml-3 flex-1 min-w-0">
                            <p class="text-sm font-medium text-gray-900 truncate">{{ $member->full_name }}</p>
                            <p class="text-xs text-gray-500">{{ $member->family->family_name ?? 'No Family' }}</p>
                        </div>
                        <span class="text-xs text-gray-400">{{ $member->created_at->diffForHumans() }}</span>
                    </div>
                    @endforeach
                </div>
            </div>
            @endif

            @if(isset($recentActivities['events']) && $recentActivities['events']->count() > 0)
            <div class="bg-white rounded-2xl shadow-lg border border-gray-200 p-6">
                <div class="flex items-center justify-between mb-6">
                    <h2 class="text-lg font-bold text-gray-900 flex items-center">
                        <i class="fas fa-calendar-alt text-orange-500 mr-3"></i>
                        Upcoming Events
                    </h2>
                    <a href="{{ route('events.index') }}" class="text-orange-600 hover:text-orange-800 text-sm font-medium">
                        View All <i class="fas fa-arrow-right ml-1"></i>
                    </a>
                </div>
                
                <div class="space-y-3">
                    @foreach($recentActivities['events'] as $event)
                    <div class="flex items-center p-3 bg-orange-50 rounded-lg hover:bg-orange-100 transition-colors">
                        <div class="w-10 h-10 rounded-lg bg-gradient-to-br from-orange-500 to-orange-600 flex items-center justify-center text-white">
                            <i class="fas fa-calendar text-sm"></i>
                        </div>
                        <div class="ml-3 flex-1 min-w-0">
                            <p class="text-sm font-medium text-gray-900 truncate">{{ $event->title }}</p>
                            <p class="text-xs text-gray-500">{{ $event->start_datetime->format('M d, Y g:i A') }}</p>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
            @endif
        </div>
        @endif

        <!-- Empty State if No Permissions -->
        @if(count($stats) == 0)
        <div class="bg-white rounded-2xl shadow-lg border border-gray-200 p-12 text-center">
            <div class="w-24 h-24 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-6">
                <i class="fas fa-shield-alt text-4xl text-gray-400"></i>
            </div>
            <h3 class="text-2xl font-bold text-gray-900 mb-3">No Permissions Assigned</h3>
            <p class="text-gray-600 mb-6 max-w-md mx-auto">
                Your account doesn't have any permissions assigned yet. Please contact your administrator to grant you access to church management features.
            </p>
            <a href="{{ route('profile.edit') }}" class="inline-flex items-center px-6 py-3 bg-gradient-to-r from-blue-600 to-red-600 text-white rounded-lg hover:from-blue-700 hover:to-red-700 transition-all duration-200 shadow-lg">
                <i class="fas fa-user-edit mr-2"></i>
                Edit Profile
            </a>
        </div>
        @endif
    </div>
</div>
@endsection
