@extends('components.app-layout')

@section('title', 'Permissions Management')
@section('subtitle', 'Manage system permissions and access control')

@section('content')
<div class="space-y-8">
    <!-- Header -->
    <div class="relative overflow-hidden bg-gradient-to-r from-blue-600 via-purple-600 to-red-600 rounded-3xl shadow-2xl">
        <div class="absolute inset-0 bg-black opacity-10"></div>
        <div class="relative px-8 py-12">
            <div class="flex items-center justify-between">
                <div>
                    <div class="flex items-center mb-4">
                        <div class="w-16 h-16 bg-white bg-opacity-20 backdrop-blur-sm rounded-2xl flex items-center justify-center mr-4">
                            <i class="fas fa-shield-alt text-3xl text-white"></i>
                        </div>
                        <div>
                            <h1 class="text-4xl font-bold text-white">Permissions Management</h1>
                            <p class="text-lg text-blue-100 mt-1">Control access to system features and modules</p>
                        </div>
                    </div>
                </div>
                <div class="hidden lg:block">
                    <a href="{{ route('permissions.create') }}" class="inline-flex items-center px-6 py-3 bg-white text-blue-600 rounded-xl font-semibold hover:bg-blue-50 transition-all duration-200 shadow-lg hover:shadow-xl">
                        <i class="fas fa-plus mr-2"></i>
                        New Permission
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
        <!-- Total Permissions -->
        <div class="bg-white rounded-2xl shadow-lg p-6 border border-gray-100 hover:shadow-xl transition-shadow">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-1">Total Permissions</p>
                    <p class="text-3xl font-bold text-gray-900">{{ $stats['total_permissions'] }}</p>
                    <p class="text-xs text-blue-600 mt-2">
                        <i class="fas fa-key mr-1"></i>System-wide
                    </p>
                </div>
                <div class="w-14 h-14 bg-gradient-to-br from-blue-500 to-blue-600 rounded-xl flex items-center justify-center">
                    <i class="fas fa-key text-white text-2xl"></i>
                </div>
            </div>
        </div>

        <!-- Total Modules -->
        <div class="bg-white rounded-2xl shadow-lg p-6 border border-gray-100 hover:shadow-xl transition-shadow">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-1">Permission Modules</p>
                    <p class="text-3xl font-bold text-gray-900">{{ $stats['total_modules'] }}</p>
                    <p class="text-xs text-purple-600 mt-2">
                        <i class="fas fa-layer-group mr-1"></i>Feature groups
                    </p>
                </div>
                <div class="w-14 h-14 bg-gradient-to-br from-purple-500 to-purple-600 rounded-xl flex items-center justify-center">
                    <i class="fas fa-layer-group text-white text-2xl"></i>
                </div>
            </div>
        </div>

        <!-- Assigned Permissions -->
        <div class="bg-white rounded-2xl shadow-lg p-6 border border-gray-100 hover:shadow-xl transition-shadow">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-1">Assigned to Roles</p>
                    <p class="text-3xl font-bold text-gray-900">{{ $stats['assigned_permissions'] }}</p>
                    <p class="text-xs text-green-600 mt-2">
                        <i class="fas fa-check-circle mr-1"></i>In use
                    </p>
                </div>
                <div class="w-14 h-14 bg-gradient-to-br from-green-500 to-green-600 rounded-xl flex items-center justify-center">
                    <i class="fas fa-check-circle text-white text-2xl"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Permissions by Module -->
    <div class="space-y-6">
        @foreach($permissions as $module => $modulePermissions)
        <div class="bg-white rounded-2xl shadow-lg border border-gray-100 overflow-hidden">
            <!-- Module Header -->
            <div class="bg-gradient-to-r from-blue-50 to-purple-50 px-6 py-4 border-b border-gray-200">
                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <div class="w-10 h-10 bg-gradient-to-br from-blue-500 to-purple-600 rounded-lg flex items-center justify-center mr-3">
                            <i class="fas fa-{{ getModuleIcon($module) }} text-white"></i>
                        </div>
                        <div>
                            <h3 class="text-lg font-bold text-gray-900">{{ ucwords(str_replace('_', ' ', $module)) }}</h3>
                            <p class="text-sm text-gray-600">{{ $modulePermissions->count() }} permissions</p>
                        </div>
                    </div>
                    <span class="px-3 py-1 bg-blue-100 text-blue-700 rounded-full text-sm font-medium">
                        {{ $modulePermissions->count() }}
                    </span>
                </div>
            </div>

            <!-- Permissions List -->
            <div class="p-6">
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                    @foreach($modulePermissions as $permission)
                    <div class="group relative bg-gray-50 hover:bg-blue-50 rounded-xl p-4 border border-gray-200 hover:border-blue-300 transition-all duration-200">
                        <div class="flex items-start justify-between mb-3">
                            <div class="flex-1">
                                <h4 class="font-semibold text-gray-900 mb-1">{{ $permission->name }}</h4>
                                <p class="text-xs text-gray-500 font-mono bg-gray-100 px-2 py-1 rounded inline-block">
                                    {{ $permission->slug }}
                                </p>
                            </div>
                            <div class="flex items-center space-x-2 ml-2">
                                <a href="{{ route('permissions.show', $permission) }}" class="text-blue-600 hover:text-blue-800" title="View Details">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="{{ route('permissions.edit', $permission) }}" class="text-green-600 hover:text-green-800" title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                            </div>
                        </div>
                        
                        @if($permission->description)
                        <p class="text-sm text-gray-600 mb-3">{{ $permission->description }}</p>
                        @endif
                        
                        <div class="flex items-center justify-between text-xs">
                            <span class="flex items-center text-gray-500">
                                <i class="fas fa-users mr-1"></i>
                                {{ $permission->roles_count }} {{ Str::plural('role', $permission->roles_count) }}
                            </span>
                            @if($permission->roles_count > 0)
                            <span class="px-2 py-1 bg-green-100 text-green-700 rounded-full font-medium">
                                <i class="fas fa-check mr-1"></i>Assigned
                            </span>
                            @else
                            <span class="px-2 py-1 bg-gray-100 text-gray-600 rounded-full font-medium">
                                <i class="fas fa-minus mr-1"></i>Unassigned
                            </span>
                            @endif
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
        @endforeach
    </div>

    @if($permissions->isEmpty())
    <!-- Empty State -->
    <div class="bg-white rounded-2xl shadow-lg border border-gray-200 p-12 text-center">
        <div class="w-24 h-24 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-6">
            <i class="fas fa-shield-alt text-4xl text-gray-400"></i>
        </div>
        <h3 class="text-2xl font-bold text-gray-900 mb-3">No Permissions Found</h3>
        <p class="text-gray-600 mb-6 max-w-md mx-auto">
            Get started by creating your first permission to control access to system features.
        </p>
        <a href="{{ route('permissions.create') }}" class="inline-flex items-center px-6 py-3 bg-gradient-to-r from-blue-600 to-purple-600 text-white rounded-lg hover:from-blue-700 hover:to-purple-700 transition-all duration-200 shadow-lg">
            <i class="fas fa-plus mr-2"></i>
            Create First Permission
        </a>
    </div>
    @endif
</div>

@php
function getModuleIcon($module) {
    $icons = [
        'members' => 'users',
        'events' => 'calendar-alt',
        'payments' => 'hand-holding-usd',
        'attendance' => 'clipboard-check',
        'ministries' => 'hands-praying',
        'users' => 'user-cog',
        'roles' => 'user-shield',
        'settings' => 'cog',
        'reports' => 'chart-bar',
        'messages' => 'sms',
        'inventory' => 'boxes',
        'finance' => 'coins',
    ];
    
    return $icons[$module] ?? 'key';
}
@endphp
@endsection
