@extends('components.app-layout')

@section('title', 'Edit Ministry')
@section('subtitle', 'Update ministry information and settings')

@section('content')
<div class="min-h-screen bg-gradient-to-br from-purple-50 via-indigo-50 to-blue-50 py-8">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="text-center mb-8">
            <div class="w-20 h-20 bg-gradient-to-r from-purple-600 to-indigo-600 rounded-full flex items-center justify-center mx-auto mb-4 shadow-lg">
                <i class="fas fa-edit text-white text-3xl"></i>
            </div>
            <h1 class="text-3xl font-bold bg-gradient-to-r from-gray-900 to-gray-700 bg-clip-text text-transparent">Edit Ministry</h1>
            <p class="text-gray-600 text-lg mt-2">Update "{{ $ministry->name }}" ministry information</p>
        </div>

        <form action="{{ route('ministries.update', $ministry) }}" method="POST" class="space-y-8">
            @csrf
            @method('PUT')
            
            <!-- Basic Information -->
            <div class="bg-white/80 backdrop-blur-xl rounded-3xl shadow-xl border border-white/30 p-8">
                <div class="flex items-center mb-8">
                    <div class="w-12 h-12 bg-gradient-to-r from-blue-500 to-indigo-500 rounded-2xl flex items-center justify-center shadow-lg mr-4">
                        <i class="fas fa-info-circle text-white text-lg"></i>
                    </div>
                    <div>
                        <h2 class="text-xl font-bold text-gray-900">Basic Information</h2>
                        <p class="text-gray-500 text-sm">Essential details about the ministry</p>
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Ministry Name -->
                    <div class="md:col-span-2">
                        <label for="name" class="block text-sm font-semibold text-gray-800 mb-2">Ministry Name <span class="text-red-500">*</span></label>
                        <input type="text" name="name" id="name" required 
                               class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md" 
                               placeholder="Enter ministry name" value="{{ old('name', $ministry->name) }}">
                        @error('name')
                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Ministry Type -->
                    <div>
                        <label for="ministry_type" class="block text-sm font-semibold text-gray-800 mb-2">Ministry Type <span class="text-red-500">*</span></label>
                        <select name="ministry_type" id="ministry_type" required 
                                class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md">
                            <option value="">Select Type</option>
                            <option value="worship" {{ old('ministry_type', $ministry->ministry_type) == 'worship' ? 'selected' : '' }}>Worship & Music</option>
                            <option value="youth" {{ old('ministry_type', $ministry->ministry_type) == 'youth' ? 'selected' : '' }}>Youth Ministry</option>
                            <option value="children" {{ old('ministry_type', $ministry->ministry_type) == 'children' ? 'selected' : '' }}>Children's Ministry</option>
                            <option value="women" {{ old('ministry_type', $ministry->ministry_type) == 'women' ? 'selected' : '' }}>Women's Ministry</option>
                            <option value="men" {{ old('ministry_type', $ministry->ministry_type) == 'men' ? 'selected' : '' }}>Men's Ministry</option>
                            <option value="outreach" {{ old('ministry_type', $ministry->ministry_type) == 'outreach' ? 'selected' : '' }}>Outreach & Evangelism</option>
                            <option value="discipleship" {{ old('ministry_type', $ministry->ministry_type) == 'discipleship' ? 'selected' : '' }}>Discipleship</option>
                            <option value="prayer" {{ old('ministry_type', $ministry->ministry_type) == 'prayer' ? 'selected' : '' }}>Prayer Ministry</option>
                            <option value="media" {{ old('ministry_type', $ministry->ministry_type) == 'media' ? 'selected' : '' }}>Media & Technology</option>
                            <option value="hospitality" {{ old('ministry_type', $ministry->ministry_type) == 'hospitality' ? 'selected' : '' }}>Hospitality</option>
                            <option value="counseling" {{ old('ministry_type', $ministry->ministry_type) == 'counseling' ? 'selected' : '' }}>Counseling & Care</option>
                            <option value="education" {{ old('ministry_type', $ministry->ministry_type) == 'education' ? 'selected' : '' }}>Christian Education</option>
                            <option value="missions" {{ old('ministry_type', $ministry->ministry_type) == 'missions' ? 'selected' : '' }}>Missions</option>
                            <option value="administration" {{ old('ministry_type', $ministry->ministry_type) == 'administration' ? 'selected' : '' }}>Administration</option>
                            <option value="other" {{ old('ministry_type', $ministry->ministry_type) == 'other' ? 'selected' : '' }}>Other</option>
                        </select>
                        @error('ministry_type')
                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Status -->
                    <div>
                        <label for="is_active" class="block text-sm font-semibold text-gray-800 mb-2">Status</label>
                        <select name="is_active" id="is_active" 
                                class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md">
                            <option value="1" {{ old('is_active', $ministry->is_active) == '1' ? 'selected' : '' }}>Active</option>
                            <option value="0" {{ old('is_active', $ministry->is_active) == '0' ? 'selected' : '' }}>Inactive</option>
                        </select>
                        @error('is_active')
                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Description -->
                    <div class="md:col-span-2">
                        <label for="description" class="block text-sm font-semibold text-gray-800 mb-2">Description</label>
                        <textarea name="description" id="description" rows="4" 
                                  class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md resize-none" 
                                  placeholder="Describe the ministry's purpose and activities">{{ old('description', $ministry->description) }}</textarea>
                        @error('description')
                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Leadership & Contact -->
            <div class="bg-white/80 backdrop-blur-xl rounded-3xl shadow-xl border border-white/30 p-8">
                <div class="flex items-center mb-8">
                    <div class="w-12 h-12 bg-gradient-to-r from-green-500 to-teal-500 rounded-2xl flex items-center justify-center shadow-lg mr-4">
                        <i class="fas fa-user-tie text-white text-lg"></i>
                    </div>
                    <div>
                        <h2 class="text-xl font-bold text-gray-900">Leadership & Contact</h2>
                        <p class="text-gray-500 text-sm">Ministry leadership and contact information</p>
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Leader -->
                    <div>
                        <label for="leader_id" class="block text-sm font-semibold text-gray-800 mb-2">Ministry Leader</label>
                        <select name="leader_id" id="leader_id" 
                                class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md">
                            <option value="">Select Leader</option>
                            @foreach($members as $member)
                                <option value="{{ $member->id }}" {{ old('leader_id', $ministry->leader_id) == $member->id ? 'selected' : '' }}>
                                    {{ $member->full_name }}
                                </option>
                            @endforeach
                        </select>
                        @error('leader_id')
                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Contact Email -->
                    <div>
                        <label for="contact_email" class="block text-sm font-semibold text-gray-800 mb-2">Contact Email</label>
                        <input type="email" name="contact_email" id="contact_email" 
                               class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md" 
                               placeholder="ministry@church.org" value="{{ old('contact_email', $ministry->contact_email) }}">
                        @error('contact_email')
                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Contact Phone -->
                    <div>
                        <label for="contact_phone" class="block text-sm font-semibold text-gray-800 mb-2">Contact Phone</label>
                        <input type="tel" name="contact_phone" id="contact_phone" 
                               class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md" 
                               placeholder="+233 XX XXX XXXX" value="{{ old('contact_phone', $ministry->contact_phone) }}">
                        @error('contact_phone')
                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Meeting Location -->
                    <div>
                        <label for="meeting_location" class="block text-sm font-semibold text-gray-800 mb-2">Meeting Location</label>
                        <input type="text" name="meeting_location" id="meeting_location" 
                               class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md" 
                               placeholder="Church Hall, Room 101" value="{{ old('meeting_location', $ministry->meeting_location) }}">
                        @error('meeting_location')
                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Schedule & Requirements -->
            <div class="bg-white/80 backdrop-blur-xl rounded-3xl shadow-xl border border-white/30 p-8">
                <div class="flex items-center mb-8">
                    <div class="w-12 h-12 bg-gradient-to-r from-orange-500 to-red-500 rounded-2xl flex items-center justify-center shadow-lg mr-4">
                        <i class="fas fa-calendar-alt text-white text-lg"></i>
                    </div>
                    <div>
                        <h2 class="text-xl font-bold text-gray-900">Schedule & Requirements</h2>
                        <p class="text-gray-500 text-sm">Meeting schedule and membership requirements</p>
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Meeting Day -->
                    <div>
                        <label for="meeting_day" class="block text-sm font-semibold text-gray-800 mb-2">Meeting Day</label>
                        <select name="meeting_day" id="meeting_day" 
                                class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md">
                            <option value="">Select Day</option>
                            <option value="Sunday" {{ old('meeting_day', $ministry->meeting_day) == 'Sunday' ? 'selected' : '' }}>Sunday</option>
                            <option value="Monday" {{ old('meeting_day', $ministry->meeting_day) == 'Monday' ? 'selected' : '' }}>Monday</option>
                            <option value="Tuesday" {{ old('meeting_day', $ministry->meeting_day) == 'Tuesday' ? 'selected' : '' }}>Tuesday</option>
                            <option value="Wednesday" {{ old('meeting_day', $ministry->meeting_day) == 'Wednesday' ? 'selected' : '' }}>Wednesday</option>
                            <option value="Thursday" {{ old('meeting_day', $ministry->meeting_day) == 'Thursday' ? 'selected' : '' }}>Thursday</option>
                            <option value="Friday" {{ old('meeting_day', $ministry->meeting_day) == 'Friday' ? 'selected' : '' }}>Friday</option>
                            <option value="Saturday" {{ old('meeting_day', $ministry->meeting_day) == 'Saturday' ? 'selected' : '' }}>Saturday</option>
                        </select>
                        @error('meeting_day')
                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Meeting Time -->
                    <div>
                        <label for="meeting_time" class="block text-sm font-semibold text-gray-800 mb-2">Meeting Time</label>
                        <input type="time" name="meeting_time" id="meeting_time" 
                               class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md" 
                               value="{{ old('meeting_time', $ministry->meeting_time) }}">
                        @error('meeting_time')
                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Requirements -->
                    <div class="md:col-span-2">
                        <label for="requirements" class="block text-sm font-semibold text-gray-800 mb-2">Membership Requirements</label>
                        <textarea name="requirements" id="requirements" rows="3" 
                                  class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md resize-none" 
                                  placeholder="List any requirements for joining this ministry">{{ old('requirements', $ministry->requirements) }}</textarea>
                        @error('requirements')
                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="flex flex-col sm:flex-row gap-4 pt-8">
                <button type="submit" class="flex-1 bg-gradient-to-r from-blue-600 via-purple-600 to-indigo-600 text-white font-bold py-4 px-8 rounded-2xl hover:from-blue-700 hover:via-purple-700 hover:to-indigo-700 transition-all duration-300 shadow-lg hover:shadow-xl transform hover:scale-105 flex items-center justify-center">
                    <i class="fas fa-save mr-3"></i>
                    Update Ministry
                </button>
                <a href="{{ route('ministries.show', $ministry) }}" class="flex-1 bg-white border-2 border-gray-300 text-gray-700 font-bold py-4 px-8 rounded-2xl hover:bg-gray-50 hover:border-gray-400 transition-all duration-300 shadow-lg hover:shadow-xl flex items-center justify-center">
                    <i class="fas fa-eye mr-3"></i>
                    View Ministry
                </a>
                <a href="{{ route('ministries.index') }}" class="flex-1 bg-gray-100 text-gray-600 font-bold py-4 px-8 rounded-2xl hover:bg-gray-200 transition-all duration-300 shadow-lg hover:shadow-xl flex items-center justify-center">
                    <i class="fas fa-arrow-left mr-3"></i>
                    Back to List
                </a>
            </div>
        </form>
    </div>
</div>

<script>
// Auto-save functionality (optional)
let autoSaveTimeout;
const form = document.querySelector('form');
const inputs = form.querySelectorAll('input, select, textarea');

inputs.forEach(input => {
    input.addEventListener('input', function() {
        clearTimeout(autoSaveTimeout);
        autoSaveTimeout = setTimeout(() => {
            // Show auto-save indicator
            showNotification('Changes auto-saved', 'success');
        }, 2000);
    });
});

function showNotification(message, type = 'info') {
    // Create notification element
    const notification = document.createElement('div');
    notification.className = `fixed top-4 right-4 px-6 py-3 rounded-lg text-white z-50 transition-all duration-300 ${
        type === 'success' ? 'bg-green-500' : 
        type === 'error' ? 'bg-red-500' : 
        'bg-blue-500'
    }`;
    notification.textContent = message;
    
    document.body.appendChild(notification);
    
    // Remove after 3 seconds
    setTimeout(() => {
        notification.remove();
    }, 3000);
}

// Form validation
form.addEventListener('submit', function(e) {
    const requiredFields = form.querySelectorAll('[required]');
    let isValid = true;
    
    requiredFields.forEach(field => {
        if (!field.value.trim()) {
            isValid = false;
            field.classList.add('border-red-500');
        } else {
            field.classList.remove('border-red-500');
        }
    });
    
    if (!isValid) {
        e.preventDefault();
        showNotification('Please fill in all required fields', 'error');
    }
});
</script>
@endsection
