@extends('components.app-layout')

@section('title', 'Pending Member Registrations')
@section('subtitle', 'Review and approve new member registrations')

@section('content')
<div class="py-8">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="mb-8">
            <div class="bg-gradient-to-r from-blue-600 to-red-600 rounded-3xl shadow-2xl p-8 text-white">
                <div class="flex items-center justify-between">
                    <div>
                        <h1 class="text-4xl font-bold mb-2 flex items-center">
                            <i class="fas fa-user-clock mr-4"></i>
                            Pending Member Registrations
                        </h1>
                        <p class="text-white/90 text-lg">Review and approve new member applications</p>
                    </div>
                    <div class="text-right">
                        <div class="text-5xl font-bold">{{ $pendingMembers->count() }}</div>
                        <div class="text-white/80">Pending</div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Success/Error Messages -->
        @if(session('success'))
            <div class="mb-6 bg-green-50 border-l-4 border-green-500 p-4 rounded-r-xl">
                <div class="flex">
                    <i class="fas fa-check-circle text-green-500 mt-1 mr-3"></i>
                    <p class="text-green-700">{{ session('success') }}</p>
                </div>
            </div>
        @endif

        @if(session('error'))
            <div class="mb-6 bg-red-50 border-l-4 border-red-500 p-4 rounded-r-xl">
                <div class="flex">
                    <i class="fas fa-exclamation-circle text-red-500 mt-1 mr-3"></i>
                    <p class="text-red-700">{{ session('error') }}</p>
                </div>
            </div>
        @endif

        <!-- Pending Members List -->
        @if($pendingMembers->count() > 0)
            <div class="grid grid-cols-1 gap-6">
                @foreach($pendingMembers as $member)
                    <div class="bg-white rounded-2xl shadow-lg border-2 border-gray-100 hover:border-blue-500 transition-all duration-300 overflow-hidden">
                        <div class="p-6">
                            <div class="flex items-start justify-between">
                                <!-- Member Info -->
                                <div class="flex items-start space-x-4 flex-1">
                                    <!-- Photo -->
                                    <div class="flex-shrink-0">
                                        @if($member->photo_path)
                                            <img src="{{ asset('storage/' . $member->photo_path) }}" 
                                                 alt="{{ $member->full_name }}" 
                                                 class="w-20 h-20 rounded-xl object-cover border-4 border-gray-100">
                                        @else
                                            <div class="w-20 h-20 rounded-xl bg-gradient-to-br from-blue-600 to-red-600 flex items-center justify-center text-white text-2xl font-bold border-4 border-gray-100">
                                                {{ strtoupper(substr($member->first_name, 0, 1)) }}{{ strtoupper(substr($member->last_name, 0, 1)) }}
                                            </div>
                                        @endif
                                    </div>

                                    <!-- Details -->
                                    <div class="flex-1">
                                        <h3 class="text-2xl font-bold text-gray-900 mb-2">
                                            {{ $member->full_name }}
                                        </h3>
                                        
                                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4 mb-4">
                                            <div class="flex items-center text-gray-700">
                                                <i class="fas fa-phone w-5 text-blue-600 mr-2"></i>
                                                <span>{{ $member->phone }}</span>
                                            </div>
                                            @if($member->email)
                                                <div class="flex items-center text-gray-700">
                                                    <i class="fas fa-envelope w-5 text-blue-600 mr-2"></i>
                                                    <span>{{ $member->email }}</span>
                                                </div>
                                            @endif
                                            <div class="flex items-center text-gray-700">
                                                <i class="fas fa-birthday-cake w-5 text-blue-600 mr-2"></i>
                                                <span>{{ $member->date_of_birth ? $member->date_of_birth->format('M d, Y') : 'N/A' }} ({{ $member->age }} years)</span>
                                            </div>
                                            <div class="flex items-center text-gray-700">
                                                <i class="fas fa-venus-mars w-5 text-blue-600 mr-2"></i>
                                                <span class="capitalize">{{ $member->gender }}</span>
                                            </div>
                                            <div class="flex items-center text-gray-700">
                                                <i class="fas fa-ring w-5 text-blue-600 mr-2"></i>
                                                <span class="capitalize">{{ $member->marital_status }}</span>
                                            </div>
                                            <div class="flex items-center text-gray-700">
                                                <i class="fas fa-church w-5 text-blue-600 mr-2"></i>
                                                <span class="capitalize">{{ str_replace('_', ' ', $member->membership_type) }}</span>
                                            </div>
                                        </div>

                                        @if($member->address)
                                            <div class="flex items-start text-gray-700 mb-2">
                                                <i class="fas fa-map-marker-alt w-5 text-blue-600 mr-2 mt-1"></i>
                                                <span>{{ $member->address }}, {{ $member->city }}, {{ $member->country }}</span>
                                            </div>
                                        @endif

                                        <div class="flex items-center text-sm text-gray-500 mt-2">
                                            <i class="fas fa-clock mr-2"></i>
                                            <span>Registered {{ $member->created_at->diffForHumans() }}</span>
                                        </div>
                                    </div>
                                </div>

                                <!-- Action Buttons -->
                                <div class="flex flex-col space-y-3 ml-6">
                                    <form action="{{ route('members.approve', $member) }}" method="POST" class="inline">
                                        @csrf
                                        <button type="submit" 
                                                onclick="return confirm('Are you sure you want to approve this member?')"
                                                class="w-full px-6 py-3 bg-gradient-to-r from-green-600 to-emerald-600 text-white font-bold rounded-xl hover:from-green-700 hover:to-emerald-700 transition-all duration-300 shadow-lg hover:shadow-xl transform hover:scale-105">
                                            <i class="fas fa-check mr-2"></i>
                                            Approve
                                        </button>
                                    </form>
                                    
                                    <a href="{{ route('members.show', $member) }}" 
                                       class="px-6 py-3 bg-blue-600 text-white font-bold rounded-xl hover:bg-blue-700 transition-all duration-300 shadow-lg hover:shadow-xl transform hover:scale-105 text-center">
                                        <i class="fas fa-eye mr-2"></i>
                                        View Details
                                    </a>
                                    
                                    <form action="{{ route('members.reject', $member) }}" method="POST" class="inline">
                                        @csrf
                                        <button type="submit" 
                                                onclick="return confirm('Are you sure you want to reject this member registration?')"
                                                class="w-full px-6 py-3 bg-gradient-to-r from-red-600 to-pink-600 text-white font-bold rounded-xl hover:from-red-700 hover:to-pink-700 transition-all duration-300 shadow-lg hover:shadow-xl transform hover:scale-105">
                                            <i class="fas fa-times mr-2"></i>
                                            Reject
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        @else
            <!-- Empty State -->
            <div class="bg-white rounded-3xl shadow-xl p-12 text-center">
                <div class="w-24 h-24 bg-gradient-to-br from-blue-100 to-red-100 rounded-full flex items-center justify-center mx-auto mb-6">
                    <i class="fas fa-user-check text-5xl text-blue-600"></i>
                </div>
                <h3 class="text-2xl font-bold text-gray-900 mb-2">No Pending Registrations</h3>
                <p class="text-gray-600 mb-6">All member registrations have been processed</p>
                <a href="{{ route('members.index') }}" 
                   class="inline-flex items-center px-6 py-3 bg-gradient-to-r from-blue-600 to-red-600 text-white font-bold rounded-xl hover:from-blue-700 hover:to-red-700 transition-all duration-300 shadow-lg">
                    <i class="fas fa-users mr-2"></i>
                    View All Members
                </a>
            </div>
        @endif

        <!-- Registration Link -->
        <div class="mt-8 bg-gradient-to-r from-blue-50 to-red-50 rounded-2xl p-6 border-2 border-blue-200">
            <div class="flex items-center justify-between">
                <div class="flex items-center">
                    <div class="w-12 h-12 bg-gradient-to-br from-blue-600 to-red-600 rounded-xl flex items-center justify-center mr-4">
                        <i class="fas fa-link text-white text-xl"></i>
                    </div>
                    <div>
                        <h4 class="font-bold text-gray-900 text-lg">Member Registration Link</h4>
                        <p class="text-gray-600 text-sm">Share this link with new members to register</p>
                    </div>
                </div>
                <div class="flex items-center space-x-3">
                    <code class="bg-white px-4 py-2 rounded-lg text-blue-600 font-mono text-sm border border-blue-200">
                        {{ route('member.register') }}
                    </code>
                    <button onclick="copyRegistrationLink()" 
                            class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition">
                        <i class="fas fa-copy mr-2"></i>
                        Copy Link
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function copyRegistrationLink() {
    const link = '{{ route("member.register") }}';
    navigator.clipboard.writeText(link).then(function() {
        alert('Registration link copied to clipboard!');
    }).catch(function(err) {
        alert('Failed to copy link. Please copy manually.');
    });
}
</script>
@endsection
