@extends('components.app-layout')

@section('title', 'Inventory Categories')

@php
    $dynamicSubtitle = 'Manage ' . ($organizationSettings['name'] ?? 'Presbyterian Church of Ghana') . ' inventory categories';
@endphp

@section('subtitle', $dynamicSubtitle)

@section('content')
<div class="min-h-screen bg-gradient-to-br from-slate-50 via-cyan-50 to-blue-50 py-8">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 space-y-8">
        
        <!-- Header Section -->
        <div class="relative overflow-hidden bg-gradient-to-r from-cyan-600 via-blue-600 to-indigo-600 rounded-3xl shadow-2xl">
            <div class="absolute inset-0 bg-black opacity-5"></div>
            <div class="absolute top-0 right-0 w-64 h-64 bg-white opacity-5 rounded-full transform translate-x-32 -translate-y-32"></div>
            <div class="absolute bottom-0 left-0 w-48 h-48 bg-white opacity-5 rounded-full transform -translate-x-24 translate-y-24"></div>
            
            <div class="relative px-8 py-16">
                <div class="max-w-4xl mx-auto text-center">
                    <div class="inline-flex items-center justify-center w-20 h-20 bg-white bg-opacity-20 backdrop-blur-sm rounded-2xl mb-6 shadow-xl">
                        <i class="fas fa-tags text-3xl text-white"></i>
                    </div>
                    <h1 class="text-5xl font-bold text-white mb-4">Inventory Categories</h1>
                    <p class="text-xl text-white opacity-90 mb-8 max-w-2xl mx-auto">
                        Organize your inventory with custom categories and manage item classifications
                    </p>
                    <div class="flex items-center justify-center space-x-8 text-white/80">
                        <div class="flex items-center">
                            <i class="fas fa-layer-group mr-2"></i>
                            <span class="text-sm">Category Management</span>
                        </div>
                        <div class="flex items-center">
                            <i class="fas fa-palette mr-2"></i>
                            <span class="text-sm">Color Coding</span>
                        </div>
                        <div class="flex items-center">
                            <i class="fas fa-chart-pie mr-2"></i>
                            <span class="text-sm">Item Statistics</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="flex flex-col lg:flex-row justify-between items-start lg:items-center gap-6">
            <div class="space-y-3">
                <div class="flex items-center space-x-4">
                    <div class="w-12 h-12 bg-gradient-to-r from-cyan-600 to-blue-600 rounded-2xl flex items-center justify-center shadow-xl">
                        <i class="fas fa-tags text-white text-xl"></i>
                    </div>
                    <div>
                        <h2 class="text-3xl font-bold bg-gradient-to-r from-cyan-600 via-blue-600 to-indigo-600 bg-clip-text text-transparent">Categories Overview</h2>
                        <p class="text-gray-600 text-lg mt-1">{{ $categories->count() }} categories found</p>
                    </div>
                </div>
            </div>
            <div class="flex flex-wrap items-center gap-4">
                <a href="{{ route('inventory.categories.create') }}" class="inline-flex items-center px-6 py-3 bg-gradient-to-r from-cyan-600 via-blue-600 to-indigo-600 text-white font-bold rounded-xl hover:from-cyan-700 hover:via-blue-700 hover:to-indigo-700 transition-all duration-300 shadow-xl hover:shadow-2xl transform hover:scale-105">
                    <i class="fas fa-plus mr-2"></i>
                    Add Category
                </a>
                <a href="{{ route('inventory.items.index') }}" class="inline-flex items-center px-4 py-3 bg-white text-gray-700 font-medium rounded-xl border border-gray-200 hover:bg-gray-50 transition-all duration-200 shadow-md hover:shadow-lg transform hover:scale-105">
                    <i class="fas fa-boxes mr-2"></i>
                    All Items
                </a>
                <a href="{{ route('inventory.index') }}" class="inline-flex items-center px-4 py-3 bg-white text-gray-700 font-medium rounded-xl border border-gray-200 hover:bg-gray-50 transition-all duration-200 shadow-md hover:shadow-lg transform hover:scale-105">
                    <i class="fas fa-tachometer-alt mr-2"></i>
                    Dashboard
                </a>
            </div>
        </div>

        <!-- Categories Grid -->
        @if($categories->count() > 0)
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6">
                @foreach($categories as $category)
                    <div class="group bg-white/90 backdrop-blur-sm rounded-2xl shadow-xl border border-gray-100/50 p-6 hover:shadow-2xl transition-all duration-300 transform hover:scale-105 relative overflow-hidden">
                        <!-- Category Color Accent -->
                        <div class="absolute top-0 left-0 w-full h-2 rounded-t-2xl" style="background: linear-gradient(90deg, {{ $category->color ?? '#6B7280' }}, {{ $category->color ?? '#6B7280' }}99)"></div>
                        
                        <!-- Category Header -->
                        <div class="flex items-start justify-between mb-4">
                            <div class="flex items-center space-x-3">
                                <div class="w-12 h-12 rounded-xl flex items-center justify-center shadow-lg group-hover:scale-110 transition-transform duration-300" style="background: linear-gradient(135deg, {{ $category->color ?? '#6B7280' }}, {{ $category->color ?? '#6B7280' }}99)">
                                    <i class="{{ $category->icon ?? 'fas fa-tag' }} text-white text-lg"></i>
                                </div>
                                <div class="flex-1">
                                    <h3 class="font-bold text-gray-900 group-hover:text-cyan-600 transition-colors duration-200 text-lg">{{ $category->name }}</h3>
                                    @if($category->description)
                                        <p class="text-sm text-gray-600 mt-1 line-clamp-2">{{ $category->description }}</p>
                                    @endif
                                </div>
                            </div>
                            
                            <!-- Status Badge -->
                            @if($category->is_active)
                                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                    <i class="fas fa-check-circle mr-1"></i>
                                    Active
                                </span>
                            @else
                                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-gray-100 text-gray-800">
                                    <i class="fas fa-pause-circle mr-1"></i>
                                    Inactive
                                </span>
                            @endif
                        </div>

                        <!-- Category Statistics -->
                        <div class="grid grid-cols-2 gap-4 mb-4">
                            <div class="text-center p-3 bg-gradient-to-br from-blue-50 to-cyan-50 rounded-xl border border-blue-200">
                                <div class="text-2xl font-bold text-blue-700">{{ $category->items_count ?? 0 }}</div>
                                <div class="text-xs text-blue-600 font-medium">Total Items</div>
                            </div>
                            <div class="text-center p-3 bg-gradient-to-br from-emerald-50 to-green-50 rounded-xl border border-emerald-200">
                                <div class="text-2xl font-bold text-emerald-700">{{ $category->active_items_count ?? 0 }}</div>
                                <div class="text-xs text-emerald-600 font-medium">Active Items</div>
                            </div>
                        </div>

                        <!-- Stock Value -->
                        <div class="mb-4 p-3 bg-gradient-to-r from-gray-50 to-slate-50 rounded-xl border border-gray-200">
                            <div class="flex items-center justify-between">
                                <span class="text-sm font-medium text-gray-600">Total Stock Value</span>
                                <span class="text-lg font-bold text-gray-900">₵{{ number_format($category->total_stock_value ?? 0, 2) }}</span>
                            </div>
                        </div>

                        <!-- Low Stock Alert -->
                        @if($category->low_stock_items_count > 0)
                            <div class="mb-4 p-3 bg-gradient-to-r from-orange-50 to-red-50 rounded-xl border border-orange-200">
                                <div class="flex items-center justify-between">
                                    <div class="flex items-center">
                                        <i class="fas fa-exclamation-triangle text-orange-500 mr-2"></i>
                                        <span class="text-sm font-medium text-orange-700">Low Stock Items</span>
                                    </div>
                                    <span class="text-lg font-bold text-orange-600">{{ $category->low_stock_items_count }}</span>
                                </div>
                            </div>
                        @endif

                        <!-- Action Buttons -->
                        <div class="flex space-x-2">
                            <a href="{{ route('inventory.categories.show', $category) }}" class="flex-1 bg-cyan-600 text-white px-3 py-2 rounded-lg text-sm font-medium hover:bg-cyan-700 transition-colors text-center">
                                View Details
                            </a>
                            <a href="{{ route('inventory.categories.edit', $category) }}" class="flex-1 bg-blue-600 text-white px-3 py-2 rounded-lg text-sm font-medium hover:bg-blue-700 transition-colors text-center">
                                Edit
                            </a>
                        </div>

                        <!-- Quick View Items Link -->
                        @if($category->items_count > 0)
                            <div class="mt-3">
                                <a href="{{ route('inventory.items.index', ['category' => $category->id]) }}" class="w-full bg-gray-100 text-gray-700 px-3 py-2 rounded-lg text-sm font-medium hover:bg-gray-200 transition-colors text-center block">
                                    <i class="fas fa-boxes mr-2"></i>
                                    View {{ $category->items_count }} Items
                                </a>
                            </div>
                        @endif
                    </div>
                @endforeach
            </div>

            <!-- Category Statistics Summary -->
            <div class="bg-white/90 backdrop-blur-sm rounded-2xl shadow-xl border border-gray-100/50 p-8">
                <div class="flex items-center justify-between mb-6">
                    <h3 class="text-2xl font-bold text-gray-900">Category Statistics</h3>
                    <i class="fas fa-chart-pie text-cyan-600 text-2xl"></i>
                </div>
                
                <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
                    <!-- Total Categories -->
                    <div class="text-center p-6 bg-gradient-to-br from-cyan-50 to-blue-50 rounded-xl border border-cyan-200">
                        <div class="w-12 h-12 bg-cyan-500 rounded-full flex items-center justify-center mx-auto mb-4">
                            <i class="fas fa-tags text-white text-xl"></i>
                        </div>
                        <div class="text-3xl font-bold text-cyan-700 mb-2">{{ $categories->count() }}</div>
                        <div class="text-sm font-medium text-cyan-600">Total Categories</div>
                    </div>

                    <!-- Active Categories -->
                    <div class="text-center p-6 bg-gradient-to-br from-green-50 to-emerald-50 rounded-xl border border-green-200">
                        <div class="w-12 h-12 bg-green-500 rounded-full flex items-center justify-center mx-auto mb-4">
                            <i class="fas fa-check-circle text-white text-xl"></i>
                        </div>
                        <div class="text-3xl font-bold text-green-700 mb-2">{{ $categories->where('is_active', true)->count() }}</div>
                        <div class="text-sm font-medium text-green-600">Active Categories</div>
                    </div>

                    <!-- Total Items -->
                    <div class="text-center p-6 bg-gradient-to-br from-blue-50 to-indigo-50 rounded-xl border border-blue-200">
                        <div class="w-12 h-12 bg-blue-500 rounded-full flex items-center justify-center mx-auto mb-4">
                            <i class="fas fa-boxes text-white text-xl"></i>
                        </div>
                        <div class="text-3xl font-bold text-blue-700 mb-2">{{ $categories->sum('items_count') }}</div>
                        <div class="text-sm font-medium text-blue-600">Total Items</div>
                    </div>

                    <!-- Total Stock Value -->
                    <div class="text-center p-6 bg-gradient-to-br from-purple-50 to-pink-50 rounded-xl border border-purple-200">
                        <div class="w-12 h-12 bg-purple-500 rounded-full flex items-center justify-center mx-auto mb-4">
                            <i class="fas fa-dollar-sign text-white text-xl"></i>
                        </div>
                        <div class="text-3xl font-bold text-purple-700 mb-2">₵{{ number_format($categories->sum('total_stock_value'), 2) }}</div>
                        <div class="text-sm font-medium text-purple-600">Total Stock Value</div>
                    </div>
                </div>
            </div>
        @else
            <!-- No Categories Found -->
            <div class="bg-white/90 backdrop-blur-sm rounded-2xl shadow-xl border border-gray-100/50 p-12 text-center">
                <div class="w-20 h-20 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-6">
                    <i class="fas fa-tags text-gray-400 text-3xl"></i>
                </div>
                <h2 class="text-2xl font-bold text-gray-900 mb-4">No Categories Found</h2>
                <p class="text-gray-600 mb-6">
                    You haven't created any inventory categories yet. Start by creating your first category to organize your items.
                </p>
                <div class="flex justify-center space-x-4">
                    <a href="{{ route('inventory.categories.create') }}" class="inline-flex items-center px-6 py-3 bg-cyan-600 text-white font-medium rounded-xl hover:bg-cyan-700 transition-colors">
                        <i class="fas fa-plus mr-2"></i>
                        Create First Category
                    </a>
                    <a href="{{ route('inventory.index') }}" class="inline-flex items-center px-6 py-3 bg-gray-600 text-white font-medium rounded-xl hover:bg-gray-700 transition-colors">
                        <i class="fas fa-arrow-left mr-2"></i>
                        Back to Dashboard
                    </a>
                </div>
            </div>
        @endif

        <!-- Back to Dashboard -->
        <div class="text-center">
            <a href="{{ route('inventory.index') }}" class="inline-flex items-center px-6 py-3 bg-white/80 backdrop-blur-sm border border-gray-200 text-gray-700 font-medium rounded-xl hover:bg-gray-50 hover:shadow-lg transition-all duration-200 transform hover:scale-105">
                <i class="fas fa-arrow-left mr-2"></i>
                Back to Inventory Dashboard
            </a>
        </div>
    </div>
</div>
@endsection
