@extends('components.app-layout')

@section('title', 'Edit Category')
@section('subtitle', 'Update category details')

@section('content')
<div class="min-h-screen bg-gradient-to-br from-slate-50 via-blue-50 to-indigo-50 py-8">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 space-y-8">
        
        <!-- Header Section -->
        <div class="relative overflow-hidden bg-gradient-to-r from-blue-600 via-indigo-600 to-purple-600 rounded-3xl shadow-2xl">
            <div class="absolute inset-0 bg-black opacity-5"></div>
            <div class="absolute top-0 right-0 w-64 h-64 bg-white opacity-5 rounded-full transform translate-x-32 -translate-y-32"></div>
            <div class="absolute bottom-0 left-0 w-48 h-48 bg-white opacity-5 rounded-full transform -translate-x-24 translate-y-24"></div>
            
            <div class="relative px-8 py-12">
                <div class="max-w-4xl mx-auto">
                    <div class="flex items-center space-x-6">
                        <div class="w-16 h-16 bg-white bg-opacity-20 backdrop-blur-sm rounded-2xl flex items-center justify-center shadow-xl">
                            <i class="fas fa-edit text-2xl text-white"></i>
                        </div>
                        <div>
                            <h1 class="text-4xl font-bold text-white mb-2">Edit Category</h1>
                            <p class="text-xl text-white opacity-90">{{ $category->name }}</p>
                            <div class="flex items-center space-x-4 text-white/80 mt-2">
                                <span class="flex items-center">
                                    <i class="fas fa-boxes mr-2"></i>
                                    {{ $category->items->count() }} Items
                                </span>
                                <span class="flex items-center">
                                    <i class="fas fa-dollar-sign mr-2"></i>
                                    ₵{{ number_format($category->total_stock_value, 2) }}
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Edit Form -->
        <div class="bg-white/90 backdrop-blur-sm rounded-2xl shadow-xl border border-gray-100/50 p-8">
            <form action="{{ route('inventory.categories.update', $category) }}" method="POST" class="space-y-8">
                @csrf
                @method('PUT')

                <!-- Basic Information Section -->
                <div>
                    <div class="flex items-center space-x-3 mb-6">
                        <div class="w-10 h-10 bg-gradient-to-r from-blue-600 to-indigo-600 rounded-xl flex items-center justify-center">
                            <i class="fas fa-info-circle text-white"></i>
                        </div>
                        <h2 class="text-2xl font-bold text-gray-900">Basic Information</h2>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Category Name -->
                        <div>
                            <label for="name" class="block text-sm font-medium text-gray-700 mb-2">Category Name *</label>
                            <input type="text" name="name" id="name" value="{{ old('name', $category->name) }}" 
                                   class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md @error('name') border-red-500 @enderror" 
                                   required>
                            @error('name')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Status -->
                        <div>
                            <label for="is_active" class="block text-sm font-medium text-gray-700 mb-2">Status</label>
                            <div class="relative">
                                <select name="is_active" id="is_active" 
                                        class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md appearance-none @error('is_active') border-red-500 @enderror">
                                    <option value="1" {{ old('is_active', $category->is_active) ? 'selected' : '' }}>Active</option>
                                    <option value="0" {{ !old('is_active', $category->is_active) ? 'selected' : '' }}>Inactive</option>
                                </select>
                                <div class="absolute inset-y-0 right-0 flex items-center pr-4 pointer-events-none">
                                    <i class="fas fa-chevron-down text-gray-400"></i>
                                </div>
                            </div>
                            @error('is_active')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Description -->
                        <div class="md:col-span-2">
                            <label for="description" class="block text-sm font-medium text-gray-700 mb-2">Description</label>
                            <textarea name="description" id="description" rows="3" 
                                      class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md @error('description') border-red-500 @enderror" 
                                      placeholder="Describe this category...">{{ old('description', $category->description) }}</textarea>
                            @error('description')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                </div>

                <!-- Visual Settings Section -->
                <div>
                    <div class="flex items-center space-x-3 mb-6">
                        <div class="w-10 h-10 bg-gradient-to-r from-purple-600 to-pink-600 rounded-xl flex items-center justify-center">
                            <i class="fas fa-palette text-white"></i>
                        </div>
                        <h2 class="text-2xl font-bold text-gray-900">Visual Settings</h2>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Category Color -->
                        <div>
                            <label for="color" class="block text-sm font-medium text-gray-700 mb-2">Category Color</label>
                            <div class="flex items-center space-x-3">
                                <input type="color" name="color" id="color" value="{{ old('color', $category->color ?? '#6B7280') }}" 
                                       class="w-16 h-12 rounded-xl border-2 border-gray-200 cursor-pointer @error('color') border-red-500 @enderror"
                                       onchange="updateColorPreview()">
                                <input type="text" id="color_text" value="{{ old('color', $category->color ?? '#6B7280') }}" 
                                       class="flex-1 px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-purple-500/20 focus:border-purple-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md font-mono"
                                       onchange="updateColorPicker()"
                                       placeholder="#6B7280">
                            </div>
                            @error('color')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                            <p class="mt-1 text-xs text-gray-500">Choose a color that represents this category</p>
                        </div>

                        <!-- Category Icon -->
                        <div>
                            <label for="icon" class="block text-sm font-medium text-gray-700 mb-2">Category Icon</label>
                            <div class="flex items-center space-x-3">
                                <div id="icon_preview" class="w-12 h-12 rounded-xl flex items-center justify-center shadow-lg" style="background: linear-gradient(135deg, {{ $category->color ?? '#6B7280' }}, {{ $category->color ?? '#6B7280' }}99)">
                                    <i class="{{ old('icon', $category->icon ?? 'fas fa-tag') }} text-white text-lg"></i>
                                </div>
                                <input type="text" name="icon" id="icon" value="{{ old('icon', $category->icon ?? 'fas fa-tag') }}" 
                                       class="flex-1 px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-purple-500/20 focus:border-purple-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md font-mono @error('icon') border-red-500 @enderror"
                                       onchange="updateIconPreview()"
                                       placeholder="fas fa-tag">
                            </div>
                            @error('icon')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                            <p class="mt-1 text-xs text-gray-500">Use FontAwesome icon classes (e.g., fas fa-tag, fas fa-boxes)</p>
                        </div>
                    </div>

                    <!-- Icon Suggestions -->
                    <div class="mt-6">
                        <label class="block text-sm font-medium text-gray-700 mb-3">Popular Icons</label>
                        <div class="grid grid-cols-6 md:grid-cols-12 gap-3">
                            @php
                                $popularIcons = [
                                    'fas fa-tag', 'fas fa-boxes', 'fas fa-tools', 'fas fa-utensils',
                                    'fas fa-book', 'fas fa-microphone', 'fas fa-chair', 'fas fa-spray-can',
                                    'fas fa-laptop', 'fas fa-music', 'fas fa-camera', 'fas fa-gamepad',
                                    'fas fa-car', 'fas fa-home', 'fas fa-heart', 'fas fa-star',
                                    'fas fa-gift', 'fas fa-shopping-cart', 'fas fa-coffee', 'fas fa-leaf',
                                    'fas fa-lightbulb', 'fas fa-paint-brush', 'fas fa-wrench', 'fas fa-shield-alt'
                                ];
                            @endphp
                            @foreach($popularIcons as $iconClass)
                                <button type="button" onclick="selectIcon('{{ $iconClass }}')" 
                                        class="w-12 h-12 bg-gray-100 hover:bg-gray-200 rounded-xl flex items-center justify-center transition-colors group">
                                    <i class="{{ $iconClass }} text-gray-600 group-hover:text-gray-800"></i>
                                </button>
                            @endforeach
                        </div>
                    </div>

                    <!-- Color Preview -->
                    <div class="mt-6 p-4 rounded-xl border-2 border-gray-200" id="category_preview" style="background: linear-gradient(135deg, {{ $category->color ?? '#6B7280' }}, {{ $category->color ?? '#6B7280' }}99, {{ $category->color ?? '#6B7280' }}66)">
                        <div class="flex items-center space-x-3">
                            <div class="w-12 h-12 bg-white bg-opacity-20 backdrop-blur-sm rounded-xl flex items-center justify-center shadow-lg">
                                <i id="preview_icon" class="{{ old('icon', $category->icon ?? 'fas fa-tag') }} text-white text-lg"></i>
                            </div>
                            <div>
                                <h3 class="text-white font-bold text-lg" id="preview_name">{{ $category->name }}</h3>
                                <p class="text-white/80 text-sm">Category Preview</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Current Statistics -->
                <div>
                    <div class="flex items-center space-x-3 mb-6">
                        <div class="w-10 h-10 bg-gradient-to-r from-emerald-600 to-green-600 rounded-xl flex items-center justify-center">
                            <i class="fas fa-chart-bar text-white"></i>
                        </div>
                        <h2 class="text-2xl font-bold text-gray-900">Current Statistics</h2>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
                        <div class="text-center p-6 bg-gradient-to-br from-blue-50 to-cyan-50 rounded-xl border border-blue-200">
                            <div class="text-3xl font-bold text-blue-700 mb-2">{{ $category->items->count() }}</div>
                            <div class="text-sm font-medium text-blue-600">Total Items</div>
                        </div>
                        <div class="text-center p-6 bg-gradient-to-br from-emerald-50 to-green-50 rounded-xl border border-emerald-200">
                            <div class="text-3xl font-bold text-emerald-700 mb-2">{{ $category->activeItems->count() }}</div>
                            <div class="text-sm font-medium text-emerald-600">Active Items</div>
                        </div>
                        <div class="text-center p-6 bg-gradient-to-br from-orange-50 to-red-50 rounded-xl border border-orange-200">
                            <div class="text-3xl font-bold text-orange-700 mb-2">{{ $category->items->where('stock_status', 'low_stock')->count() }}</div>
                            <div class="text-sm font-medium text-orange-600">Low Stock</div>
                        </div>
                        <div class="text-center p-6 bg-gradient-to-br from-purple-50 to-pink-50 rounded-xl border border-purple-200">
                            <div class="text-3xl font-bold text-purple-700 mb-2">₵{{ number_format($category->total_stock_value, 2) }}</div>
                            <div class="text-sm font-medium text-purple-600">Total Value</div>
                        </div>
                    </div>

                    <div class="mt-6 p-4 bg-gradient-to-r from-blue-50 to-indigo-50 rounded-xl border border-blue-200">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-sm font-medium text-blue-700">Impact Notice</p>
                                <p class="text-blue-600">Changes to this category will affect {{ $category->items->count() }} items</p>
                            </div>
                            <div class="text-right">
                                <p class="text-sm text-blue-600">Last Updated</p>
                                <p class="text-blue-800 font-medium">{{ $category->updated_at->format('M d, Y') }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Action Buttons -->
                <div class="flex flex-col sm:flex-row justify-between items-center gap-4 pt-8 border-t border-gray-200">
                    <div class="flex space-x-4">
                        <a href="{{ route('inventory.categories.show', $category) }}" class="inline-flex items-center px-6 py-3 bg-gray-100 text-gray-700 font-medium rounded-xl border border-gray-200 hover:bg-gray-200 transition-all duration-200 shadow-md hover:shadow-lg">
                            <i class="fas fa-arrow-left mr-2"></i>
                            Back to Category
                        </a>
                        <a href="{{ route('inventory.categories.index') }}" class="inline-flex items-center px-6 py-3 bg-gray-100 text-gray-700 font-medium rounded-xl border border-gray-200 hover:bg-gray-200 transition-all duration-200 shadow-md hover:shadow-lg">
                            <i class="fas fa-tags mr-2"></i>
                            All Categories
                        </a>
                    </div>
                    
                    <div class="flex space-x-4">
                        <button type="reset" class="inline-flex items-center px-6 py-3 bg-gray-600 text-white font-medium rounded-xl hover:bg-gray-700 transition-colors shadow-lg hover:shadow-xl">
                            <i class="fas fa-undo mr-2"></i>
                            Reset Changes
                        </button>
                        <button type="submit" class="inline-flex items-center px-8 py-3 bg-gradient-to-r from-blue-600 via-indigo-600 to-purple-600 text-white font-bold rounded-xl hover:from-blue-700 hover:via-indigo-700 hover:to-purple-700 transition-all duration-300 shadow-xl hover:shadow-2xl transform hover:scale-105">
                            <i class="fas fa-save mr-2"></i>
                            Update Category
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function updateColorPreview() {
    const colorInput = document.getElementById('color');
    const colorText = document.getElementById('color_text');
    const preview = document.getElementById('category_preview');
    const iconPreview = document.getElementById('icon_preview');
    
    const color = colorInput.value;
    colorText.value = color;
    
    preview.style.background = `linear-gradient(135deg, ${color}, ${color}99, ${color}66)`;
    iconPreview.style.background = `linear-gradient(135deg, ${color}, ${color}99)`;
}

function updateColorPicker() {
    const colorText = document.getElementById('color_text');
    const colorInput = document.getElementById('color');
    const preview = document.getElementById('category_preview');
    const iconPreview = document.getElementById('icon_preview');
    
    const color = colorText.value;
    if (/^#[0-9A-F]{6}$/i.test(color)) {
        colorInput.value = color;
        preview.style.background = `linear-gradient(135deg, ${color}, ${color}99, ${color}66)`;
        iconPreview.style.background = `linear-gradient(135deg, ${color}, ${color}99)`;
    }
}

function updateIconPreview() {
    const iconInput = document.getElementById('icon');
    const iconPreview = document.getElementById('icon_preview').querySelector('i');
    const previewIcon = document.getElementById('preview_icon');
    
    const iconClass = iconInput.value;
    iconPreview.className = iconClass + ' text-white text-lg';
    previewIcon.className = iconClass + ' text-white text-lg';
}

function selectIcon(iconClass) {
    const iconInput = document.getElementById('icon');
    iconInput.value = iconClass;
    updateIconPreview();
}

// Update preview name when typing
document.getElementById('name').addEventListener('input', function() {
    document.getElementById('preview_name').textContent = this.value || 'Category Name';
});

// Initialize previews
document.addEventListener('DOMContentLoaded', function() {
    updateColorPreview();
    updateIconPreview();
});
</script>
@endsection
