@extends('components.app-layout')

@section('title', 'Inventory Alerts')
@section('subtitle', 'Monitor stock levels and expiring items')

@section('content')
<div class="min-h-screen bg-gradient-to-br from-slate-50 via-orange-50 to-red-50 py-8">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 space-y-8">
        
        <!-- Header Section -->
        <div class="relative overflow-hidden bg-gradient-to-r from-orange-600 via-red-600 to-pink-600 rounded-3xl shadow-2xl">
            <div class="absolute inset-0 bg-black opacity-5"></div>
            <div class="absolute top-0 right-0 w-64 h-64 bg-white opacity-5 rounded-full transform translate-x-32 -translate-y-32"></div>
            <div class="absolute bottom-0 left-0 w-48 h-48 bg-white opacity-5 rounded-full transform -translate-x-24 translate-y-24"></div>
            
            <div class="relative px-8 py-16">
                <div class="max-w-4xl mx-auto text-center">
                    <div class="inline-flex items-center justify-center w-20 h-20 bg-white bg-opacity-20 backdrop-blur-sm rounded-2xl mb-6 shadow-xl">
                        <i class="fas fa-exclamation-triangle text-3xl text-white"></i>
                    </div>
                    <h1 class="text-5xl font-bold text-white mb-4">Stock Alerts</h1>
                    <p class="text-xl text-white opacity-90 mb-8 max-w-2xl mx-auto">
                        Monitor inventory levels and take action on items that need attention
                    </p>
                    <div class="flex items-center justify-center space-x-8 text-white/80">
                        <div class="flex items-center">
                            <i class="fas fa-arrow-down mr-2"></i>
                            <span class="text-sm">Low Stock</span>
                        </div>
                        <div class="flex items-center">
                            <i class="fas fa-times-circle mr-2"></i>
                            <span class="text-sm">Out of Stock</span>
                        </div>
                        <div class="flex items-center">
                            <i class="fas fa-clock mr-2"></i>
                            <span class="text-sm">Expiring Soon</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Alert Summary Cards -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <!-- Low Stock Alert -->
            <div class="group bg-gradient-to-br from-yellow-500 via-orange-500 to-red-500 rounded-3xl p-8 text-white shadow-xl hover:shadow-2xl transition-all duration-500 transform hover:scale-105 relative overflow-hidden">
                <div class="absolute inset-0 bg-gradient-to-br from-white/10 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
                <div class="relative z-10">
                    <div class="flex items-center justify-between mb-6">
                        <div class="p-4 bg-white/20 rounded-2xl backdrop-blur-sm group-hover:bg-white/30 group-hover:scale-110 transition-all duration-300 shadow-lg">
                            <i class="fas fa-exclamation-triangle text-3xl group-hover:rotate-12 transition-transform duration-300"></i>
                        </div>
                        <div class="text-right">
                            <p class="text-orange-100 text-sm font-medium uppercase tracking-wider">Low Stock</p>
                            <p class="text-4xl font-bold group-hover:scale-110 transition-transform duration-300">{{ $lowStockItems->total() }}</p>
                        </div>
                    </div>
                    <div class="flex items-center justify-between text-orange-100">
                        <div class="flex items-center">
                            <i class="fas fa-arrow-down mr-2 group-hover:animate-bounce"></i>
                            <span class="text-sm font-medium">Items need restocking</span>
                        </div>
                        <div class="w-3 h-3 bg-orange-300 rounded-full animate-pulse"></div>
                    </div>
                </div>
            </div>

            <!-- Out of Stock Alert -->
            <div class="group bg-gradient-to-br from-red-500 via-red-600 to-red-700 rounded-3xl p-8 text-white shadow-xl hover:shadow-2xl transition-all duration-500 transform hover:scale-105 relative overflow-hidden">
                <div class="absolute inset-0 bg-gradient-to-br from-white/10 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
                <div class="relative z-10">
                    <div class="flex items-center justify-between mb-6">
                        <div class="p-4 bg-white/20 rounded-2xl backdrop-blur-sm group-hover:bg-white/30 group-hover:scale-110 transition-all duration-300 shadow-lg">
                            <i class="fas fa-times-circle text-3xl group-hover:rotate-12 transition-transform duration-300"></i>
                        </div>
                        <div class="text-right">
                            <p class="text-red-100 text-sm font-medium uppercase tracking-wider">Out of Stock</p>
                            <p class="text-4xl font-bold group-hover:scale-110 transition-transform duration-300">{{ $outOfStockItems->total() }}</p>
                        </div>
                    </div>
                    <div class="flex items-center justify-between text-red-100">
                        <div class="flex items-center">
                            <i class="fas fa-ban mr-2 group-hover:animate-pulse"></i>
                            <span class="text-sm font-medium">Items unavailable</span>
                        </div>
                        <div class="w-3 h-3 bg-red-300 rounded-full animate-pulse"></div>
                    </div>
                </div>
            </div>

            <!-- Expiring Soon Alert -->
            <div class="group bg-gradient-to-br from-purple-500 via-indigo-500 to-blue-500 rounded-3xl p-8 text-white shadow-xl hover:shadow-2xl transition-all duration-500 transform hover:scale-105 relative overflow-hidden">
                <div class="absolute inset-0 bg-gradient-to-br from-white/10 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
                <div class="relative z-10">
                    <div class="flex items-center justify-between mb-6">
                        <div class="p-4 bg-white/20 rounded-2xl backdrop-blur-sm group-hover:bg-white/30 group-hover:scale-110 transition-all duration-300 shadow-lg">
                            <i class="fas fa-clock text-3xl group-hover:rotate-12 transition-transform duration-300"></i>
                        </div>
                        <div class="text-right">
                            <p class="text-purple-100 text-sm font-medium uppercase tracking-wider">Expiring Soon</p>
                            <p class="text-4xl font-bold group-hover:scale-110 transition-transform duration-300">{{ $expiringItems->total() }}</p>
                        </div>
                    </div>
                    <div class="flex items-center justify-between text-purple-100">
                        <div class="flex items-center">
                            <i class="fas fa-calendar-times mr-2 group-hover:animate-pulse"></i>
                            <span class="text-sm font-medium">Items expiring (30 days)</span>
                        </div>
                        <div class="w-3 h-3 bg-purple-300 rounded-full animate-pulse"></div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Alert Sections -->
        <div class="space-y-8">
            
            <!-- Low Stock Items -->
            @if($lowStockItems->count() > 0)
            <div class="bg-white/90 backdrop-blur-sm rounded-2xl shadow-xl border border-gray-100/50 p-8">
                <div class="flex items-center justify-between mb-6">
                    <div class="flex items-center space-x-4">
                        <div class="w-12 h-12 bg-gradient-to-r from-yellow-500 to-orange-500 rounded-2xl flex items-center justify-center shadow-lg">
                            <i class="fas fa-exclamation-triangle text-white text-xl"></i>
                        </div>
                        <div>
                            <h2 class="text-2xl font-bold text-gray-900">Low Stock Items</h2>
                            <p class="text-gray-600">Items below minimum stock level</p>
                        </div>
                    </div>
                    <a href="{{ route('inventory.items.index', ['stock_status' => 'low_stock']) }}" class="inline-flex items-center px-4 py-2 bg-orange-600 text-white font-medium rounded-xl hover:bg-orange-700 transition-colors">
                        <i class="fas fa-eye mr-2"></i>
                        View All
                    </a>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                    @foreach($lowStockItems as $item)
                        <div class="bg-gradient-to-r from-orange-50 to-red-50 border-l-4 border-orange-500 rounded-xl p-6 hover:shadow-lg transition-all duration-200">
                            <div class="flex items-start justify-between">
                                <div class="flex-1">
                                    <h3 class="font-bold text-gray-900 mb-1">{{ $item->name }}</h3>
                                    <p class="text-sm text-gray-600 mb-2">{{ $item->category->name ?? 'No Category' }}</p>
                                    <div class="flex items-center space-x-4 text-sm">
                                        <span class="text-orange-600 font-medium">Current: {{ $item->current_stock }}</span>
                                        <span class="text-gray-500">Min: {{ $item->minimum_stock }}</span>
                                    </div>
                                    @if($item->location)
                                        <p class="text-xs text-gray-500 mt-1">
                                            <i class="fas fa-map-marker-alt mr-1"></i>
                                            {{ $item->location }}
                                        </p>
                                    @endif
                                </div>
                                <div class="ml-4">
                                    <div class="w-16 h-16 bg-orange-100 rounded-full flex items-center justify-center">
                                        <span class="text-orange-600 font-bold text-lg">{{ $item->current_stock }}</span>
                                    </div>
                                </div>
                            </div>
                            <div class="mt-4 flex space-x-2">
                                <a href="{{ route('inventory.items.show', $item) }}" class="flex-1 bg-white text-orange-600 border border-orange-200 px-3 py-2 rounded-lg text-sm font-medium hover:bg-orange-50 transition-colors text-center">
                                    View Details
                                </a>
                                <button onclick="showStockModal({{ $item->id }}, '{{ $item->name }}')" class="flex-1 bg-orange-600 text-white px-3 py-2 rounded-lg text-sm font-medium hover:bg-orange-700 transition-colors">
                                    Restock
                                </button>
                            </div>
                        </div>
                    @endforeach
                </div>

                @if($lowStockItems->hasPages())
                    <div class="mt-6">
                        {{ $lowStockItems->links() }}
                    </div>
                @endif
            </div>
            @endif

            <!-- Out of Stock Items -->
            @if($outOfStockItems->count() > 0)
            <div class="bg-white/90 backdrop-blur-sm rounded-2xl shadow-xl border border-gray-100/50 p-8">
                <div class="flex items-center justify-between mb-6">
                    <div class="flex items-center space-x-4">
                        <div class="w-12 h-12 bg-gradient-to-r from-red-500 to-red-600 rounded-2xl flex items-center justify-center shadow-lg">
                            <i class="fas fa-times-circle text-white text-xl"></i>
                        </div>
                        <div>
                            <h2 class="text-2xl font-bold text-gray-900">Out of Stock Items</h2>
                            <p class="text-gray-600">Items with zero stock</p>
                        </div>
                    </div>
                    <a href="{{ route('inventory.items.index', ['stock_status' => 'out_of_stock']) }}" class="inline-flex items-center px-4 py-2 bg-red-600 text-white font-medium rounded-xl hover:bg-red-700 transition-colors">
                        <i class="fas fa-eye mr-2"></i>
                        View All
                    </a>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                    @foreach($outOfStockItems as $item)
                        <div class="bg-gradient-to-r from-red-50 to-pink-50 border-l-4 border-red-500 rounded-xl p-6 hover:shadow-lg transition-all duration-200">
                            <div class="flex items-start justify-between">
                                <div class="flex-1">
                                    <h3 class="font-bold text-gray-900 mb-1">{{ $item->name }}</h3>
                                    <p class="text-sm text-gray-600 mb-2">{{ $item->category->name ?? 'No Category' }}</p>
                                    <div class="flex items-center space-x-4 text-sm">
                                        <span class="text-red-600 font-medium">Stock: 0</span>
                                        <span class="text-gray-500">Min: {{ $item->minimum_stock }}</span>
                                    </div>
                                    @if($item->location)
                                        <p class="text-xs text-gray-500 mt-1">
                                            <i class="fas fa-map-marker-alt mr-1"></i>
                                            {{ $item->location }}
                                        </p>
                                    @endif
                                </div>
                                <div class="ml-4">
                                    <div class="w-16 h-16 bg-red-100 rounded-full flex items-center justify-center">
                                        <i class="fas fa-ban text-red-600 text-xl"></i>
                                    </div>
                                </div>
                            </div>
                            <div class="mt-4 flex space-x-2">
                                <a href="{{ route('inventory.items.show', $item) }}" class="flex-1 bg-white text-red-600 border border-red-200 px-3 py-2 rounded-lg text-sm font-medium hover:bg-red-50 transition-colors text-center">
                                    View Details
                                </a>
                                <button onclick="showStockModal({{ $item->id }}, '{{ $item->name }}')" class="flex-1 bg-red-600 text-white px-3 py-2 rounded-lg text-sm font-medium hover:bg-red-700 transition-colors">
                                    Add Stock
                                </button>
                            </div>
                        </div>
                    @endforeach
                </div>

                @if($outOfStockItems->hasPages())
                    <div class="mt-6">
                        {{ $outOfStockItems->links() }}
                    </div>
                @endif
            </div>
            @endif

            <!-- Expiring Items -->
            @if($expiringItems->count() > 0)
            <div class="bg-white/90 backdrop-blur-sm rounded-2xl shadow-xl border border-gray-100/50 p-8">
                <div class="flex items-center justify-between mb-6">
                    <div class="flex items-center space-x-4">
                        <div class="w-12 h-12 bg-gradient-to-r from-purple-500 to-indigo-500 rounded-2xl flex items-center justify-center shadow-lg">
                            <i class="fas fa-clock text-white text-xl"></i>
                        </div>
                        <div>
                            <h2 class="text-2xl font-bold text-gray-900">Expiring Soon</h2>
                            <p class="text-gray-600">Items expiring within 30 days</p>
                        </div>
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                    @foreach($expiringItems as $item)
                        <div class="bg-gradient-to-r from-purple-50 to-indigo-50 border-l-4 border-purple-500 rounded-xl p-6 hover:shadow-lg transition-all duration-200">
                            <div class="flex items-start justify-between">
                                <div class="flex-1">
                                    <h3 class="font-bold text-gray-900 mb-1">{{ $item->name }}</h3>
                                    <p class="text-sm text-gray-600 mb-2">{{ $item->category->name ?? 'No Category' }}</p>
                                    <div class="flex items-center space-x-4 text-sm">
                                        <span class="text-purple-600 font-medium">Stock: {{ $item->current_stock }}</span>
                                        <span class="text-gray-500">Expires: {{ $item->expiry_date->format('M d, Y') }}</span>
                                    </div>
                                    <div class="mt-2">
                                        @php
                                            $daysToExpiry = $item->days_to_expiry;
                                        @endphp
                                        @if($daysToExpiry <= 7)
                                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-red-100 text-red-800">
                                                <i class="fas fa-exclamation-triangle mr-1"></i>
                                                {{ $daysToExpiry }} days left
                                            </span>
                                        @elseif($daysToExpiry <= 14)
                                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-orange-100 text-orange-800">
                                                <i class="fas fa-clock mr-1"></i>
                                                {{ $daysToExpiry }} days left
                                            </span>
                                        @else
                                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-yellow-100 text-yellow-800">
                                                <i class="fas fa-calendar mr-1"></i>
                                                {{ $daysToExpiry }} days left
                                            </span>
                                        @endif
                                    </div>
                                </div>
                                <div class="ml-4">
                                    <div class="w-16 h-16 bg-purple-100 rounded-full flex items-center justify-center">
                                        <span class="text-purple-600 font-bold text-sm">{{ $daysToExpiry }}d</span>
                                    </div>
                                </div>
                            </div>
                            <div class="mt-4">
                                <a href="{{ route('inventory.items.show', $item) }}" class="w-full bg-purple-600 text-white px-3 py-2 rounded-lg text-sm font-medium hover:bg-purple-700 transition-colors text-center block">
                                    View Details
                                </a>
                            </div>
                        </div>
                    @endforeach
                </div>

                @if($expiringItems->hasPages())
                    <div class="mt-6">
                        {{ $expiringItems->links() }}
                    </div>
                @endif
            </div>
            @endif

            <!-- No Alerts Message -->
            @if($lowStockItems->count() == 0 && $outOfStockItems->count() == 0 && $expiringItems->count() == 0)
            <div class="bg-white/90 backdrop-blur-sm rounded-2xl shadow-xl border border-gray-100/50 p-12 text-center">
                <div class="w-20 h-20 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-6">
                    <i class="fas fa-check-circle text-green-600 text-3xl"></i>
                </div>
                <h2 class="text-2xl font-bold text-gray-900 mb-4">All Good!</h2>
                <p class="text-gray-600 mb-6">No inventory alerts at this time. All items are well stocked and none are expiring soon.</p>
                <a href="{{ route('inventory.index') }}" class="inline-flex items-center px-6 py-3 bg-green-600 text-white font-medium rounded-xl hover:bg-green-700 transition-colors">
                    <i class="fas fa-arrow-left mr-2"></i>
                    Back to Dashboard
                </a>
            </div>
            @endif
        </div>

        <!-- Back to Dashboard -->
        <div class="text-center">
            <a href="{{ route('inventory.index') }}" class="inline-flex items-center px-6 py-3 bg-white/80 backdrop-blur-sm border border-gray-200 text-gray-700 font-medium rounded-xl hover:bg-gray-50 hover:shadow-lg transition-all duration-200 transform hover:scale-105">
                <i class="fas fa-arrow-left mr-2"></i>
                Back to Inventory Dashboard
            </a>
        </div>
    </div>
</div>

<!-- Stock Update Modal -->
<div id="stockModal" class="fixed inset-0 bg-black bg-opacity-50 hidden z-50 flex items-center justify-center">
    <div class="bg-white rounded-2xl shadow-2xl max-w-md w-full mx-4">
        <div class="p-6">
            <div class="flex items-center justify-between mb-6">
                <h3 class="text-xl font-bold text-gray-900">Update Stock</h3>
                <button onclick="closeStockModal()" class="text-gray-400 hover:text-gray-600">
                    <i class="fas fa-times text-xl"></i>
                </button>
            </div>
            
            <form id="stockForm" method="POST">
                @csrf
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Item</label>
                        <p id="modalItemName" class="text-gray-900 font-medium"></p>
                    </div>
                    
                    <div>
                        <label for="type" class="block text-sm font-medium text-gray-700 mb-2">Transaction Type</label>
                        <select name="type" id="type" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            <option value="in">Stock In</option>
                            <option value="out">Stock Out</option>
                            <option value="adjustment">Adjustment</option>
                        </select>
                    </div>
                    
                    <div>
                        <label for="quantity" class="block text-sm font-medium text-gray-700 mb-2">Quantity</label>
                        <input type="number" name="quantity" id="quantity" min="1" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" required>
                    </div>
                    
                    <div>
                        <label for="reason" class="block text-sm font-medium text-gray-700 mb-2">Reason</label>
                        <input type="text" name="reason" id="reason" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" required>
                    </div>
                    
                    <div>
                        <label for="notes" class="block text-sm font-medium text-gray-700 mb-2">Notes (Optional)</label>
                        <textarea name="notes" id="notes" rows="3" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"></textarea>
                    </div>
                </div>
                
                <div class="flex space-x-3 mt-6">
                    <button type="button" onclick="closeStockModal()" class="flex-1 px-4 py-2 border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 transition-colors">
                        Cancel
                    </button>
                    <button type="submit" class="flex-1 px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors">
                        Update Stock
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function showStockModal(itemId, itemName) {
    document.getElementById('modalItemName').textContent = itemName;
    document.getElementById('stockForm').action = `/inventory/items/${itemId}/update-stock`;
    document.getElementById('stockModal').classList.remove('hidden');
}

function closeStockModal() {
    document.getElementById('stockModal').classList.add('hidden');
    document.getElementById('stockForm').reset();
}

// Close modal when clicking outside
document.getElementById('stockModal').addEventListener('click', function(e) {
    if (e.target === this) {
        closeStockModal();
    }
});
</script>
@endsection
