@extends('components.app-layout')

@section('title', 'Edit Event')

@section('content')
@if(session('success'))
    <div class="fixed top-4 right-4 bg-green-500 text-white px-6 py-3 rounded-lg shadow-lg z-50" id="successToast">
        <div class="flex items-center">
            <i class="fas fa-check-circle mr-2"></i>
            {{ session('success') }}
        </div>
    </div>
@endif

@if(session('error'))
    <div class="fixed top-4 right-4 bg-red-500 text-white px-6 py-3 rounded-lg shadow-lg z-50" id="errorToast">
        <div class="flex items-center">
            <i class="fas fa-exclamation-circle mr-2"></i>
            {{ session('error') }}
        </div>
    </div>
@endif

<div class="min-h-screen bg-gradient-to-br from-blue-50 via-blue-100 to-blue-200">
    <div class="max-w-4xl mx-auto px-4 py-8">
        <!-- PCG Header -->
        <div class="relative overflow-hidden bg-gradient-to-r from-blue-900 via-blue-600 to-blue-400 rounded-3xl shadow-2xl mb-8">
            <div class="absolute inset-0 bg-black/10"></div>
            <div class="absolute top-0 right-0 w-64 h-64 bg-white opacity-5 rounded-full transform translate-x-32 -translate-y-32"></div>
            <div class="absolute bottom-0 left-0 w-48 h-48 bg-white opacity-5 rounded-full transform -translate-x-24 translate-y-24"></div>
            
            <div class="relative px-8 py-12">
                <div class="flex items-center justify-between">
                    <div class="flex items-center space-x-4">
                        <div class="w-16 h-16 bg-white/20 backdrop-blur-sm rounded-2xl flex items-center justify-center border border-white/30">
                            <i class="fas fa-edit text-3xl text-white"></i>
                        </div>
                        <div>
                            <h1 class="text-4xl font-bold text-white">Edit Event</h1>
                            <p class="text-blue-100 text-lg">Update event details and information</p>
                        </div>
                    </div>
                    <div class="text-right">
                        <div class="text-sm text-blue-200">Event ID</div>
                        <div class="text-2xl font-bold text-white">#{{ $event->id }}</div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Form Container -->
        <div class="bg-white rounded-3xl shadow-xl border border-gray-100">
            <div class="p-8">
                <form method="POST" action="{{ route('events.update', $event) }}" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')

                    <!-- Basic Information -->
                    <div class="mb-8">
                        <div class="flex items-center space-x-3 mb-6">
                            <div class="w-10 h-10 bg-gradient-to-r from-blue-600 to-blue-400 rounded-xl flex items-center justify-center">
                                <i class="fas fa-info-circle text-white text-sm"></i>
                            </div>
                            <h2 class="text-2xl font-bold text-gray-900">Basic Information</h2>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <!-- Event Title -->
                            <div class="md:col-span-2">
                                <label for="title" class="block text-sm font-medium text-gray-700 mb-2">Event Title *</label>
                                <input type="text" id="title" name="title" value="{{ old('title', $event->title) }}" 
                                       class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors" 
                                       placeholder="Enter event title" required>
                                @error('title')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <!-- Event Type -->
                            <div>
                                <label for="event_type" class="block text-sm font-medium text-gray-700 mb-2">Event Type *</label>
                                <select id="event_type" name="event_type" onchange="toggleServiceType()"
                                        class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors" required>
                                    <option value="">Select event type</option>
                                    <option value="service" {{ old('event_type', $event->event_type) == 'service' ? 'selected' : '' }}>Sunday Church Service</option>
                                    <option value="meeting" {{ old('event_type', $event->event_type) == 'meeting' ? 'selected' : '' }}>Meeting</option>
                                    <option value="conference" {{ old('event_type', $event->event_type) == 'conference' ? 'selected' : '' }}>Conference</option>
                                    <option value="workshop" {{ old('event_type', $event->event_type) == 'workshop' ? 'selected' : '' }}>Workshop</option>
                                    <option value="social" {{ old('event_type', $event->event_type) == 'social' ? 'selected' : '' }}>Social Event</option>
                                    <option value="outreach" {{ old('event_type', $event->event_type) == 'outreach' ? 'selected' : '' }}>Outreach</option>
                                    <option value="fundraising" {{ old('event_type', $event->event_type) == 'fundraising' ? 'selected' : '' }}>Fundraising</option>
                                    <option value="other" {{ old('event_type', $event->event_type) == 'other' ? 'selected' : '' }}>Other</option>
                                </select>
                                @error('event_type')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <!-- Service Type (shown only when event_type is 'service') -->
                            <div id="service_type_section" class="{{ old('event_type', $event->event_type) == 'service' ? '' : 'hidden' }}">
                                <label for="service_type" class="block text-sm font-medium text-gray-700 mb-2">
                                    <i class="fas fa-clock text-blue-600 mr-2"></i>
                                    Service Session *
                                </label>
                                <select id="service_type" name="service_type"
                                        class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors">
                                    <option value="">Select Service Session</option>
                                    <option value="first_service" {{ old('service_type', $event->service_type) == 'first_service' ? 'selected' : '' }}>
                                        1st Service
                                    </option>
                                    <option value="second_service" {{ old('service_type', $event->service_type) == 'second_service' ? 'selected' : '' }}>
                                        2nd Service
                                    </option>
                                    <option value="all_in_one_service" {{ old('service_type', $event->service_type) == 'all_in_one_service' ? 'selected' : '' }}>
                                        All-in-1 Service
                                    </option>
                                </select>
                                @error('service_type')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                                <p class="text-xs text-gray-500 mt-1">
                                    <i class="fas fa-info-circle"></i>
                                    Select the service session for attendance tracking
                                </p>
                            </div>

                            <!-- Status -->
                            <div>
                                <label for="status" class="block text-sm font-medium text-gray-700 mb-2">Status *</label>
                                <select id="status" name="status" 
                                        class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors" required>
                                    <option value="draft" {{ old('status', $event->status) == 'draft' ? 'selected' : '' }}>Draft</option>
                                    <option value="published" {{ old('status', $event->status) == 'published' ? 'selected' : '' }}>Published</option>
                                    <option value="cancelled" {{ old('status', $event->status) == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                                    <option value="completed" {{ old('status', $event->status) == 'completed' ? 'selected' : '' }}>Completed</option>
                                </select>
                                @error('status')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <!-- Description -->
                            <div class="md:col-span-2">
                                <label for="description" class="block text-sm font-medium text-gray-700 mb-2">Description</label>
                                <textarea id="description" name="description" rows="4" 
                                          class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors" 
                                          placeholder="Enter event description">{{ old('description', $event->description) }}</textarea>
                                @error('description')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Date & Time -->
                    <div class="mb-8">
                        <div class="flex items-center space-x-3 mb-6">
                            <div class="w-10 h-10 bg-gradient-to-r from-blue-700 to-blue-500 rounded-xl flex items-center justify-center">
                                <i class="fas fa-clock text-white text-sm"></i>
                            </div>
                            <h2 class="text-2xl font-bold text-gray-900">Date & Time</h2>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <!-- Start Date & Time -->
                            <div>
                                <label for="start_datetime" class="block text-sm font-medium text-gray-700 mb-2">Start Date & Time *</label>
                                <input type="datetime-local" id="start_datetime" name="start_datetime" 
                                       value="{{ old('start_datetime', $event->start_datetime->format('Y-m-d\TH:i')) }}"
                                       class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors" required>
                                @error('start_datetime')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <!-- End Date & Time -->
                            <div>
                                <label for="end_datetime" class="block text-sm font-medium text-gray-700 mb-2">End Date & Time *</label>
                                <input type="datetime-local" id="end_datetime" name="end_datetime" 
                                       value="{{ old('end_datetime', $event->end_datetime->format('Y-m-d\TH:i')) }}"
                                       class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors" required>
                                @error('end_datetime')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <!-- All Day Event -->
                            <div class="md:col-span-2">
                                <div class="flex items-center">
                                    <input type="checkbox" id="is_all_day" name="is_all_day" value="1" 
                                           {{ old('is_all_day', $event->is_all_day) ? 'checked' : '' }}
                                           class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded focus:ring-blue-500">
                                    <label for="is_all_day" class="ml-2 text-sm font-medium text-gray-700">All Day Event</label>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Location & Organization -->
                    <div class="mb-8">
                        <div class="flex items-center space-x-3 mb-6">
                            <div class="w-10 h-10 bg-gradient-to-r from-blue-800 to-blue-600 rounded-xl flex items-center justify-center">
                                <i class="fas fa-map-marker-alt text-white text-sm"></i>
                            </div>
                            <h2 class="text-2xl font-bold text-gray-900">Location & Organization</h2>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <!-- Location -->
                            <div>
                                <label for="location" class="block text-sm font-medium text-gray-700 mb-2">Location</label>
                                <input type="text" id="location" name="location" value="{{ old('location', $event->location) }}"
                                       class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors" 
                                       placeholder="Enter event location">
                                @error('location')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <!-- Ministry -->
                            <div>
                                <label for="ministry_id" class="block text-sm font-medium text-gray-700 mb-2">Ministry</label>
                                <select id="ministry_id" name="ministry_id" 
                                        class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors">
                                    <option value="">Select ministry</option>
                                    @foreach($ministries as $ministry)
                                        <option value="{{ $ministry->id }}" {{ old('ministry_id', $event->ministry_id) == $ministry->id ? 'selected' : '' }}>
                                            {{ $ministry->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('ministry_id')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <!-- Organizer -->
                            <div>
                                <label for="organizer_id" class="block text-sm font-medium text-gray-700 mb-2">Organizer</label>
                                <select id="organizer_id" name="organizer_id" 
                                        class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors">
                                    <option value="">Select organizer</option>
                                    @foreach($members as $member)
                                        <option value="{{ $member->id }}" {{ old('organizer_id', $event->organizer_id) == $member->id ? 'selected' : '' }}>
                                            {{ $member->first_name }} {{ $member->last_name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('organizer_id')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Registration Settings -->
                    <div class="mb-8">
                        <div class="flex items-center space-x-3 mb-6">
                            <div class="w-10 h-10 bg-gradient-to-r from-blue-900 to-blue-700 rounded-xl flex items-center justify-center">
                                <i class="fas fa-user-plus text-white text-sm"></i>
                            </div>
                            <h2 class="text-2xl font-bold text-gray-900">Registration Settings</h2>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <!-- Requires Registration -->
                            <div class="md:col-span-2">
                                <div class="flex items-center">
                                    <input type="checkbox" id="requires_registration" name="requires_registration" value="1" 
                                           {{ old('requires_registration', $event->requires_registration) ? 'checked' : '' }}
                                           class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded focus:ring-blue-500">
                                    <label for="requires_registration" class="ml-2 text-sm font-medium text-gray-700">Requires Registration</label>
                                </div>
                            </div>

                            <!-- Max Attendees -->
                            <div>
                                <label for="max_attendees" class="block text-sm font-medium text-gray-700 mb-2">Maximum Attendees</label>
                                <input type="number" id="max_attendees" name="max_attendees" value="{{ old('max_attendees', $event->max_attendees) }}"
                                       class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors" 
                                       placeholder="Leave empty for unlimited">
                                @error('max_attendees')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <!-- Registration Fee -->
                            <div>
                                <label for="registration_fee" class="block text-sm font-medium text-gray-700 mb-2">Registration Fee (₵)</label>
                                <input type="number" id="registration_fee" name="registration_fee" step="0.01" value="{{ old('registration_fee', $event->registration_fee) }}"
                                       class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors" 
                                       placeholder="0.00">
                                @error('registration_fee')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <!-- Registration Deadline -->
                            <div>
                                <label for="registration_deadline" class="block text-sm font-medium text-gray-700 mb-2">Registration Deadline</label>
                                <input type="datetime-local" id="registration_deadline" name="registration_deadline" 
                                       value="{{ old('registration_deadline', $event->registration_deadline ? $event->registration_deadline->format('Y-m-d\TH:i') : '') }}"
                                       class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors">
                                @error('registration_deadline')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Additional Information -->
                    <div class="mb-8">
                        <div class="flex items-center space-x-3 mb-6">
                            <div class="w-10 h-10 bg-gradient-to-r from-blue-600 to-blue-800 rounded-xl flex items-center justify-center">
                                <i class="fas fa-clipboard-list text-white text-sm"></i>
                            </div>
                            <h2 class="text-2xl font-bold text-gray-900">Additional Information</h2>
                        </div>

                        <div class="space-y-6">
                            <!-- Special Instructions -->
                            <div>
                                <label for="special_instructions" class="block text-sm font-medium text-gray-700 mb-2">Special Instructions</label>
                                <textarea id="special_instructions" name="special_instructions" rows="3" 
                                          class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors" 
                                          placeholder="Any special instructions for attendees">{{ old('special_instructions', $event->special_instructions) }}</textarea>
                                @error('special_instructions')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Action Buttons -->
                    <div class="flex items-center justify-between pt-6 border-t border-gray-200">
                        <a href="{{ route('events.show', $event) }}" 
                           class="px-6 py-3 bg-gray-100 text-gray-700 font-medium rounded-xl hover:bg-gray-200 transition-colors">
                            <i class="fas fa-arrow-left mr-2"></i>
                            Back to Event
                        </a>
                        
                        <div class="flex space-x-4">
                            <a href="{{ route('events.index') }}" 
                               class="px-6 py-3 bg-blue-50 text-blue-700 font-medium rounded-xl hover:bg-blue-100 transition-colors border border-blue-200">
                                Cancel
                            </a>
                            <button type="submit" 
                                    class="px-8 py-3 bg-gradient-to-r from-blue-800 to-blue-600 text-white font-medium rounded-xl hover:from-blue-900 hover:to-blue-700 transition-all duration-300 shadow-lg hover:shadow-xl transform hover:-translate-y-0.5">
                                <i class="fas fa-save mr-2"></i>
                                Update Event
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
// Toggle service type field based on event type selection
function toggleServiceType() {
    const eventType = document.getElementById('event_type').value;
    const serviceTypeSection = document.getElementById('service_type_section');
    const serviceTypeSelect = document.getElementById('service_type');
    
    if (eventType === 'service') {
        serviceTypeSection.classList.remove('hidden');
        serviceTypeSelect.required = true;
    } else {
        serviceTypeSection.classList.add('hidden');
        serviceTypeSelect.required = false;
        serviceTypeSelect.value = '';
    }
}

// Auto-hide toast messages
setTimeout(function() {
    const successToast = document.getElementById('successToast');
    const errorToast = document.getElementById('errorToast');
    if (successToast) successToast.style.display = 'none';
    if (errorToast) errorToast.style.display = 'none';
}, 5000);

// Form validation and enhancements
document.addEventListener('DOMContentLoaded', function() {
    // Check on page load if service type should be shown
    toggleServiceType();
    const startDateTime = document.getElementById('start_datetime');
    const endDateTime = document.getElementById('end_datetime');
    const registrationDeadline = document.getElementById('registration_deadline');
    
    // Auto-set end time when start time changes
    startDateTime.addEventListener('change', function() {
        if (this.value && !endDateTime.value) {
            const startDate = new Date(this.value);
            startDate.setHours(startDate.getHours() + 2); // Default 2 hour duration
            endDateTime.value = startDate.toISOString().slice(0, 16);
        }
        
        // Set registration deadline to 1 day before event
        if (this.value && !registrationDeadline.value) {
            const regDate = new Date(this.value);
            regDate.setDate(regDate.getDate() - 1);
            registrationDeadline.value = regDate.toISOString().slice(0, 16);
        }
    });
    
    // Validate end time is after start time
    endDateTime.addEventListener('change', function() {
        if (startDateTime.value && this.value) {
            if (new Date(this.value) <= new Date(startDateTime.value)) {
                alert('End time must be after start time');
                this.value = '';
            }
        }
    });
});
</script>
@endsection
