<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Welcome to {{ $organizationName }}</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
        }
        .container {
            max-width: 600px;
            margin: 20px auto;
            background: #ffffff;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        }
        .header {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            color: white;
            padding: 40px 20px;
            text-align: center;
        }
        .header h1 {
            margin: 0;
            font-size: 32px;
        }
        .welcome-icon {
            font-size: 64px;
            margin-bottom: 10px;
        }
        .content {
            padding: 40px 30px;
        }
        .success-badge {
            background: #10b981;
            color: white;
            padding: 8px 16px;
            border-radius: 20px;
            display: inline-block;
            font-weight: bold;
            margin: 10px 0;
        }
        .info-box {
            background: #f0fdf4;
            border-left: 4px solid #10b981;
            padding: 20px;
            margin: 20px 0;
            border-radius: 4px;
        }
        .info-row {
            margin: 10px 0;
        }
        .info-label {
            font-weight: bold;
            color: #666;
            display: inline-block;
            width: 140px;
        }
        .highlight-box {
            background: linear-gradient(135deg, #2563eb15 0%, #dc262615 100%);
            padding: 20px;
            border-radius: 8px;
            margin: 20px 0;
        }
        .action-button {
            display: inline-block;
            padding: 12px 30px;
            background: linear-gradient(135deg, #2563eb 0%, #dc2626 100%);
            color: white;
            text-decoration: none;
            border-radius: 8px;
            font-weight: bold;
            margin: 10px 0;
        }
        .footer {
            background: #f8f9fa;
            padding: 20px;
            text-align: center;
            color: #666;
            font-size: 14px;
        }
        ul {
            margin: 10px 0;
            padding-left: 20px;
        }
        ul li {
            margin: 8px 0;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div class="welcome-icon">🎉</div>
            <h1>Welcome to Our Family!</h1>
        </div>
        
        <div class="content">
            <h2>Dear {{ $member->full_name }},</h2>
            
            <div class="success-badge">✓ REGISTERED</div>
            
            <p>We are absolutely delighted to welcome you as an official member of <strong>{{ $organizationName }}</strong>!</p>
            
            <p>Your membership registration has been completed successfully by our church administration. You are now part of our growing family of believers, and we look forward to walking with you on this spiritual journey.</p>
            
            <div class="info-box">
                <h3 style="margin-top: 0; color: #10b981;">Your Membership Details</h3>
                <div class="info-row">
                    <span class="info-label">Member ID:</span>
                    <span><strong>{{ $member->member_id ?? 'Will be assigned soon' }}</strong></span>
                </div>
                <div class="info-row">
                    <span class="info-label">Full Name:</span>
                    <span>{{ $member->full_name }}</span>
                </div>
                <div class="info-row">
                    <span class="info-label">Membership Type:</span>
                    <span class="capitalize">{{ str_replace('_', ' ', $member->membership_type ?? 'Member') }}</span>
                </div>
                <div class="info-row">
                    <span class="info-label">Registration Date:</span>
                    <span>{{ now()->format('F d, Y') }}</span>
                </div>
                <div class="info-row">
                    <span class="info-label">Status:</span>
                    <span style="color: #10b981; font-weight: bold;">✓ Active</span>
                </div>
                @if($member->email)
                <div class="info-row">
                    <span class="info-label">Email:</span>
                    <span>{{ $member->email }}</span>
                </div>
                @endif
                @if($member->phone)
                <div class="info-row">
                    <span class="info-label">Phone:</span>
                    <span>{{ $member->phone }}</span>
                </div>
                @endif
            </div>
            
            <div class="highlight-box">
                <h3 style="margin-top: 0; color: #2563eb;">What's Next? Your Journey Begins Here!</h3>
                <ul>
                    <li><strong>🙏 Worship Services:</strong> Join us every Sunday and for special services throughout the week</li>
                    <li><strong>📖 Bible Study:</strong> Grow in faith through our Bible study groups and discipleship programs</li>
                    <li><strong>🤝 Connect & Fellowship:</strong> Meet other members and join fellowship groups that interest you</li>
                    <li><strong>💝 Serve & Give:</strong> Discover your gifts and find opportunities to serve in various ministries</li>
                    <li><strong>📅 Stay Updated:</strong> Receive newsletters, SMS updates, and event announcements</li>
                    <li><strong>👥 Family Integration:</strong> Get integrated into the church family and community</li>
                </ul>
            </div>
            
            <div style="background: #dbeafe; border-left: 4px solid #2563eb; padding: 15px; border-radius: 4px; margin: 20px 0;">
                <p style="margin: 0; color: #1e40af;">
                    <strong>📞 Need Assistance?</strong> Our church office is always ready to help! If you have any questions about programs, events, or how to get involved, please don't hesitate to reach out to us.
                </p>
            </div>
            
            <div style="background: #fef3c7; border-left: 4px solid #f59e0b; padding: 15px; border-radius: 4px; margin: 20px 0;">
                <p style="margin: 0; color: #92400e;">
                    <strong>🔐 Online Access:</strong> If you'd like to access our member portal, please contact the church office to receive your login credentials. You'll be able to update your information, view giving history, and access exclusive member resources.
                </p>
            </div>
            
            <p style="font-style: italic; color: #666; border-left: 3px solid #10b981; padding-left: 15px; margin: 30px 0;">
                "Therefore, as God's chosen people, holy and dearly loved, clothe yourselves with compassion, kindness, humility, gentleness and patience." - Colossians 3:12
            </p>
            
            <p>Thank you for choosing to be part of our spiritual family. May God's grace, love, and blessings be upon you as you begin this wonderful journey with us!</p>
            
            <p><strong>Welcome home! We're so glad you're here!</strong></p>
            
            <p style="margin-top: 30px;">
                With blessings,<br>
                <strong>{{ $organizationName }}</strong><br>
                Church Administration
            </p>
        </div>
        
        <div class="footer">
            <p><strong>{{ $organizationName }}</strong></p>
            <p>🙏 You are now an official member of our family!</p>
            <p style="font-size: 12px; color: #999; margin-top: 10px;">
                This is an automated message. Please do not reply to this email.
            </p>
        </div>
    </div>
</body>
</html>
