<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Membership Approved</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
        }
        .container {
            max-width: 600px;
            margin: 20px auto;
            background: #ffffff;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        }
        .header {
            background: linear-gradient(135deg,rgb(185, 16, 16) 0%,rgb(218, 7, 7) 100%);
            color: white;
            padding: 40px 20px;
            text-align: center;
        }
        .header h1 {
            margin: 0;
            font-size: 32px;
        }
        .welcome-icon {
            font-size: 64px;
            margin-bottom: 10px;
        }
        .content {
            padding: 40px 30px;
        }
        .info-box {
            background: #f0fdf4;
            border-left: 4px solid #10b981;
            padding: 20px;
            margin: 20px 0;
            border-radius: 4px;
        }
        .info-row {
            margin: 10px 0;
        }
        .info-label {
            font-weight: bold;
            color: #666;
            display: inline-block;
            width: 120px;
        }
        .highlight {
            background: linear-gradient(135deg, #2563eb15 0%, #dc262615 100%);
            padding: 20px;
            border-radius: 8px;
            margin: 20px 0;
        }
        .success-badge {
            background: #10b981;
            color: white;
            padding: 8px 16px;
            border-radius: 20px;
            display: inline-block;
            font-weight: bold;
            margin: 10px 0;
        }
        .footer {
            background: #f8f9fa;
            padding: 20px;
            text-align: center;
            color: #666;
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div class="welcome-icon">🎉</div>
            <h1>Welcome to {{ $organizationName }}</h1>
            <p style="font-size: 18px; margin: 10px 0 0 0; font-style: italic; opacity: 0.95;">{{ $congregationSlogan }}</p>
        </div>
        
        <div class="content">
            <h2>Congratulations, {{ $member->full_name }}!</h2>
            
            <div class="success-badge">✓ APPROVED</div>
            
            <p>We are delighted to inform you that your membership application has been <strong>approved</strong>! Welcome to the Presbyterian Church of Ghana (PCG) - {{ $organizationName }} family!</p>
            
            <p style="color: #059669; font-weight: bold; font-size: 18px; margin: 15px 0;">🎊 You are now an official member of our congregation!</p>
            
            <div class="info-box">
                <h3 style="margin-top: 0; color: #10b981;">Your Membership Details</h3>
                <div class="info-row">
                    <span class="info-label">Member ID:</span>
                    <span><strong>{{ $member->member_id ?? 'Will be assigned' }}</strong></span>
                </div>
                <div class="info-row">
                    <span class="info-label">Full Name:</span>
                    <span>{{ $member->full_name }}</span>
                </div>
                <div class="info-row">
                    <span class="info-label">Membership Type:</span>
                    <span class="capitalize">{{ str_replace('_', ' ', $member->membership_type) }}</span>
                </div>
                <div class="info-row">
                    <span class="info-label">Status:</span>
                    <span style="color: #10b981; font-weight: bold;">✓ Active</span>
                </div>
                <div class="info-row">
                    <span class="info-label">Email:</span>
                    <span>{{ $member->email }}</span>
                </div>
                <div class="info-row">
                    <span class="info-label">Phone:</span>
                    <span>{{ $member->phone }}</span>
                </div>
                <div class="info-row">
                    <span class="info-label">Approval Date:</span>
                    <span>{{ now()->format('F d, Y') }}</span>
                </div>
            </div>
            
            @if($password)
            <div style="background: linear-gradient(135deg, #3b82f6 0%, #1e40af 100%); color: white; padding: 25px; border-radius: 10px; margin: 25px 0; box-shadow: 0 4px 6px rgba(0,0,0,0.1);">
                <h3 style="margin-top: 0; color: white; font-size: 20px;">🔐 Your Member Dashboard Login Credentials</h3>
                <p style="margin: 15px 0; font-size: 15px;">You now have access to the PCG, Monninger Congregation, Akosombo Member Portal where you can:</p>
                <ul style="margin: 10px 0 15px 20px; font-size: 14px; line-height: 1.8;">
                    <li>View your member profile and payment history</li>
                    <li>Update your personal information</li>
                    <li>Register for church programs and events</li>
                    <li>Submit prayer requests and testimonies</li>
                    <li>Access church resources and announcements</li>
                </ul>
                
                <div style="background: rgba(255,255,255,0.15); padding: 20px; border-radius: 8px; margin: 20px 0; border: 2px solid rgba(255,255,255,0.3);">
                    <div style="margin: 10px 0;">
                        <strong style="display: block; font-size: 13px; opacity: 0.9; margin-bottom: 5px;">📧 Username/Email:</strong>
                        <span style="font-size: 16px; font-family: 'Courier New', monospace; background: rgba(0,0,0,0.2); padding: 8px 12px; border-radius: 4px; display: inline-block;">{{ $member->email }}</span>
                    </div>
                    <div style="margin: 10px 0;">
                        <strong style="display: block; font-size: 13px; opacity: 0.9; margin-bottom: 5px;">🔑 Temporary Password:</strong>
                        <span style="font-size: 18px; font-family: 'Courier New', monospace; background: rgba(0,0,0,0.2); padding: 8px 12px; border-radius: 4px; display: inline-block; letter-spacing: 1px;">{{ $password }}</span>
                    </div>
                    <div style="margin: 10px 0;">
                        <strong style="display: block; font-size: 13px; opacity: 0.9; margin-bottom: 5px;">🌐 Login URL:</strong>
                        <a href="{{ $loginUrl }}" style="font-size: 14px; color: #fef3c7; text-decoration: underline; word-break: break-all;">{{ $loginUrl }}</a>
                    </div>
                </div>
                
                <div style="background: #fef3c7; color: #92400e; padding: 15px; border-radius: 6px; margin-top: 15px; font-size: 13px; border-left: 4px solid #f59e0b;">
                    <strong>⚠️ Important Security Notice:</strong>
                    <ul style="margin: 8px 0 0 20px; line-height: 1.6;">
                        <li>Please change this temporary password after your first login</li>
                        <li>Keep your login credentials secure and confidential</li>
                        <li>Never share your password with anyone</li>
                        <li>If you experience any login issues, contact the church office</li>
                    </ul>
                </div>
                
                <div style="text-align: center; margin-top: 20px;">
                    <a href="{{ $loginUrl }}" style="display: inline-block; background: white; color: #1e40af; padding: 15px 40px; text-decoration: none; border-radius: 8px; font-weight: bold; font-size: 16px; box-shadow: 0 2px 4px rgba(0,0,0,0.2);">Login to Member Portal →</a>
                </div>
            </div>
            @endif
            
            <div class="highlight">
                <h3 style="margin-top: 0; color: #2563eb;">What's Next?</h3>
                <ul style="margin: 10px 0;">
                    <li><strong>Login to Portal:</strong> Access your member dashboard with the credentials above</li>
                    <li><strong>Join Us:</strong> Attend our weekly services and programs</li>
                    <li><strong>Get Involved:</strong> Connect with our ministries and fellowship groups</li>
                    <li><strong>Stay Connected:</strong> Check your email for newsletters and announcements</li>
                    <li><strong>Participate:</strong> Engage in church activities and events</li>
                    <li><strong>Grow:</strong> Join Bible study groups and spiritual growth programs</li>
                </ul>
            </div>
            
          
            <p style="font-style: italic; color: #666; border-left: 3px solidrgb(191, 9, 9); padding-left: 15px;">
                "Therefore, as God's chosen people, holy and dearly loved, clothe yourselves with compassion, kindness, humility, gentleness and patience." - Colossians 3:12
            </p>
            
            <p>We are thrilled to have you as part of the PCG, Monninger Congregation, Akosombo. May God bless you abundantly as you journey with us in faith, fellowship, and service!</p>
            
          
            <p style="font-style: italic; color: #666;">Asomdwoe Nka Wo</p>
        </div>
        
        <div class="footer">
            <p><strong>{{ $organizationName }}</strong></p>
            <p>God bless you</p>
        </div>
    </div>
</body>
</html>
