<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Absentees Report</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; margin: 0; padding: 0; background-color: #f4f4f4; }
        .container { max-width: 700px; margin: 20px auto; background: #ffffff; border-radius: 10px; overflow: hidden; box-shadow: 0 4px 6px rgba(0,0,0,0.1); }
        .header { background: linear-gradient(135deg, #2563eb 0%, #dc2626 100%); color: white; padding: 30px 20px; text-align: center; }
        .header h1 { margin: 0; font-size: 28px; }
        .content { padding: 30px; }
        .stats-box { background: linear-gradient(135deg, #2563eb15 0%, #dc262615 100%); border-left: 4px solid #2563eb; padding: 20px; margin: 20px 0; border-radius: 4px; }
        .stat-row { display: flex; justify-content: space-between; padding: 8px 0; }
        .absentee-list { background: #f8f9fa; padding: 15px; border-radius: 4px; margin: 20px 0; max-height: 400px; overflow-y: auto; }
        .absentee-item { padding: 10px; border-bottom: 1px solid #dee2e6; display: flex; justify-content: space-between; }
        .absentee-item:last-child { border-bottom: none; }
        .footer { background: #f8f9fa; padding: 20px; text-align: center; color: #666; font-size: 14px; }
        table { width: 100%; border-collapse: collapse; margin: 15px 0; }
        th, td { padding: 10px; text-align: left; border-bottom: 1px solid #dee2e6; }
        th { background: #2563eb; color: white; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>📋 Absentees Report</h1>
        </div>
        
        <div class="content">
            <h2>{{ $event->title }}</h2>
            <p><strong>Date:</strong> {{ $event->start_datetime->format('F d, Y h:i A') }}</p>
            <p><strong>Location:</strong> {{ $event->location ?? 'Church Premises' }}</p>
            
            <div class="stats-box">
                <h3 style="margin-top: 0; color: #2563eb;">Attendance Summary</h3>
                <div class="stat-row">
                    <strong>Total Active Members:</strong>
                    <span>{{ $total_members }}</span>
                </div>
                <div class="stat-row">
                    <strong>Members Present:</strong>
                    <span style="color: #16a34a;">{{ $attended_count }}</span>
                </div>
                <div class="stat-row">
                    <strong>Members Absent:</strong>
                    <span style="color: #dc2626;">{{ $absentees->count() }}</span>
                </div>
                <div class="stat-row">
                    <strong>Attendance Rate:</strong>
                    <span>{{ $total_members > 0 ? round(($attended_count / $total_members) * 100, 1) : 0 }}%</span>
                </div>
            </div>
            
            <h3>Absentees List ({{ $absentees->count() }} members)</h3>
            
            @if($absentees->count() > 0)
            <table>
                <thead>
                    <tr>
                        <th>Member ID</th>
                        <th>Name</th>
                        <th>Phone</th>
                        <th>Email</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($absentees as $absentee)
                    <tr>
                        <td>{{ $absentee->member_id }}</td>
                        <td>{{ $absentee->full_name }}</td>
                        <td>{{ $absentee->phone ?? 'N/A' }}</td>
                        <td>{{ $absentee->email ?? 'N/A' }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            @else
            <p style="text-align: center; color: #16a34a; font-size: 18px;">🎉 Perfect Attendance! All members were present.</p>
            @endif
        </div>
        
        <div class="footer">
            <p>Generated on {{ now()->format('F d, Y h:i A') }}</p>
            <p style="font-size: 12px; color: #999;">
                This is an automated report from the church management system.
            </p>
        </div>
    </div>
</body>
</html>
