<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ \App\Models\Setting::getValue('organization_name', 'general', 'Presbyterian Church of Ghana') }} - Admin Login</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <!-- Alpine.js -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    
    <style>
        [x-cloak] { display: none !important; }
        
        .login-bg {
            @php
                $backgroundImage = \App\Models\Setting::getValue('login_background_image', 'general');
            @endphp
            @if($backgroundImage)
                background-image: url('{{ asset('storage/' . $backgroundImage) }}');
            @else
                background: linear-gradient(135deg, #2563eb 0%, #dc2626 100%);
            @endif
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
        }
        
        .glass-card {
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            box-shadow: 0 25px 45px rgba(0, 0, 0, 0.1);
        }
        
        .input-glass {
            background: rgba(255, 255, 255, 0.9);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.3);
        }
        
        .btn-gradient {
            background: linear-gradient(135deg, #2563eb 0%, #dc2626 100%);
            transition: all 0.3s ease;
        }
        
        .btn-gradient:hover {
            transform: translateY(-2px);
            box-shadow: 0 15px 30px rgba(37, 99, 235, 0.4);
        }
        
        .floating-animation {
            animation: float 6s ease-in-out infinite;
        }
        
        @keyframes float {
            0%, 100% { transform: translateY(0px) rotate(0deg); }
            50% { transform: translateY(-20px) rotate(5deg); }
        }
        
        .slide-up {
            animation: slideUp 0.8s ease-out;
        }
        
        @keyframes slideUp {
            0% { transform: translateY(50px); opacity: 0; }
            100% { transform: translateY(0); opacity: 1; }
        }
    </style>
</head>

<body class="font-sans antialiased min-h-screen login-bg relative overflow-hidden">
    <!-- Background Overlay -->
    <div class="absolute inset-0 bg-black bg-opacity-40"></div>
    
    <!-- Floating Decorative Elements -->
    <div class="absolute inset-0 overflow-hidden pointer-events-none">
        <div class="absolute top-1/4 left-1/4 w-64 h-64 bg-white opacity-5 rounded-full floating-animation"></div>
        <div class="absolute top-3/4 right-1/4 w-48 h-48 bg-white opacity-5 rounded-full floating-animation" style="animation-delay: -2s;"></div>
        <div class="absolute top-1/2 right-1/3 w-32 h-32 bg-white opacity-5 rounded-full floating-animation" style="animation-delay: -4s;"></div>
    </div>

    <div class="min-h-screen flex items-center justify-center px-4 py-8 relative z-10">
        <div class="w-full max-w-md slide-up">
            <!-- Logo and Header -->
            <div class="text-center mb-8">
                @php
                    $orgLogo = \App\Models\Setting::getValue('organization_logo', 'general');
                    $orgName = \App\Models\Setting::getValue('organization_name', 'general', 'Presbyterian Church of Ghana');
                    $orgSlogan = \App\Models\Setting::getValue('organization_slogan', 'general', 'Church Management System');
                @endphp
                
                <div class="inline-flex items-center justify-center w-20 h-20 glass-card rounded-full mb-6 floating-animation">
                    @if($orgLogo)
                        <img src="{{ asset('storage/' . $orgLogo) }}" alt="{{ $orgName }} Logo" class="w-16 h-16 object-contain rounded-full">
                    @else
                        <i class="fas fa-church text-3xl text-white"></i>
                    @endif
                </div>
                <h1 class="text-4xl font-bold text-white mb-3 drop-shadow-lg">{{ $orgName }}</h1>
                <p class="text-white/90 text-lg drop-shadow">{{ $orgSlogan }}</p>
                <p class="text-white/70 text-sm mt-2">Admin Portal</p>
            </div>
            
            <!-- Login Card -->
            <div class="glass-card rounded-3xl p-8 shadow-2xl">
                @if (session('status'))
                    <div class="mb-6 p-4 bg-green-500/20 border border-green-400/30 rounded-2xl backdrop-blur-sm">
                        <div class="flex items-center text-green-100">
                            <i class="fas fa-check-circle mr-3"></i>
                            <p class="font-medium">{{ session('status') }}</p>
                        </div>
                    </div>
                @endif
                
                @if ($errors->any())
                    <div class="mb-6 p-4 bg-red-500/20 border border-red-400/30 rounded-2xl backdrop-blur-sm">
                        <div class="flex items-start text-red-100">
                            <i class="fas fa-exclamation-triangle mr-3 mt-0.5"></i>
                            <div>
                                <p class="font-medium mb-2">Please fix the following errors:</p>
                                <ul class="space-y-1 text-sm">
                                    @foreach ($errors->all() as $error)
                                        <li class="flex items-center">
                                            <i class="fas fa-dot-circle text-xs mr-2"></i>
                                            {{ $error }}
                                        </li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                    </div>
                @endif
                
                <form method="POST" action="{{ route('login') }}" class="space-y-6" x-data="{ showPassword: false }">
                    @csrf
                    
                    <!-- Email Field -->
                    <div class="space-y-2">
                        <label for="email" class="block text-sm font-semibold text-white/90">Email Address</label>
                        <div class="relative">
                            <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                                <i class="fas fa-envelope text-gray-500"></i>
                            </div>
                            <input id="email" name="email" type="email" value="{{ old('email') }}" required autofocus 
                                   class="input-glass block w-full pl-12 pr-4 py-4 rounded-2xl focus:outline-none focus:ring-4 focus:ring-white/20 text-gray-900 placeholder-gray-500 transition-all duration-300"
                                   placeholder="Enter your email address">
                        </div>
                    </div>
                    
                    <!-- Password Field -->
                    <div class="space-y-2">
                        <label for="password" class="block text-sm font-semibold text-white/90">Password</label>
                        <div class="relative">
                            <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                                <i class="fas fa-lock text-gray-500"></i>
                            </div>
                            <input id="password" name="password" :type="showPassword ? 'text' : 'password'" required 
                                   class="input-glass block w-full pl-12 pr-12 py-4 rounded-2xl focus:outline-none focus:ring-4 focus:ring-white/20 text-gray-900 placeholder-gray-500 transition-all duration-300"
                                   placeholder="Enter your password">
                            <button type="button" @click="showPassword = !showPassword" 
                                    class="absolute inset-y-0 right-0 pr-4 flex items-center text-gray-500 hover:text-gray-700 transition-colors">
                                <i :class="showPassword ? 'fas fa-eye-slash' : 'fas fa-eye'"></i>
                            </button>
                        </div>
                    </div>
                    
                    <!-- Remember Me and Forgot Password -->
                    <div class="flex items-center justify-between">
                        <label class="flex items-center">
                            <input id="remember_me" name="remember" type="checkbox" 
                                   class="h-5 w-5 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                            <span class="ml-3 text-sm font-medium text-white/90">Remember me</span>
                        </label>
                        
                        @if (Route::has('password.request'))
                            <a href="{{ route('password.request') }}" class="text-sm font-semibold text-white/80 hover:text-white transition-colors">
                                Forgot password?
                            </a>
                        @endif
                    </div>
                    
                    <!-- Sign In Button -->
                    <button type="submit" class="btn-gradient w-full py-4 px-6 text-white font-semibold rounded-2xl focus:outline-none focus:ring-4 focus:ring-white/20 transition-all duration-300">
                        <span class="flex items-center justify-center">
                            <i class="fas fa-sign-in-alt mr-3"></i>
                            Sign In to Admin Portal
                        </span>
                    </button>
                </form>
                
                <!-- Member Login Link -->
                <div class="mt-8 text-center">
                    <p class="text-white/70 text-sm">
                        Are you a church member? 
                        <a href="{{ route('member.login') }}" class="font-semibold text-white/90 hover:text-white transition-colors">
                            Member Login
                        </a>
                    </p>
                </div>
            </div>
            
            <!-- Footer -->
            <div class="mt-8 text-center">
                <p class="text-white/60 text-sm">
                    &copy; {{ date('Y') }} {{ $orgName }}. All rights reserved.
                </p>
            </div>
        </div>
    </div>
</body>
</html>
