@extends('components.app-layout')

@section('title', $announcement->title)
@section('subtitle', 'Announcement Details')

@section('content')
<div class="min-h-screen bg-gradient-to-br from-blue-50 via-indigo-50 to-purple-50 py-8">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        
        <!-- Header with Actions -->
        <div class="flex flex-col lg:flex-row justify-between items-start lg:items-center gap-6 mb-8">
            <div class="flex items-center space-x-4">
                <a href="{{ route('announcements.index') }}" class="w-12 h-12 bg-white/80 backdrop-blur-sm rounded-2xl flex items-center justify-center shadow-lg hover:shadow-xl transition-all duration-300 border border-gray-200/50 hover:border-blue-300">
                    <i class="fas fa-arrow-left text-gray-600 hover:text-blue-600 transition-colors"></i>
                </a>
                <div>
                    <h1 class="text-3xl font-bold bg-gradient-to-r from-blue-600 via-purple-600 to-pink-600 bg-clip-text text-transparent">{{ $announcement->title }}</h1>
                    <p class="text-gray-600 mt-1">Published {{ $announcement->publish_date->format('M j, Y \\a\\t g:i A') }}</p>
                </div>
            </div>

            <div class="flex flex-wrap gap-3">
                <a href="{{ route('announcements.edit', $announcement) }}" class="inline-flex items-center px-4 py-2 bg-gradient-to-r from-blue-500 to-indigo-500 text-white font-medium rounded-xl hover:from-blue-600 hover:to-indigo-600 transition-all duration-200 shadow-lg hover:shadow-xl">
                    <i class="fas fa-edit mr-2"></i>
                    Edit
                </a>
                
                <button onclick="sendNotifications()" class="inline-flex items-center px-4 py-2 bg-gradient-to-r from-green-500 to-teal-500 text-white font-medium rounded-xl hover:from-green-600 hover:to-teal-600 transition-all duration-200 shadow-lg hover:shadow-xl">
                    <i class="fas fa-paper-plane mr-2"></i>
                    Send Notifications
                </button>

                <button onclick="deleteAnnouncement()" class="inline-flex items-center px-4 py-2 bg-gradient-to-r from-red-500 to-pink-500 text-white font-medium rounded-xl hover:from-red-600 hover:to-pink-600 transition-all duration-200 shadow-lg hover:shadow-xl">
                    <i class="fas fa-trash mr-2"></i>
                    Delete
                </button>
            </div>
        </div>

        <!-- Status and Priority Badges -->
        <div class="flex flex-wrap gap-4 mb-8">
            @php
                $statusColors = [
                    'published' => 'bg-green-100 text-green-800 border-green-200',
                    'draft' => 'bg-yellow-100 text-yellow-800 border-yellow-200',
                    'expired' => 'bg-red-100 text-red-800 border-red-200',
                    'archived' => 'bg-gray-100 text-gray-800 border-gray-200'
                ];
                $priorityColors = [
                    'low' => 'bg-blue-100 text-blue-800 border-blue-200',
                    'medium' => 'bg-yellow-100 text-yellow-800 border-yellow-200',
                    'high' => 'bg-orange-100 text-orange-800 border-orange-200',
                    'urgent' => 'bg-red-100 text-red-800 border-red-200'
                ];
                $typeColors = [
                    'general' => 'bg-gray-100 text-gray-800 border-gray-200',
                    'event' => 'bg-blue-100 text-blue-800 border-blue-200',
                    'prayer_request' => 'bg-purple-100 text-purple-800 border-purple-200',
                    'urgent' => 'bg-red-100 text-red-800 border-red-200',
                    'celebration' => 'bg-pink-100 text-pink-800 border-pink-200',
                    'ministry' => 'bg-indigo-100 text-indigo-800 border-indigo-200'
                ];
            @endphp
            
            <span class="inline-flex items-center px-4 py-2 rounded-2xl text-sm font-semibold border {{ $statusColors[$announcement->status] ?? 'bg-gray-100 text-gray-800 border-gray-200' }}">
                <i class="fas fa-circle mr-2 text-xs"></i>
                {{ ucfirst($announcement->status) }}
            </span>
            
            <span class="inline-flex items-center px-4 py-2 rounded-2xl text-sm font-semibold border {{ $priorityColors[$announcement->priority] ?? 'bg-gray-100 text-gray-800 border-gray-200' }}">
                <i class="fas fa-flag mr-2"></i>
                {{ ucfirst($announcement->priority) }} Priority
            </span>
            
            <span class="inline-flex items-center px-4 py-2 rounded-2xl text-sm font-semibold border {{ $typeColors[$announcement->type] ?? 'bg-gray-100 text-gray-800 border-gray-200' }}">
                <i class="fas fa-tag mr-2"></i>
                {{ ucfirst(str_replace('_', ' ', $announcement->type)) }}
            </span>
        </div>

        <!-- Main Content -->
        <div class="bg-white/80 backdrop-blur-xl rounded-3xl shadow-xl border border-white/30 p-8 mb-8">
            @if($announcement->image_path)
                <div class="mb-6">
                    <img src="{{ asset('storage/' . $announcement->image_path) }}" alt="{{ $announcement->title }}" class="w-full h-64 object-cover rounded-2xl shadow-lg">
                </div>
            @endif

            <div class="prose prose-lg max-w-none">
                {!! nl2br(e($announcement->content)) !!}
            </div>

            @if($announcement->attachment_path)
                <div class="mt-6 pt-6 border-t border-gray-200">
                    <div class="flex items-center space-x-3">
                        <div class="w-10 h-10 bg-gradient-to-r from-blue-500 to-indigo-500 rounded-xl flex items-center justify-center">
                            <i class="fas fa-paperclip text-white"></i>
                        </div>
                        <div>
                            <p class="text-sm font-semibold text-gray-800">Attachment</p>
                            <a href="{{ asset('storage/' . $announcement->attachment_path) }}" target="_blank" class="text-blue-600 hover:text-blue-800 text-sm">
                                Download File
                            </a>
                        </div>
                    </div>
                </div>
            @endif
        </div>

        <!-- Announcement Details -->
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 mb-8">
            <!-- Publishing Details -->
            <div class="bg-white/80 backdrop-blur-xl rounded-3xl shadow-xl border border-white/30 p-6">
                <div class="flex items-center mb-4">
                    <div class="w-10 h-10 bg-gradient-to-r from-blue-500 to-indigo-500 rounded-2xl flex items-center justify-center mr-3">
                        <i class="fas fa-calendar text-white"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900">Publishing Details</h3>
                </div>
                
                <div class="space-y-3">
                    <div class="flex justify-between">
                        <span class="text-gray-600">Created:</span>
                        <span class="font-medium">{{ $announcement->created_at->format('M j, Y g:i A') }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-600">Published:</span>
                        <span class="font-medium">{{ $announcement->publish_date->format('M j, Y g:i A') }}</span>
                    </div>
                    @if($announcement->expire_date)
                        <div class="flex justify-between">
                            <span class="text-gray-600">Expires:</span>
                            <span class="font-medium">{{ $announcement->expire_date->format('M j, Y g:i A') }}</span>
                        </div>
                    @endif
                    <div class="flex justify-between">
                        <span class="text-gray-600">Views:</span>
                        <span class="font-medium">{{ $announcement->view_count ?? 0 }}</span>
                    </div>
                </div>
            </div>

            <!-- Distribution Settings -->
            <div class="bg-white/80 backdrop-blur-xl rounded-3xl shadow-xl border border-white/30 p-6">
                <div class="flex items-center mb-4">
                    <div class="w-10 h-10 bg-gradient-to-r from-green-500 to-teal-500 rounded-2xl flex items-center justify-center mr-3">
                        <i class="fas fa-share-alt text-white"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900">Distribution</h3>
                </div>
                
                <div class="space-y-3">
                    <div class="flex items-center justify-between">
                        <span class="text-gray-600">Email Notifications:</span>
                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium {{ $announcement->send_email ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">
                            <i class="fas fa-{{ $announcement->send_email ? 'check' : 'times' }} mr-1"></i>
                            {{ $announcement->send_email ? 'Enabled' : 'Disabled' }}
                        </span>
                    </div>
                    <div class="flex items-center justify-between">
                        <span class="text-gray-600">SMS Notifications:</span>
                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium {{ $announcement->send_sms ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">
                            <i class="fas fa-{{ $announcement->send_sms ? 'check' : 'times' }} mr-1"></i>
                            {{ $announcement->send_sms ? 'Enabled' : 'Disabled' }}
                        </span>
                    </div>
                    <div class="flex items-center justify-between">
                        <span class="text-gray-600">Website Display:</span>
                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium {{ $announcement->display_on_website ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">
                            <i class="fas fa-{{ $announcement->display_on_website ? 'check' : 'times' }} mr-1"></i>
                            {{ $announcement->display_on_website ? 'Enabled' : 'Disabled' }}
                        </span>
                    </div>
                    <div class="flex items-center justify-between">
                        <span class="text-gray-600">Digital Screens:</span>
                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium {{ $announcement->display_on_screens ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">
                            <i class="fas fa-{{ $announcement->display_on_screens ? 'check' : 'times' }} mr-1"></i>
                            {{ $announcement->display_on_screens ? 'Enabled' : 'Disabled' }}
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Target Audience -->
        @if($announcement->target_audience && count($announcement->target_audience) > 0)
            <div class="bg-white/80 backdrop-blur-xl rounded-3xl shadow-xl border border-white/30 p-6 mb-8">
                <div class="flex items-center mb-4">
                    <div class="w-10 h-10 bg-gradient-to-r from-purple-500 to-pink-500 rounded-2xl flex items-center justify-center mr-3">
                        <i class="fas fa-users text-white"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900">Target Audience</h3>
                </div>
                
                <div class="flex flex-wrap gap-2">
                    @foreach($announcement->target_audience as $audience)
                        <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-purple-100 text-purple-800">
                            {{ ucfirst(str_replace('_', ' ', $audience)) }}
                        </span>
                    @endforeach
                </div>
            </div>
        @endif

        <!-- Notes -->
        @if($announcement->notes)
            <div class="bg-white/80 backdrop-blur-xl rounded-3xl shadow-xl border border-white/30 p-6 mb-8">
                <div class="flex items-center mb-4">
                    <div class="w-10 h-10 bg-gradient-to-r from-gray-500 to-gray-600 rounded-2xl flex items-center justify-center mr-3">
                        <i class="fas fa-sticky-note text-white"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900">Internal Notes</h3>
                </div>
                
                <p class="text-gray-700">{{ $announcement->notes }}</p>
            </div>
        @endif

        <!-- Creator Information -->
        @if($announcement->creator)
            <div class="bg-white/80 backdrop-blur-xl rounded-3xl shadow-xl border border-white/30 p-6">
                <div class="flex items-center mb-4">
                    <div class="w-10 h-10 bg-gradient-to-r from-indigo-500 to-purple-500 rounded-2xl flex items-center justify-center mr-3">
                        <i class="fas fa-user text-white"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900">Created By</h3>
                </div>
                
                <div class="flex items-center space-x-3">
                    <div class="w-12 h-12 bg-gradient-to-r from-blue-500 to-purple-500 rounded-full flex items-center justify-center">
                        <span class="text-white font-semibold">{{ substr($announcement->creator->name, 0, 1) }}</span>
                    </div>
                    <div>
                        <p class="font-semibold text-gray-900">{{ $announcement->creator->name }}</p>
                        <p class="text-sm text-gray-600">{{ $announcement->creator->email }}</p>
                    </div>
                </div>
            </div>
        @endif
    </div>
</div>

<script>
function sendNotifications() {
    if (confirm('Are you sure you want to send notifications for this announcement?')) {
        fetch(`/announcements/{{ $announcement->id }}/send-notifications`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Content-Type': 'application/json',
            },
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('Notifications sent successfully!');
            } else {
                alert('Failed to send notifications. Please try again.');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('An error occurred. Please try again.');
        });
    }
}

function deleteAnnouncement() {
    if (confirm('Are you sure you want to delete this announcement? This action cannot be undone.')) {
        fetch(`/announcements/{{ $announcement->id }}`, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Content-Type': 'application/json',
            },
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('Announcement deleted successfully!');
                window.location.href = '{{ route("announcements.index") }}';
            } else {
                alert('Failed to delete announcement. Please try again.');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('An error occurred. Please try again.');
        });
    }
}
</script>
@endsection