@extends('components.app-layout')

@section('title', 'Create Announcement')
@section('subtitle', 'Create a new church announcement')

@section('content')
<div class="min-h-screen bg-gradient-to-br from-blue-50 via-indigo-50 to-purple-50 py-8">
    <div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="text-center mb-8">
            <div class="w-20 h-20 bg-gradient-to-r from-blue-600 to-purple-600 rounded-full flex items-center justify-center mx-auto mb-4 shadow-lg">
                <i class="fas fa-bullhorn text-white text-3xl"></i>
            </div>
            <h1 class="text-4xl font-bold bg-gradient-to-r from-blue-600 via-purple-600 to-pink-600 bg-clip-text text-transparent">Create Announcement</h1>
            <p class="text-gray-600 text-lg mt-2">Share important news and updates with your congregation</p>
        </div>

        <form action="{{ route('announcements.store') }}" method="POST" enctype="multipart/form-data" class="space-y-8">
            @csrf
            
            <!-- Basic Information -->
            <div class="bg-white/80 backdrop-blur-xl rounded-3xl shadow-xl border border-white/30 p-8">
                <div class="flex items-center mb-8">
                    <div class="w-12 h-12 bg-gradient-to-r from-blue-500 to-indigo-500 rounded-2xl flex items-center justify-center shadow-lg mr-4">
                        <i class="fas fa-info-circle text-white text-lg"></i>
                    </div>
                    <div>
                        <h2 class="text-xl font-bold text-gray-900">Basic Information</h2>
                        <p class="text-gray-500 text-sm">Essential details about the announcement</p>
                    </div>
                </div>

                <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                    <!-- Title -->
                    <div class="lg:col-span-2">
                        <label for="title" class="block text-sm font-semibold text-gray-800 mb-2">
                            Announcement Title <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="title" id="title" required 
                               class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md" 
                               placeholder="Enter announcement title" value="{{ old('title') }}">
                        @error('title')
                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Type -->
                    <div>
                        <label for="type" class="block text-sm font-semibold text-gray-800 mb-2">
                            Type <span class="text-red-500">*</span>
                        </label>
                        <select name="type" id="type" required 
                                class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md">
                            <option value="">Select Type</option>
                            <option value="general" {{ old('type') == 'general' ? 'selected' : '' }}>General</option>
                            <option value="event" {{ old('type') == 'event' ? 'selected' : '' }}>Event</option>
                            <option value="prayer_request" {{ old('type') == 'prayer_request' ? 'selected' : '' }}>Prayer Request</option>
                            <option value="urgent" {{ old('type') == 'urgent' ? 'selected' : '' }}>Urgent</option>
                            <option value="celebration" {{ old('type') == 'celebration' ? 'selected' : '' }}>Celebration</option>
                            <option value="ministry" {{ old('type') == 'ministry' ? 'selected' : '' }}>Ministry</option>
                        </select>
                        @error('type')
                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Priority -->
                    <div>
                        <label for="priority" class="block text-sm font-semibold text-gray-800 mb-2">
                            Priority <span class="text-red-500">*</span>
                        </label>
                        <select name="priority" id="priority" required 
                                class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md">
                            <option value="">Select Priority</option>
                            <option value="low" {{ old('priority') == 'low' ? 'selected' : '' }}>Low</option>
                            <option value="medium" {{ old('priority') == 'medium' ? 'selected' : '' }}>Medium</option>
                            <option value="high" {{ old('priority') == 'high' ? 'selected' : '' }}>High</option>
                            <option value="urgent" {{ old('priority') == 'urgent' ? 'selected' : '' }}>Urgent</option>
                        </select>
                        @error('priority')
                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Publish Date -->
                    <div>
                        <label for="publish_date" class="block text-sm font-semibold text-gray-800 mb-2">
                            Publish Date <span class="text-red-500">*</span>
                        </label>
                        <input type="datetime-local" name="publish_date" id="publish_date" required 
                               class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md" 
                               value="{{ old('publish_date', now()->format('Y-m-d\TH:i')) }}">
                        @error('publish_date')
                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Expire Date -->
                    <div>
                        <label for="expire_date" class="block text-sm font-semibold text-gray-800 mb-2">
                            Expire Date (Optional)
                        </label>
                        <input type="datetime-local" name="expire_date" id="expire_date" 
                               class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md" 
                               value="{{ old('expire_date') }}">
                        @error('expire_date')
                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Content -->
                    <div class="lg:col-span-3">
                        <label for="content" class="block text-sm font-semibold text-gray-800 mb-2">
                            Announcement Content <span class="text-red-500">*</span>
                        </label>
                        <textarea name="content" id="content" rows="6" required 
                                  class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md resize-none" 
                                  placeholder="Write your announcement content here...">{{ old('content') }}</textarea>
                        @error('content')
                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Target Audience -->
            <div class="bg-white/80 backdrop-blur-xl rounded-3xl shadow-xl border border-white/30 p-8">
                <div class="flex items-center mb-8">
                    <div class="w-12 h-12 bg-gradient-to-r from-green-500 to-teal-500 rounded-2xl flex items-center justify-center shadow-lg mr-4">
                        <i class="fas fa-users text-white text-lg"></i>
                    </div>
                    <div>
                        <h2 class="text-xl font-bold text-gray-900">Target Audience</h2>
                        <p class="text-gray-500 text-sm">Who should receive this announcement</p>
                    </div>
                </div>

                <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                    <label class="flex items-center p-4 bg-white/50 rounded-2xl border-2 border-gray-200/50 hover:border-blue-300 transition-all duration-300 cursor-pointer">
                        <input type="checkbox" name="target_audience[]" value="all_members" class="w-5 h-5 text-blue-600 rounded focus:ring-blue-500" {{ in_array('all_members', old('target_audience', [])) ? 'checked' : '' }}>
                        <span class="ml-3 text-sm font-medium text-gray-700">All Members</span>
                    </label>
                    
                    <label class="flex items-center p-4 bg-white/50 rounded-2xl border-2 border-gray-200/50 hover:border-blue-300 transition-all duration-300 cursor-pointer">
                        <input type="checkbox" name="target_audience[]" value="youth" class="w-5 h-5 text-blue-600 rounded focus:ring-blue-500" {{ in_array('youth', old('target_audience', [])) ? 'checked' : '' }}>
                        <span class="ml-3 text-sm font-medium text-gray-700">Youth</span>
                    </label>
                    
                    <label class="flex items-center p-4 bg-white/50 rounded-2xl border-2 border-gray-200/50 hover:border-blue-300 transition-all duration-300 cursor-pointer">
                        <input type="checkbox" name="target_audience[]" value="children" class="w-5 h-5 text-blue-600 rounded focus:ring-blue-500" {{ in_array('children', old('target_audience', [])) ? 'checked' : '' }}>
                        <span class="ml-3 text-sm font-medium text-gray-700">Children</span>
                    </label>
                    
                    <label class="flex items-center p-4 bg-white/50 rounded-2xl border-2 border-gray-200/50 hover:border-blue-300 transition-all duration-300 cursor-pointer">
                        <input type="checkbox" name="target_audience[]" value="adults" class="w-5 h-5 text-blue-600 rounded focus:ring-blue-500" {{ in_array('adults', old('target_audience', [])) ? 'checked' : '' }}>
                        <span class="ml-3 text-sm font-medium text-gray-700">Adults</span>
                    </label>
                    
                    <label class="flex items-center p-4 bg-white/50 rounded-2xl border-2 border-gray-200/50 hover:border-blue-300 transition-all duration-300 cursor-pointer">
                        <input type="checkbox" name="target_audience[]" value="leaders" class="w-5 h-5 text-blue-600 rounded focus:ring-blue-500" {{ in_array('leaders', old('target_audience', [])) ? 'checked' : '' }}>
                        <span class="ml-3 text-sm font-medium text-gray-700">Leaders</span>
                    </label>
                    
                    <label class="flex items-center p-4 bg-white/50 rounded-2xl border-2 border-gray-200/50 hover:border-blue-300 transition-all duration-300 cursor-pointer">
                        <input type="checkbox" name="target_audience[]" value="visitors" class="w-5 h-5 text-blue-600 rounded focus:ring-blue-500" {{ in_array('visitors', old('target_audience', [])) ? 'checked' : '' }}>
                        <span class="ml-3 text-sm font-medium text-gray-700">Visitors</span>
                    </label>
                    
                    <label class="flex items-center p-4 bg-white/50 rounded-2xl border-2 border-gray-200/50 hover:border-blue-300 transition-all duration-300 cursor-pointer">
                        <input type="checkbox" name="target_audience[]" value="men" class="w-5 h-5 text-blue-600 rounded focus:ring-blue-500" {{ in_array('men', old('target_audience', [])) ? 'checked' : '' }}>
                        <span class="ml-3 text-sm font-medium text-gray-700">Men</span>
                    </label>
                    
                    <label class="flex items-center p-4 bg-white/50 rounded-2xl border-2 border-gray-200/50 hover:border-blue-300 transition-all duration-300 cursor-pointer">
                        <input type="checkbox" name="target_audience[]" value="women" class="w-5 h-5 text-blue-600 rounded focus:ring-blue-500" {{ in_array('women', old('target_audience', [])) ? 'checked' : '' }}>
                        <span class="ml-3 text-sm font-medium text-gray-700">Women</span>
                    </label>
                </div>
            </div>

            <!-- Media & Attachments -->
            <div class="bg-white/80 backdrop-blur-xl rounded-3xl shadow-xl border border-white/30 p-8">
                <div class="flex items-center mb-8">
                    <div class="w-12 h-12 bg-gradient-to-r from-purple-500 to-pink-500 rounded-2xl flex items-center justify-center shadow-lg mr-4">
                        <i class="fas fa-image text-white text-lg"></i>
                    </div>
                    <div>
                        <h2 class="text-xl font-bold text-gray-900">Media & Attachments</h2>
                        <p class="text-gray-500 text-sm">Add images and files to your announcement</p>
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Image Upload -->
                    <div>
                        <label for="image" class="block text-sm font-semibold text-gray-800 mb-2">
                            Featured Image
                        </label>
                        <div class="relative">
                            <input type="file" name="image" id="image" accept="image/*" 
                                   class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100">
                            <p class="text-xs text-gray-500 mt-1">JPG, PNG, GIF up to 2MB</p>
                        </div>
                        @error('image')
                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Attachment Upload -->
                    <div>
                        <label for="attachment" class="block text-sm font-semibold text-gray-800 mb-2">
                            Attachment
                        </label>
                        <div class="relative">
                            <input type="file" name="attachment" id="attachment" 
                                   class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-purple-50 file:text-purple-700 hover:file:bg-purple-100">
                            <p class="text-xs text-gray-500 mt-1">PDF, DOC, DOCX up to 10MB</p>
                        </div>
                        @error('attachment')
                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Distribution Settings -->
            <div class="bg-white/80 backdrop-blur-xl rounded-3xl shadow-xl border border-white/30 p-8">
                <div class="flex items-center mb-8">
                    <div class="w-12 h-12 bg-gradient-to-r from-orange-500 to-red-500 rounded-2xl flex items-center justify-center shadow-lg mr-4">
                        <i class="fas fa-paper-plane text-white text-lg"></i>
                    </div>
                    <div>
                        <h2 class="text-xl font-bold text-gray-900">Distribution Settings</h2>
                        <p class="text-gray-500 text-sm">How should this announcement be distributed</p>
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                    <!-- Send Email -->
                    <label class="flex items-center p-4 bg-gradient-to-r from-blue-50 to-indigo-50 rounded-2xl border-2 border-blue-200/50 hover:border-blue-300 transition-all duration-300 cursor-pointer">
                        <input type="checkbox" name="send_email" value="1" class="w-5 h-5 text-blue-600 rounded focus:ring-blue-500" {{ old('send_email') ? 'checked' : '' }}>
                        <div class="ml-3">
                            <div class="text-sm font-semibold text-gray-800">Send Email</div>
                            <div class="text-xs text-gray-600">Email notifications</div>
                        </div>
                    </label>

                    <!-- Send SMS -->
                    <label class="flex items-center p-4 bg-gradient-to-r from-green-50 to-teal-50 rounded-2xl border-2 border-green-200/50 hover:border-green-300 transition-all duration-300 cursor-pointer">
                        <input type="checkbox" name="send_sms" value="1" class="w-5 h-5 text-green-600 rounded focus:ring-green-500" {{ old('send_sms') ? 'checked' : '' }}>
                        <div class="ml-3">
                            <div class="text-sm font-semibold text-gray-800">Send SMS</div>
                            <div class="text-xs text-gray-600">Text messages</div>
                        </div>
                    </label>

                    <!-- Display on Website -->
                    <label class="flex items-center p-4 bg-gradient-to-r from-purple-50 to-pink-50 rounded-2xl border-2 border-purple-200/50 hover:border-purple-300 transition-all duration-300 cursor-pointer">
                        <input type="checkbox" name="display_on_website" value="1" class="w-5 h-5 text-purple-600 rounded focus:ring-purple-500" {{ old('display_on_website', true) ? 'checked' : '' }}>
                        <div class="ml-3">
                            <div class="text-sm font-semibold text-gray-800">Website</div>
                            <div class="text-xs text-gray-600">Show on website</div>
                        </div>
                    </label>

                    <!-- Display on Screens -->
                    <label class="flex items-center p-4 bg-gradient-to-r from-orange-50 to-red-50 rounded-2xl border-2 border-orange-200/50 hover:border-orange-300 transition-all duration-300 cursor-pointer">
                        <input type="checkbox" name="display_on_screens" value="1" class="w-5 h-5 text-orange-600 rounded focus:ring-orange-500" {{ old('display_on_screens') ? 'checked' : '' }}>
                        <div class="ml-3">
                            <div class="text-sm font-semibold text-gray-800">Digital Screens</div>
                            <div class="text-xs text-gray-600">Church displays</div>
                        </div>
                    </label>
                </div>
            </div>

            <!-- Notes -->
            <div class="bg-white/80 backdrop-blur-xl rounded-3xl shadow-xl border border-white/30 p-8">
                <div class="flex items-center mb-6">
                    <div class="w-12 h-12 bg-gradient-to-r from-gray-500 to-gray-600 rounded-2xl flex items-center justify-center shadow-lg mr-4">
                        <i class="fas fa-sticky-note text-white text-lg"></i>
                    </div>
                    <div>
                        <h2 class="text-xl font-bold text-gray-900">Additional Notes</h2>
                        <p class="text-gray-500 text-sm">Internal notes for this announcement</p>
                    </div>
                </div>

                <textarea name="notes" id="notes" rows="3" 
                          class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md resize-none" 
                          placeholder="Add any internal notes or reminders about this announcement...">{{ old('notes') }}</textarea>
                @error('notes')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <!-- Action Buttons -->
            <div class="flex flex-col sm:flex-row gap-4 pt-8">
                <button type="submit" name="action" value="publish" class="flex-1 bg-gradient-to-r from-blue-600 via-purple-600 to-indigo-600 text-white font-bold py-4 px-8 rounded-2xl hover:from-blue-700 hover:via-purple-700 hover:to-indigo-700 transition-all duration-300 shadow-lg hover:shadow-xl transform hover:scale-105 flex items-center justify-center">
                    <i class="fas fa-bullhorn mr-3"></i>
                    Create & Publish
                </button>
                <button type="submit" name="action" value="draft" class="flex-1 bg-gradient-to-r from-gray-500 to-gray-600 text-white font-bold py-4 px-8 rounded-2xl hover:from-gray-600 hover:to-gray-700 transition-all duration-300 shadow-lg hover:shadow-xl transform hover:scale-105 flex items-center justify-center">
                    <i class="fas fa-save mr-3"></i>
                    Save as Draft
                </button>
                <a href="{{ route('announcements.index') }}" class="flex-1 bg-white border-2 border-gray-300 text-gray-700 font-bold py-4 px-8 rounded-2xl hover:bg-gray-50 hover:border-gray-400 transition-all duration-300 shadow-lg hover:shadow-xl flex items-center justify-center">
                    <i class="fas fa-arrow-left mr-3"></i>
                    Back to List
                </a>
            </div>
        </form>
    </div>
</div>

<script>
// Character counter for content
const contentTextarea = document.getElementById('content');
const maxLength = 2000;

function updateCharacterCount() {
    const currentLength = contentTextarea.value.length;
    const remaining = maxLength - currentLength;
    
    // Create or update character counter
    let counter = document.getElementById('char-counter');
    if (!counter) {
        counter = document.createElement('div');
        counter.id = 'char-counter';
        counter.className = 'text-xs text-gray-500 mt-1 text-right';
        contentTextarea.parentNode.appendChild(counter);
    }
    
    counter.textContent = `${currentLength}/${maxLength} characters`;
    counter.className = remaining < 100 ? 'text-xs text-red-500 mt-1 text-right' : 'text-xs text-gray-500 mt-1 text-right';
}

contentTextarea.addEventListener('input', updateCharacterCount);
updateCharacterCount();

// Priority color coding
const prioritySelect = document.getElementById('priority');
prioritySelect.addEventListener('change', function() {
    const priority = this.value;
    const colors = {
        'low': 'border-green-300 bg-green-50',
        'medium': 'border-yellow-300 bg-yellow-50',
        'high': 'border-orange-300 bg-orange-50',
        'urgent': 'border-red-300 bg-red-50'
    };
    
    // Reset classes
    this.className = this.className.replace(/border-\w+-300|bg-\w+-50/g, '');
    
    if (colors[priority]) {
        this.className += ' ' + colors[priority];
    }
});

// Image preview
const imageInput = document.getElementById('image');
imageInput.addEventListener('change', function(e) {
    const file = e.target.files[0];
    if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
            // Create or update preview
            let preview = document.getElementById('image-preview');
            if (!preview) {
                preview = document.createElement('img');
                preview.id = 'image-preview';
                preview.className = 'mt-4 max-w-xs h-32 object-cover rounded-lg shadow-md';
                imageInput.parentNode.appendChild(preview);
            }
            preview.src = e.target.result;
        };
        reader.readAsDataURL(file);
    }
});

// Form validation
document.querySelector('form').addEventListener('submit', function(e) {
    const requiredFields = this.querySelectorAll('[required]');
    let isValid = true;
    
    requiredFields.forEach(field => {
        if (!field.value.trim()) {
            isValid = false;
            field.classList.add('border-red-500');
            field.classList.remove('border-gray-200/50');
        } else {
            field.classList.remove('border-red-500');
            field.classList.add('border-gray-200/50');
        }
    });
    
    if (!isValid) {
        e.preventDefault();
        alert('Please fill in all required fields');
        // Scroll to first error
        const firstError = this.querySelector('.border-red-500');
        if (firstError) {
            firstError.scrollIntoView({ behavior: 'smooth', block: 'center' });
        }
    }
});

// Auto-save functionality
let autoSaveTimeout;
const form = document.querySelector('form');
const inputs = form.querySelectorAll('input, select, textarea');

inputs.forEach(input => {
    input.addEventListener('input', function() {
        clearTimeout(autoSaveTimeout);
        autoSaveTimeout = setTimeout(() => {
            // Show auto-save indicator
            showNotification('Changes auto-saved', 'success');
        }, 3000);
    });
});

function showNotification(message, type = 'info') {
    const notification = document.createElement('div');
    notification.className = `fixed top-4 right-4 px-6 py-3 rounded-lg text-white z-50 transition-all duration-300 ${
        type === 'success' ? 'bg-green-500' : 
        type === 'error' ? 'bg-red-500' : 
        'bg-blue-500'
    }`;
    notification.textContent = message;
    
    document.body.appendChild(notification);
    
    setTimeout(() => {
        notification.remove();
    }, 3000);
}
</script>
@endsection
