<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class MemberIdPrefixSeeder extends Seeder
{
    /**
     * Run the database seeder.
     */
    public function run(): void
    {
        // Insert member ID prefix setting
        DB::table('settings')->updateOrInsert(
            ['key' => 'member_id_prefix'],
            [
                'key' => 'member_id_prefix',
                'value' => 'PCG',
                'type' => 'string',
                'category' => 'member',
                'description' => 'Prefix for member ID generation (e.g., PCG, PRESBY, etc.)',
                'created_at' => now(),
                'updated_at' => now(),
            ]
        );

        // Insert member ID format description setting
        DB::table('settings')->updateOrInsert(
            ['key' => 'member_id_format'],
            [
                'key' => 'member_id_format',
                'value' => 'PREFIX + YY + 0001',
                'type' => 'string',
                'category' => 'member',
                'description' => 'Format explanation for member ID generation',
                'created_at' => now(),
                'updated_at' => now(),
            ]
        );

        $this->command->info('Member ID prefix settings created successfully!');
        $this->command->info('Default prefix: PCG');
        $this->command->info('Format: PCG + YY + 0001 (e.g., PCG250001 for 2025)');
    }
}
