<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('members', function (Blueprint $table) {
            // Add missing columns that are expected by the application
            if (!Schema::hasColumn('members', 'highest_qualification')) {
                $table->enum('highest_qualification', [
                    'none', 'primary', 'jhs', 'shs', 'tertiary', 
                    'postgraduate', 'professional', 'other'
                ])->nullable()->after('employer');
            }
            
            if (!Schema::hasColumn('members', 'day_born')) {
                $table->enum('day_born', [
                    'Sunday', 'Monday', 'Tuesday', 'Wednesday', 
                    'Thursday', 'Friday', 'Saturday'
                ])->nullable()->after('date_of_birth');
            }
            
            if (!Schema::hasColumn('members', 'home_town')) {
                $table->string('home_town')->nullable()->after('marital_status');
            }
            
            if (!Schema::hasColumn('members', 'aka')) {
                $table->string('aka')->nullable()->after('home_town');
            }
            
            if (!Schema::hasColumn('members', 'whatsapp_phone')) {
                $table->string('whatsapp_phone')->nullable()->after('phone');
            }
            
            if (!Schema::hasColumn('members', 'profession')) {
                $table->string('profession')->nullable()->after('country');
            }
            
            if (!Schema::hasColumn('members', 'currently_schooling')) {
                $table->boolean('currently_schooling')->default(false)->after('highest_qualification');
            }
            
            if (!Schema::hasColumn('members', 'school_name')) {
                $table->string('school_name')->nullable()->after('currently_schooling');
            }
            
            if (!Schema::hasColumn('members', 'school_admission_date')) {
                $table->date('school_admission_date')->nullable()->after('school_name');
            }
            
            if (!Schema::hasColumn('members', 'school_completion_date')) {
                $table->date('school_completion_date')->nullable()->after('school_admission_date');
            }
            
            if (!Schema::hasColumn('members', 'school_telephone')) {
                $table->string('school_telephone')->nullable()->after('school_completion_date');
            }
            
            if (!Schema::hasColumn('members', 'school_location')) {
                $table->string('school_location', 500)->nullable()->after('school_telephone');
            }
            
            if (!Schema::hasColumn('members', 'guardian_name')) {
                $table->string('guardian_name')->nullable()->after('emergency_contact_phone');
            }
            
            if (!Schema::hasColumn('members', 'guardian_relationship')) {
                $table->string('guardian_relationship', 100)->nullable()->after('guardian_name');
            }
            
            if (!Schema::hasColumn('members', 'guardian_phone')) {
                $table->string('guardian_phone')->nullable()->after('guardian_relationship');
            }
            
            if (!Schema::hasColumn('members', 'guardian_address')) {
                $table->string('guardian_address', 500)->nullable()->after('guardian_phone');
            }
            
            if (!Schema::hasColumn('members', 'physically_challenged')) {
                $table->boolean('physically_challenged')->default(false)->after('special_needs');
            }
            
            if (!Schema::hasColumn('members', 'disability_type')) {
                $table->enum('disability_type', [
                    'mobility', 'visual', 'hearing', 'speech', 'intellectual', 
                    'learning', 'mental_health', 'chronic_illness', 'multiple', 'other'
                ])->nullable()->after('physically_challenged');
            }
            
            if (!Schema::hasColumn('members', 'place_of_baptism')) {
                $table->string('place_of_baptism')->nullable()->after('baptism_date');
            }
            
            if (!Schema::hasColumn('members', 'baptism_type')) {
                $table->enum('baptism_type', ['sprinkling', 'immersion', 'pouring', 'water', 'other'])
                    ->nullable()->after('place_of_baptism');
            }
            
            if (!Schema::hasColumn('members', 'baptism_officiating_minister')) {
                $table->string('baptism_officiating_minister')->nullable()->after('baptism_type');
            }
            
            if (!Schema::hasColumn('members', 'place_of_confirmation')) {
                $table->string('place_of_confirmation')->nullable()->after('confirmation_date');
            }
            
            if (!Schema::hasColumn('members', 'age_confirmed')) {
                $table->integer('age_confirmed')->nullable()->after('place_of_confirmation');
            }
            
            if (!Schema::hasColumn('members', 'confirmation_bible_verse')) {
                $table->string('confirmation_bible_verse', 500)->nullable()->after('age_confirmed');
            }
            
            if (!Schema::hasColumn('members', 'confirmation_officiating_minister')) {
                $table->string('confirmation_officiating_minister')->nullable()->after('confirmation_bible_verse');
            }
            
            if (!Schema::hasColumn('members', 'is_married')) {
                $table->boolean('is_married')->default(false)->after('confirmation_officiating_minister');
            }
            
            if (!Schema::hasColumn('members', 'marriage_date')) {
                $table->date('marriage_date')->nullable()->after('is_married');
            }
            
            if (!Schema::hasColumn('members', 'place_of_marriage')) {
                $table->string('place_of_marriage')->nullable()->after('marriage_date');
            }
            
            if (!Schema::hasColumn('members', 'marriage_type')) {
                $table->enum('marriage_type', ['traditional', 'customary', 'ordinance', 'other'])
                    ->nullable()->after('place_of_marriage');
            }
            
            if (!Schema::hasColumn('members', 'marriage_officiating_minister')) {
                $table->string('marriage_officiating_minister')->nullable()->after('marriage_type');
            }
            
            if (!Schema::hasColumn('members', 'has_family')) {
                $table->boolean('has_family')->default(false)->after('marriage_officiating_minister');
            }
            
            if (!Schema::hasColumn('members', 'year_group_id')) {
                $table->foreignId('year_group_id')->nullable()->after('family_id');
            }
            
            if (!Schema::hasColumn('members', 'password')) {
                $table->string('password')->nullable()->after('is_active');
            }
            
            if (!Schema::hasColumn('members', 'remember_token')) {
                $table->rememberToken()->after('password');
            }
        });
        
        // Fix membership_status ENUM to add 'pending'
        DB::statement("ALTER TABLE members MODIFY COLUMN membership_status ENUM('active', 'inactive', 'transferred', 'deceased', 'pending') DEFAULT 'active'");
        
        // Fix membership_type ENUM to match application expectations
        DB::statement("ALTER TABLE members MODIFY COLUMN membership_type ENUM('communicant', 'baptized', 'confirmed', 'long_distance', 'adherent', 'catechumen', 'member', 'visitor', 'friend', 'associate') DEFAULT 'member'");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('members', function (Blueprint $table) {
            // Drop added columns if they exist
            $columns = [
                'highest_qualification', 'day_born', 'home_town', 'aka', 'whatsapp_phone',
                'profession', 'currently_schooling', 'school_name', 'school_admission_date',
                'school_completion_date', 'school_telephone', 'school_location',
                'guardian_name', 'guardian_relationship', 'guardian_phone', 'guardian_address',
                'physically_challenged', 'disability_type', 'place_of_baptism', 'baptism_type',
                'baptism_officiating_minister', 'place_of_confirmation', 'age_confirmed',
                'confirmation_bible_verse', 'confirmation_officiating_minister', 'is_married',
                'marriage_date', 'place_of_marriage', 'marriage_type', 'marriage_officiating_minister',
                'has_family', 'year_group_id', 'password', 'remember_token'
            ];
            
            foreach ($columns as $column) {
                if (Schema::hasColumn('members', $column)) {
                    $table->dropColumn($column);
                }
            }
        });
        
        // Revert ENUM changes
        DB::statement("ALTER TABLE members MODIFY COLUMN membership_status ENUM('active', 'inactive', 'transferred', 'deceased') DEFAULT 'active'");
        DB::statement("ALTER TABLE members MODIFY COLUMN membership_type ENUM('member', 'visitor', 'friend', 'associate') DEFAULT 'member'");
    }
};
