<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('inventory_transactions', function (Blueprint $table) {
            $table->id();
            $table->string('transaction_code')->unique();
            $table->foreignId('item_id')->constrained('inventory_items')->onDelete('cascade');
            $table->enum('type', ['in', 'out', 'adjustment', 'transfer']); // Stock in, out, adjustment, transfer
            $table->integer('quantity');
            $table->integer('previous_stock');
            $table->integer('new_stock');
            $table->decimal('unit_cost', 10, 2)->nullable();
            $table->decimal('total_cost', 10, 2)->nullable();
            $table->string('reference_number')->nullable(); // Purchase order, invoice, etc.
            $table->text('reason')->nullable(); // Reason for transaction
            $table->string('performed_by')->nullable(); // Who performed the transaction
            $table->foreignId('member_id')->nullable()->constrained('members')->onDelete('set null'); // If member performed
            $table->date('transaction_date');
            $table->text('notes')->nullable();
            $table->timestamps();
            
            $table->index(['item_id', 'type']);
            $table->index('transaction_date');
            $table->index('transaction_code');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('inventory_transactions');
    }
};
