<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('inventory_items', function (Blueprint $table) {
            $table->id();
            $table->string('item_code')->unique();
            $table->string('name');
            $table->text('description')->nullable();
            $table->foreignId('category_id')->constrained('inventory_categories')->onDelete('cascade');
            $table->string('unit_of_measure')->default('pieces'); // pieces, kg, liters, etc.
            $table->decimal('unit_cost', 10, 2)->default(0);
            $table->integer('current_stock')->default(0);
            $table->integer('minimum_stock')->default(0);
            $table->integer('maximum_stock')->nullable();
            $table->string('location')->nullable(); // Storage location
            $table->string('supplier')->nullable();
            $table->string('supplier_contact')->nullable();
            $table->date('expiry_date')->nullable();
            $table->string('barcode')->nullable();
            $table->json('images')->nullable(); // Store multiple image paths
            $table->text('notes')->nullable();
            $table->boolean('is_active')->default(true);
            $table->boolean('track_expiry')->default(false);
            $table->timestamps();
            
            $table->index(['name', 'item_code']);
            $table->index('category_id');
            $table->index('current_stock');
            $table->index('is_active');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('inventory_items');
    }
};
