<?php

namespace App\Mail;

use App\Models\MemberPayment;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class PaymentReceiptEmail extends Mailable
{
    use Queueable, SerializesModels;

    public $payment;
    public $organizationName;

    /**
     * Create a new message instance.
     */
    public function __construct(MemberPayment $payment)
    {
        $this->payment = $payment;
        $this->organizationName = \DB::table('settings')
            ->where('key', 'organization_name')
            ->value('value') ?? 'Presbyterian Church of Ghana';
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Payment Receipt - ' . $this->payment->payment_reference,
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'emails.payment-receipt',
        );
    }

    /**
     * Get the attachments for the message.
     */
    public function attachments(): array
    {
        return [];
    }
}
