# Email Configuration Guide for PCG Database

## Problem
Emails are showing in the log but not actually being sent to members because the mail driver is set to `log`.

## Solution
Configure the application to use a real mail service (SMTP).

---

## Option 1: Gmail SMTP (Recommended for Testing)

### Step 1: Update .env file
Replace these values in your `.env` file:

```env
MAIL_MAILER=smtp
MAIL_HOST=smtp.gmail.com
MAIL_PORT=587
MAIL_USERNAME=your-gmail@gmail.com
MAIL_PASSWORD=your-app-password
MAIL_ENCRYPTION=tls
MAIL_FROM_ADDRESS="your-gmail@gmail.com"
MAIL_FROM_NAME="PCG DATABASE"
```

### Step 2: Generate Gmail App Password

1. Go to your Google Account: https://myaccount.google.com/
2. Select **Security** in the left menu
3. Under "How you sign in to Google," select **2-Step Verification**
   - If not enabled, enable it first
4. Scroll down to **App passwords**
5. Click **App passwords**
6. Select app: **Mail**
7. Select device: **Other (Custom name)**
8. Enter: "PCG Database"
9. Click **Generate**
10. Copy the 16-character password (no spaces)
11. Use this password in `MAIL_PASSWORD` in your .env

**Example:**
```env
MAIL_USERNAME=churchoffice@gmail.com
MAIL_PASSWORD=abcd efgh ijkl mnop  # Remove spaces: abcdefghijklmnop
MAIL_FROM_ADDRESS="churchoffice@gmail.com"
```

---

## Option 2: Mailtrap (Best for Development)

For testing without sending real emails:

```env
MAIL_MAILER=smtp
MAIL_HOST=smtp.mailtrap.io
MAIL_PORT=2525
MAIL_USERNAME=your-mailtrap-username
MAIL_PASSWORD=your-mailtrap-password
MAIL_ENCRYPTION=tls
MAIL_FROM_ADDRESS="noreply@pcgchurch.org"
MAIL_FROM_NAME="PCG DATABASE"
```

1. Sign up at: https://mailtrap.io
2. Go to **Email Testing** → **Inboxes**
3. Select your inbox
4. Copy the credentials from **SMTP Settings**

---

## Option 3: SendGrid (Production Ready)

For production use:

```env
MAIL_MAILER=smtp
MAIL_HOST=smtp.sendgrid.net
MAIL_PORT=587
MAIL_USERNAME=apikey
MAIL_PASSWORD=your-sendgrid-api-key
MAIL_ENCRYPTION=tls
MAIL_FROM_ADDRESS="noreply@yourchurch.org"
MAIL_FROM_NAME="PCG DATABASE"
```

1. Sign up at: https://sendgrid.com
2. Create an API Key
3. Use "apikey" as username
4. Use your API key as password

---

## Option 4: Other Email Providers

### Outlook/Office 365
```env
MAIL_MAILER=smtp
MAIL_HOST=smtp.office365.com
MAIL_PORT=587
MAIL_USERNAME=your-email@outlook.com
MAIL_PASSWORD=your-password
MAIL_ENCRYPTION=tls
```

### Yahoo Mail
```env
MAIL_MAILER=smtp
MAIL_HOST=smtp.mail.yahoo.com
MAIL_PORT=587
MAIL_USERNAME=your-email@yahoo.com
MAIL_PASSWORD=your-app-password
MAIL_ENCRYPTION=tls
```

---

## After Configuration

### 1. Clear Configuration Cache
Run this command in terminal:

```bash
cd /Applications/XAMPP/xamppfiles/htdocs/presby_app
php artisan config:clear
php artisan cache:clear
```

### 2. Test the Email

Visit the registration page and register a test member:
- URL: http://127.0.0.1:8000/register
- Use a real email address you can check
- Submit the form
- Check your inbox (and spam folder)

### 3. Check Logs if Issues

If emails still don't send, check:
```
/Applications/XAMPP/xamppfiles/htdocs/presby_app/storage/logs/laravel.log
```

---

## Email Templates in the System

The following emails are sent automatically:

1. **Member Registration** (`MemberRegistrationEmail`)
   - When: Member self-registers at `/register`
   - Status: Pending approval
   - Template: `resources/views/emails/member-registration.blade.php`

2. **Member Approval** (`MemberApprovedEmail`)
   - When: Admin approves a pending member
   - Status: Active
   - Template: `resources/views/emails/member-approved.blade.php`

3. **Member Welcome** (`MemberWelcomeEmail`)
   - When: Admin creates active member at `/add-member`
   - Status: Active immediately
   - Template: `resources/views/emails/member-welcome.blade.php`

4. **Payment Confirmation** (if implemented)
   - When: Payment is recorded for a member

---

## Troubleshooting

### Issue: "Connection refused"
**Solution:** Check MAIL_HOST and MAIL_PORT are correct

### Issue: "Authentication failed"
**Solution:** 
- For Gmail: Use App Password, not regular password
- Ensure 2-Step Verification is enabled
- Check username and password are correct

### Issue: "Connection timeout"
**Solution:**
- Check your internet connection
- Try changing MAIL_PORT to 465 and MAIL_ENCRYPTION to ssl
- Check firewall isn't blocking SMTP

### Issue: Emails go to spam
**Solution:**
- Use a professional email address
- Set proper MAIL_FROM_ADDRESS
- Consider using a dedicated email service (SendGrid, Mailgun)

### Issue: Still logging instead of sending
**Solution:**
- Run: `php artisan config:clear`
- Check .env has MAIL_MAILER=smtp (not "log")
- Restart your web server (XAMPP)

---

## Production Recommendations

For production (live church use):

1. **Use a dedicated email service:**
   - SendGrid (99,000 free emails/month)
   - Mailgun (5,000 free emails/month)
   - Amazon SES (very cheap)

2. **Use a professional email:**
   - Example: noreply@yourchurch.org
   - Not: personal Gmail account

3. **Set up SPF, DKIM records:**
   - Prevents emails from going to spam
   - Your email service will provide instructions

4. **Monitor email logs:**
   - Check regularly for failed sends
   - Set up alerts for email failures

---

## Current Status

✅ Email code is working correctly
❌ Mail driver was set to "log" (only logging)
✅ Updated to SMTP configuration
⚠️ You need to add your actual email credentials

**Next Steps:**
1. Choose an email option above
2. Update .env with your credentials
3. Run `php artisan config:clear`
4. Test by registering a member
5. Check email arrives

---

## Need Help?

If you continue to have issues:
1. Check the Laravel log for errors
2. Verify your email credentials work in another email client
3. Try using Mailtrap first to test without sending real emails
4. Ensure your .env file has no extra spaces or quotes in wrong places
