# Bulk Import Members Guide

## Overview
The bulk import feature allows administrators to register multiple church members at once using an Excel file. This is particularly useful when migrating from another system or registering many members simultaneously.

## How to Use

### Step 1: Access Bulk Import
1. Log in as an administrator
2. Navigate to **Members** in the sidebar
3. Click on **Bulk Import** from the dropdown menu

### Step 2: Download Template
1. Click the **"Download Excel Template"** button
2. This will download a pre-formatted Excel file with sample data
3. The template includes all required and optional fields

### Step 3: Prepare Your Data
Fill in the Excel template with member information:

#### Required Fields:
- **first_name**: Member's first name
- **last_name**: Member's last name  
- **email**: Valid email address (must be unique)
- **phone**: Phone number (must be unique)
- **gender**: Either "male" or "female"

#### Optional Fields:
- **date_of_birth**: Format: YYYY-MM-DD (e.g., 1990-01-15)
- **membership_type**: communicant, baptized, confirmed, long_distance, adherent, or catechumen (default: communicant)
- **membership_status**: active, inactive, transferred, or deceased (default: active)
- **marital_status**: single, married, divorced, or widowed (default: single)
- **address**: Home address
- **occupation**: Member's profession/job
- **emergency_contact_name**: Emergency contact person
- **emergency_contact_phone**: Emergency contact phone number
- **family_name**: Family name (will create/assign to family)

### Step 4: Upload and Import
1. Select your prepared Excel file
2. Click **"Import Members"**
3. Review the import results
4. Check for any errors and fix them if needed

## Important Notes

### File Requirements:
- **Supported formats**: .xlsx, .xls, .csv
- **Maximum file size**: 10MB
- **Column headers**: Must match the template exactly

### Default Settings:
- **Default password**: "password123" (members should change this on first login)
- **Membership date**: Set to current date
- **Status**: Active by default
- **Notifications**: Newsletter and SMS enabled by default

### Data Validation:
- Email addresses must be unique across all members
- Phone numbers must be unique across all members
- Dates must be in valid format (YYYY-MM-DD)
- Gender must be either "male" or "female"
- Membership types and statuses must match allowed values

### Family Assignment:
- If **family_name** is provided, the member will be assigned to that family
- If the family doesn't exist, it will be created automatically
- The first member imported for a family becomes the head of family

### Error Handling:
- Duplicate emails or phone numbers will be skipped
- Invalid data formats will be reported with row numbers
- The import will continue processing other rows even if some fail
- Detailed error reports are provided after import

## Troubleshooting

### Common Issues:
1. **"Member already exists"**: Email or phone number is already in use
2. **"Invalid date format"**: Use YYYY-MM-DD format for dates
3. **"Invalid gender"**: Must be exactly "male" or "female"
4. **"File too large"**: Reduce file size or split into multiple imports

### Tips for Success:
- Always use the provided template
- Test with a small batch first
- Ensure email addresses are valid and unique
- Double-check phone number formats
- Remove any empty rows from your Excel file

## Post-Import Tasks

After successful import:
1. **Review imported members** in the Members list
2. **Notify members** of their login credentials
3. **Assign members to ministries** if needed
4. **Update member photos** and additional details as required
5. **Verify family assignments** are correct

## Security Considerations

- Only administrators can perform bulk imports
- All imported members get the default password "password123"
- Members should be instructed to change their password on first login
- Consider sending login credentials through secure channels

## Support

If you encounter issues with bulk import:
1. Check the error messages for specific guidance
2. Verify your Excel file matches the template format
3. Ensure all required fields are filled
4. Contact your system administrator for technical support
